/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.oda.xml.util.ui;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.enablement.oda.xml.util.ISaxParserConsumer;
import org.eclipse.datatools.enablement.oda.xml.util.SaxParser;
import org.eclipse.datatools.enablement.oda.xml.util.XMLPath;
import org.eclipse.datatools.enablement.oda.xml.util.XMLSourceFromPath;
import org.eclipse.datatools.enablement.oda.xml.util.ui.ATreeNode;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XMLFileSchemaTreePopulator;
import org.eclipse.datatools.enablement.oda.xml.util.ui.XSDFileSchemaTreePopulator;

public class SchemaPopulationUtil {
    private static final String XSD_EXTENSION = ".XSD";

    public static Map getPrefixMapping(String xmlFileName, String xmlEncoding) throws OdaException {
        XMLSourceFromPath xmlSource = new XMLSourceFromPath(xmlFileName, xmlEncoding);
        SaxParser sp = new SaxParser(xmlSource, new ISaxParserConsumer(){

            public void endElement(XMLPath path) {
            }

            public void finish() {
            }

            public void manipulateData(XMLPath path, String value) {
            }

            public void startElement(XMLPath path) {
            }
        }, false);
        Thread spThread = new Thread(sp);
        spThread.start();
        try {
            spThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (sp == null || sp.exceptionOccurred()) {
            return new HashMap();
        }
        return sp.getPrefixMapping();
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, String xmlEncoding, int numberOfElementsAccessiable) throws OdaException, MalformedURLException, URISyntaxException {
        if (xsdFileName != null && xsdFileName.trim().length() > 0) {
            if (xmlFileName != null && xmlFileName.trim().length() > 0) {
                return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlFileName, xmlEncoding);
            }
            return XSDFileSchemaTreePopulator.getSchemaTree(xsdFileName, xmlEncoding);
        }
        return new XMLFileSchemaTreePopulator(numberOfElementsAccessiable).getSchemaTree(xmlFileName, xmlEncoding);
    }

    public static ATreeNode getSchemaTree(String xsdFileName, String xmlFileName, int numberOfElementsAccessiable) throws OdaException, MalformedURLException, URISyntaxException {
        return SchemaPopulationUtil.getSchemaTree(xsdFileName, xmlFileName, null, numberOfElementsAccessiable);
    }
}

