/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.ui.internal.assembly.wizard;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jst.common.ui.internal.JstCommonUIPlugin;
import org.eclipse.jst.common.ui.internal.Messages;
import org.eclipse.jst.common.ui.internal.assembly.wizard.JarReferenceWizardFragment;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.componentcore.ui.internal.taskwizard.IWizardHandle;

public class ExternalJarReferenceWizardFragment
extends JarReferenceWizardFragment {
    public Composite createComposite(Composite parent, IWizardHandle handle) {
        Composite c = super.createComposite(parent, handle);
        handle.setTitle(Messages.ExternalArchiveTitle);
        handle.setDescription(Messages.ExternalArchiveDescription);
        return c;
    }

    protected void buttonPressed() {
        this.selected = ExternalJarReferenceWizardFragment.chooseExternalArchiveEntries(this.browse.getShell());
        this.viewer.refresh();
        this.isComplete = this.selected != null && this.selected.length > 0;
        this.handle.update();
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException {
        IVirtualComponent rootComponent = (IVirtualComponent)this.getTaskModel().getObject("root.component");
        String runtimeLoc = (String)this.getTaskModel().getObject("default.library.location");
        if (this.selected != null && this.selected.length > 0) {
            ArrayList<VirtualReference> refList = new ArrayList<VirtualReference>();
            new ArrayList();
            int i = 0;
            while (i < this.selected.length) {
                String type = "lib/";
                IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + this.selected[i].toString()));
                VirtualReference ref = new VirtualReference(rootComponent, archive);
                ref.setArchiveName(this.selected[i].lastSegment());
                if (runtimeLoc != null) {
                    ref.setRuntimePath(new Path(runtimeLoc).makeAbsolute());
                }
                refList.add(ref);
                ++i;
            }
            IVirtualReference[] finalRefs = refList.toArray(new IVirtualReference[refList.size()]);
            this.getTaskModel().putObject("dependency.reference.final", (Object)finalRefs);
        }
    }

    private static IPath[] chooseExternalArchiveEntries(Shell shell) {
        String lastUsedPath = JstCommonUIPlugin.getDefault().getDialogSettings().get("org.eclipse.jst.common.ui.lastextarchive");
        if (lastUsedPath == null) {
            lastUsedPath = "";
        }
        FileDialog dialog = new FileDialog(shell, 2);
        dialog.setText(Messages.ArchiveDialogNewTitle);
        String[] extensions = new String[]{"*.jar;*.war;*.rar;*.zip", "*.*"};
        dialog.setFilterExtensions(extensions);
        dialog.setFilterPath(lastUsedPath);
        String res = dialog.open();
        if (res == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        IPath[] elems = new IPath[nChosen];
        int i = 0;
        while (i < nChosen) {
            elems[i] = filterPath.append(fileNames[i]).makeAbsolute();
            ++i;
        }
        JstCommonUIPlugin.getDefault().getDialogSettings().put("org.eclipse.jst.common.ui.lastextarchive", dialog.getFilterPath());
        return elems;
    }
}

