/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.viewer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.URLHyperlink;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.mylyn.wikitext.ui.annotation.AnchorHrefAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.AnchorNameAnnotation;
import org.eclipse.mylyn.wikitext.ui.annotation.IdAnnotation;

public class AnnotationHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (textViewer instanceof ISourceViewer) {
            int interestingOffset = region.getOffset() + region.getLength();
            ISourceViewer sourceViewer = (ISourceViewer)textViewer;
            IAnnotationModel annotationModel = sourceViewer.getAnnotationModel();
            if (annotationModel != null) {
                ArrayList<AnchorHrefAnnotation> hrefs = null;
                Iterator iterator = annotationModel.getAnnotationIterator();
                while (iterator.hasNext()) {
                    AnchorHrefAnnotation href;
                    Position position;
                    Annotation annotation = (Annotation)iterator.next();
                    if (!(annotation instanceof AnchorHrefAnnotation) || (position = annotationModel.getPosition((Annotation)(href = (AnchorHrefAnnotation)annotation))).getOffset() > interestingOffset || position.getOffset() + position.getLength() < interestingOffset) continue;
                    if (hrefs == null) {
                        hrefs = new ArrayList<AnchorHrefAnnotation>();
                    }
                    hrefs.add(href);
                }
                if (hrefs != null) {
                    if (hrefs.size() > 1) {
                        Collections.sort(hrefs, new OffsetComparator(annotationModel));
                    }
                    return new IHyperlink[]{this.createHyperlink(sourceViewer, annotationModel, (AnchorHrefAnnotation)((Object)hrefs.get(0)))};
                }
            }
        }
        return null;
    }

    protected IHyperlink createHyperlink(ISourceViewer viewer, IAnnotationModel annotationModel, AnchorHrefAnnotation anchorHrefAnnotation) {
        Position position = annotationModel.getPosition((Annotation)anchorHrefAnnotation);
        Region region = new Region(position.getOffset(), position.getLength());
        String href = anchorHrefAnnotation.getAnchorHref();
        if (href != null && href.startsWith("#")) {
            return new DocumentHyperlink(viewer, (IRegion)region, href);
        }
        return this.createUrlHyperlink((IRegion)region, href);
    }

    protected IHyperlink createUrlHyperlink(IRegion region, String href) {
        return new URLHyperlink(region, href);
    }

    protected static class DocumentHyperlink
    implements IHyperlink {
        private final ISourceViewer viewer;
        private final IRegion region;
        private final String href;

        public DocumentHyperlink(ISourceViewer viewer, IRegion region, String href) {
            this.viewer = viewer;
            this.region = region;
            this.href = href;
        }

        public IRegion getHyperlinkRegion() {
            return this.region;
        }

        public String getHyperlinkText() {
            return null;
        }

        public String getTypeLabel() {
            return null;
        }

        public void open() {
            String lookingFor = this.href.substring(1);
            IAnnotationModel annotationModel = this.viewer.getAnnotationModel();
            Iterator iterator = annotationModel.getAnnotationIterator();
            while (iterator.hasNext()) {
                AnchorNameAnnotation nameAnnotation;
                IdAnnotation idAnnotation;
                Annotation annotation = (Annotation)iterator.next();
                if (annotation instanceof IdAnnotation ? !(idAnnotation = (IdAnnotation)annotation).getElementId().equals(lookingFor) : !(annotation instanceof AnchorNameAnnotation) || !(nameAnnotation = (AnchorNameAnnotation)annotation).getAnchorName().equals(lookingFor)) continue;
                Position position = annotationModel.getPosition(annotation);
                this.viewer.getTextWidget().setSelection(position.getOffset());
                break;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OffsetComparator
    implements Comparator<Annotation> {
        private final IAnnotationModel annotationModel;

        public OffsetComparator(IAnnotationModel annotationModel) {
            this.annotationModel = annotationModel;
        }

        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (o1 == o2) {
                return 0;
            }
            Position p1 = this.annotationModel.getPosition(o1);
            Position p2 = this.annotationModel.getPosition(o2);
            if (p1.getOffset() > p2.getOffset()) {
                return -1;
            }
            if (p2.getOffset() > p1.getOffset()) {
                return 1;
            }
            if (p1.getLength() > p2.getLength()) {
                return -1;
            }
            if (p2.getLength() > p1.getLength()) {
                return 1;
            }
            return Integer.valueOf(System.identityHashCode(p1)).compareTo(System.identityHashCode(p2));
        }
    }
}

