/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.mediawiki.core.validation;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.mediawiki.core.validation.Messages;
import org.eclipse.mylyn.wikitext.core.validation.ValidationProblem;
import org.eclipse.mylyn.wikitext.core.validation.ValidationRule;

public class CommentValidationRule
extends ValidationRule {
    private static Pattern commentPattern = Pattern.compile("(<!-{3,}|-{3,}>)", 8);

    public ValidationProblem findProblem(String markup, int offset, int length) {
        Matcher matcher = commentPattern.matcher(markup);
        if (offset > 0 || length != markup.length()) {
            matcher.region(offset, offset + length);
        }
        if (matcher.find()) {
            int problemOffset = matcher.start();
            int problemLength = Math.max(2, matcher.end() - problemOffset);
            return new ValidationProblem(ValidationProblem.Severity.WARNING, Messages.getString("CommentValidationRule.1"), problemOffset, problemLength);
        }
        return null;
    }
}

