/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.soapengine.processor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.xml.namespace.QName;
import org.apache.axis.AxisFault;
import org.eclipse.birt.report.context.IContext;
import org.eclipse.birt.report.engine.api.InstanceID;
import org.eclipse.birt.report.resource.BirtResources;
import org.eclipse.birt.report.service.actionhandler.IActionHandler;
import org.eclipse.birt.report.soapengine.api.GetUpdatedObjectsResponse;
import org.eclipse.birt.report.soapengine.api.Operation;
import org.eclipse.birt.report.soapengine.processor.IComponentProcessor;
import org.eclipse.birt.report.utility.BirtUtility;

public abstract class AbstractBaseComponentProcessor
implements IComponentProcessor {
    protected abstract Hashtable getOpMap();

    protected abstract String[] getOperatorList();

    protected abstract void __executeAction(IActionHandler var1, IContext var2, Operation var3, GetUpdatedObjectsResponse var4) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBaseComponentProcessor() {
        Hashtable map = this.getOpMap();
        if (map.size() <= 0) {
            Hashtable hashtable = map;
            synchronized (hashtable) {
                this.initOpMap(map, this.getOperatorList());
            }
        }
    }

    protected void initOpMap(Hashtable operatorMap, String[] operators) {
        for (int i = 0; i < operators.length; ++i) {
            String methodName = "handle" + operators[i];
            Class[] args = new Class[]{IContext.class, Operation.class, GetUpdatedObjectsResponse.class};
            try {
                Method method = this.getClass().getMethod(methodName, args);
                operatorMap.put(operators[i].toUpperCase(), method);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                assert (false);
                continue;
            }
        }
    }

    public void process(IContext context, Operation op, GetUpdatedObjectsResponse response) throws RemoteException {
        assert (context != null);
        String operator = op.getOperator().toUpperCase();
        if (operator == null) {
            AxisFault fault = new AxisFault();
            fault.setFaultCode(new QName(this.getClass().getName()));
            fault.setFaultString(BirtResources.getMessage("birt.viewer.componentProcessorException.MISSING_OPERATOR"));
            throw fault;
        }
        Method method = (Method)this.getOpMap().get(operator);
        if (method != null) {
            try {
                method.invoke((Object)this, context, op, response);
            }
            catch (InvocationTargetException e) {
                Exception target = (Exception)e.getTargetException();
                throw BirtUtility.makeAxisFault(target);
            }
            catch (Exception e) {
                AxisFault fault = new AxisFault();
                fault.setFaultCode(new QName("Clear out this."));
                fault.setFaultString(e.getLocalizedMessage());
                throw fault;
            }
        }
    }

    protected void executeAction(IActionHandler action, IContext context, Operation op, GetUpdatedObjectsResponse response) throws RemoteException {
        this.__executeAction(action, context, op, response);
    }

    protected long getDesignId(String instanceId) {
        return InstanceID.parse((String)instanceId).getComponentID();
    }
}

