/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.ListingElementExecutor;
import org.eclipse.birt.report.engine.executor.ReportItemExecutor;
import org.eclipse.birt.report.engine.extension.IQueryResultSet;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.ir.BandDesign;
import org.eclipse.birt.report.engine.ir.GroupDesign;
import org.eclipse.birt.report.engine.ir.ListingDesign;
import org.eclipse.birt.report.engine.ir.ReportItemDesign;

public abstract class GroupExecutor
extends ReportItemExecutor {
    boolean endOfGroup;
    boolean hiddenDetail;
    boolean needPageBreak;
    ListingElementExecutor listingExecutor;
    ReportItemDesign[] executableElements = new ReportItemDesign[3];
    int totalElements;
    int currentElement;

    protected GroupExecutor(ExecutorManager manager, int type) {
        super(manager, type);
    }

    public void close() throws BirtException {
        this.endOfGroup = false;
        this.hiddenDetail = false;
        this.needPageBreak = false;
        this.listingExecutor = null;
        super.close();
    }

    void setLisingExecutor(ListingElementExecutor executor) {
        this.listingExecutor = executor;
        this.rset = this.listingExecutor.rset;
    }

    /*
     * Exception decompiling
     */
    public boolean hasNextChild() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public IReportItemExecutor getNextChild() {
        if (this.hasNextChild()) {
            ReportItemDesign nextDesign;
            ReportItemExecutor nextExecutor;
            assert (this.currentElement < this.totalElements);
            if ((nextExecutor = this.manager.createExecutor(this, nextDesign = this.executableElements[this.currentElement++])) instanceof GroupExecutor) {
                GroupExecutor groupExecutor = (GroupExecutor)nextExecutor;
                groupExecutor.setLisingExecutor(this.listingExecutor);
            }
            return nextExecutor;
        }
        return null;
    }

    protected void prepareToExecuteChildren() {
        this.collectExecutableElements();
    }

    void collectExecutableElements() {
        this.currentElement = 0;
        this.totalElements = 0;
        this.endOfGroup = false;
        try {
            int endGroup;
            BandDesign header;
            ListingDesign listingDesign = (ListingDesign)this.listingExecutor.getDesign();
            IQueryResultSet rset = this.listingExecutor.getResultSet();
            GroupDesign groupDesign = (GroupDesign)this.getDesign();
            int groupCount = listingDesign.getGroupCount();
            int groupLevel = groupDesign.getGroupLevel() + 1;
            int startGroup = rset.getStartingGroupLevel();
            this.hiddenDetail = groupDesign.getHideDetail();
            if (startGroup <= groupLevel && (header = groupDesign.getHeader()) != null) {
                this.executableElements[this.totalElements++] = header;
            }
            if (!this.hiddenDetail) {
                if (groupCount > groupLevel) {
                    this.executableElements[this.totalElements++] = listingDesign.getGroup(groupLevel);
                } else {
                    BandDesign detail = listingDesign.getDetail();
                    if (detail != null) {
                        this.executableElements[this.totalElements++] = listingDesign.getDetail();
                    }
                }
            }
            if ((endGroup = rset.getEndingGroupLevel()) <= groupLevel) {
                BandDesign footer = groupDesign.getFooter();
                if (footer != null) {
                    this.executableElements[this.totalElements++] = groupDesign.getFooter();
                }
                if (endGroup <= groupLevel) {
                    this.endOfGroup = true;
                }
            }
        }
        catch (BirtException ex) {
            this.context.addException(this.getDesign(), ex);
        }
    }

    protected void handlePageBreakBeforeOfGroup() {
        try {
            boolean needPageBreak = false;
            GroupDesign groupDesign = (GroupDesign)this.design;
            if (groupDesign != null) {
                String pageBreakBefore = groupDesign.getPageBreakBefore();
                int groupLevel = groupDesign.getGroupLevel();
                if ("always".equals(pageBreakBefore)) {
                    needPageBreak = true;
                }
                if ("always-excluding-first".equals(pageBreakBefore) && this.rset.getStartingGroupLevel() > groupLevel) {
                    needPageBreak = true;
                }
                if (needPageBreak) {
                    this.content.getStyle().setProperty(47, IStyle.ALWAYS_VALUE);
                }
            }
        }
        catch (BirtException ex) {
            this.context.addException(this.getDesign(), ex);
        }
    }

    protected void handlePageBreakInsideOfGroup() {
        String pageBreakInside;
        GroupDesign groupDesign = (GroupDesign)this.design;
        if (groupDesign != null && "avoid".equals(pageBreakInside = groupDesign.getPageBreakInside())) {
            this.content.getStyle().setProperty(57, IStyle.AVOID_VALUE);
        }
    }

    protected void handlePageBreakAfterOfGroup() {
        boolean needPageBreak = false;
        GroupDesign groupDesign = (GroupDesign)this.design;
        if (groupDesign != null) {
            String pageBreakAfter = groupDesign.getPageBreakAfter();
            if ("always".equals(pageBreakAfter)) {
                needPageBreak = true;
            }
            if (needPageBreak) {
                this.content.getStyle().setProperty(58, IStyle.ALWAYS_VALUE);
            }
        }
    }

    protected void handlePageBreakAfter() {
    }

    protected void handlePageBreakBefore() {
    }

    protected void handlePageBreakAfterExclusingLast() {
        try {
            GroupDesign groupDesign = (GroupDesign)this.design;
            if (groupDesign != null) {
                int endGroup;
                String pageBreakAfter = groupDesign.getPageBreakAfter();
                int groupLevel = groupDesign.getGroupLevel();
                if ("always-excluding-last".equals(pageBreakAfter) && (endGroup = this.rset.getEndingGroupLevel()) >= groupLevel + 1) {
                    this.setPageBreakBeforeForNextGroup();
                }
            }
        }
        catch (BirtException ex) {
            this.context.addException(this.getDesign(), ex);
        }
    }

    protected void handlePageBreakAfterOfPreviousGroup() {
        if (this.parent instanceof GroupExecutor) {
            GroupExecutor pGroup = (GroupExecutor)this.parent;
            if (pGroup.needPageBreak) {
                this.content.getStyle().setProperty(47, IStyle.ALWAYS_VALUE);
                pGroup.needPageBreak = false;
            }
        } else if (this.parent instanceof ListingElementExecutor) {
            ListingElementExecutor pList = (ListingElementExecutor)this.parent;
            if (pList.needPageBreak) {
                this.content.getStyle().setProperty(47, IStyle.ALWAYS_VALUE);
                pList.needPageBreak = false;
            }
        }
    }

    protected void setPageBreakBeforeForNextGroup() {
        if (this.parent instanceof GroupExecutor) {
            GroupExecutor pGroup = (GroupExecutor)this.parent;
            pGroup.needPageBreak = true;
        } else if (this.parent instanceof ListingElementExecutor) {
            ListingElementExecutor pList = (ListingElementExecutor)this.parent;
            pList.needPageBreak = true;
        }
    }
}

