/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.executor;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IForeignContent;
import org.eclipse.birt.report.engine.content.impl.ForeignContent;
import org.eclipse.birt.report.engine.executor.ExecutorManager;
import org.eclipse.birt.report.engine.executor.QueryItemExecutor;
import org.eclipse.birt.report.engine.ir.DynamicTextItemDesign;

public class DynamicTextItemExecutor
extends QueryItemExecutor {
    DynamicTextItemExecutor(ExecutorManager manager) {
        super(manager, 5);
    }

    public IContent execute() {
        String rawType;
        Object content;
        DynamicTextItemDesign textDesign = (DynamicTextItemDesign)this.getDesign();
        IForeignContent textContent = this.report.createForeignContent();
        this.setContent(textContent);
        this.executeQuery();
        this.initializeContent(textDesign, textContent);
        this.processStyle(textDesign, textContent);
        this.processBookmark(textDesign, textContent);
        this.processVisibility(textDesign, textContent);
        this.processAction(textDesign, textContent);
        this.processUserProperties(textDesign, textContent);
        String contentType = textDesign.getContentType();
        if (contentType == null) {
            contentType = "auto";
        }
        if ((content = this.evaluate(textDesign.getContent())) != null && IOUtil.getTypeIndex((Object)content) == -1) {
            content = content.toString();
        }
        if ("text/plaintext".equals(rawType = ForeignContent.getTextRawType(contentType, content))) {
            rawType = "binary/value";
        }
        textContent.setRawType(rawType);
        textContent.setRawValue(content);
        if (this.context.isInFactory()) {
            this.handleOnCreate(textContent);
        }
        this.startTOCEntry(textContent);
        return textContent;
    }

    public void close() throws BirtException {
        this.finishTOCEntry();
        this.closeQuery();
        super.close();
    }
}

