/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.api.impl;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class EngineLoggerHandler
extends Handler {
    private static ThreadLocal threadLogger = new ThreadLocal();
    private Logger sharedLogger;
    private Logger rootLogger;

    public static void setLogger(Logger logger) {
        threadLogger.set(logger);
    }

    public EngineLoggerHandler(Logger rootLogger) {
        this.rootLogger = rootLogger;
    }

    public void setSharedLogger(Logger logger) {
        this.sharedLogger = logger;
    }

    public void close() throws SecurityException {
    }

    public void flush() {
        Logger logger = (Logger)threadLogger.get();
        if (logger == null) {
            logger = this.sharedLogger;
        }
        if (logger == null) {
            logger = this.rootLogger.getParent();
        }
        while (logger != null) {
            Handler[] handles = logger.getHandlers();
            if (handles != null) {
                int i = 0;
                while (i < handles.length) {
                    handles[i].flush();
                    ++i;
                }
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
    }

    public void publish(LogRecord record) {
        Logger logger = (Logger)threadLogger.get();
        if (logger == null) {
            logger = this.sharedLogger;
        }
        if (logger == null) {
            logger = this.rootLogger.getParent();
        }
        while (logger != null) {
            Handler[] handles = logger.getHandlers();
            if (handles != null) {
                int i = 0;
                while (i < handles.length) {
                    handles[i].publish(record);
                    ++i;
                }
            }
            if (!logger.getUseParentHandlers()) break;
            logger = logger.getParent();
        }
    }
}

