/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.properties.internal;

import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.pagedesigner.properties.WPETabbedPropertySheetPage;
import org.eclipse.jst.pagedesigner.properties.internal.QuickEditTabManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuickEditTabSection
extends AbstractPropertySection {
    private QuickEditTabManager manager;
    private Composite _composite;
    private Composite _qeGroupComposite;
    private WPETabbedPropertySheetPage _tabbedPropertySheetPage;

    private QuickEditTabManager getTabManager() {
        if (this.manager == null) {
            this.manager = this._tabbedPropertySheetPage.getTabManager();
        }
        return this.manager;
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this._composite = parent;
        this._tabbedPropertySheetPage = (WPETabbedPropertySheetPage)tabbedPropertySheetPage;
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.getTabManager() != null) {
            this.aboutToBeHidden();
            this.createOrResetQuickEditGroupComposite();
            this.getTabManager().selectionChanged(part, selection);
            for (ISection section : this.getSections()) {
                section.createControls(this._qeGroupComposite, (TabbedPropertySheetPage)this._tabbedPropertySheetPage);
                section.setInput(part, selection);
            }
            this._composite.getParent().layout(true, true);
            this.aboutToBeShown();
            this.refresh();
        }
    }

    public void aboutToBeHidden() {
        super.aboutToBeHidden();
        for (ISection section : this.getSections()) {
            section.aboutToBeHidden();
        }
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        for (ISection section : this.getSections()) {
            section.aboutToBeShown();
        }
    }

    public void refresh() {
        super.refresh();
        for (ISection section : this.getSections()) {
            section.refresh();
        }
    }

    private void createOrResetQuickEditGroupComposite() {
        if (this._qeGroupComposite != null && !this._qeGroupComposite.isDisposed()) {
            this.disposeCurrentQuickEditTabSections();
            this._qeGroupComposite.dispose();
        }
        this._qeGroupComposite = this._tabbedPropertySheetPage.getWidgetFactory().createComposite(this._composite, 524288);
        QuickEditTabLayout layout = new QuickEditTabLayout();
        this._qeGroupComposite.setLayout((Layout)layout);
    }

    private void disposeCurrentQuickEditTabSections() {
        for (ISection section : this.getSections()) {
            section.dispose();
        }
    }

    private List<ISection> getSections() {
        if (this.getTabManager().getCurrentTabGroupDescriptor() != null) {
            return this.getTabManager().getCurrentTabGroupDescriptor().getSections();
        }
        return Collections.EMPTY_LIST;
    }

    public void dispose() {
        super.dispose();
        this.disposeCurrentQuickEditTabSections();
        this.manager.dispose();
        this.manager = null;
        this._composite = null;
        this._qeGroupComposite = null;
        this._tabbedPropertySheetPage = null;
    }

    public boolean shouldUseExtraSpace() {
        return false;
    }

    private class QuickEditTabLayout
    extends Layout {
        private static final int MARGIN = 0;
        private static final int SPACING = 0;
        Point[] sizes;
        int maxWidth;
        int totalHeight;

        private QuickEditTabLayout() {
        }

        protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (flushCache || this.sizes == null || this.sizes.length != children.length) {
                this.initialize(children);
            }
            int width = wHint;
            int height = hHint;
            if (wHint == -1) {
                width = this.maxWidth;
            }
            if (hHint == -1) {
                height = this.totalHeight;
            }
            return new Point(width + 0, height + 0);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Control[] children = composite.getChildren();
            if (flushCache || this.sizes == null || this.sizes.length != children.length) {
                this.initialize(children);
            }
            Rectangle rect = composite.getClientArea();
            int x = 0;
            int y = 0;
            int width = Math.max(rect.width - 0, this.maxWidth);
            int i = 0;
            while (i < children.length) {
                int height = this.sizes[i].y;
                children[i].setBounds(x, y, width, height);
                y += height + 0;
                ++i;
            }
            composite.setRedraw(true);
        }

        void initialize(Control[] children) {
            this.maxWidth = 0;
            this.totalHeight = 0;
            this.sizes = new Point[children.length];
            int i = 0;
            while (i < children.length) {
                this.sizes[i] = children[i].computeSize(-1, -1, true);
                this.maxWidth = Math.max(this.maxWidth, this.sizes[i].x);
                this.totalHeight += this.sizes[i].y;
                ++i;
            }
            this.totalHeight += (children.length - 1) * 0;
        }
    }
}

