/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.impl;

import java.math.BigDecimal;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.aggregation.calculator.CalculatorFactory;
import org.eclipse.birt.data.aggregation.i18n.Messages;
import org.eclipse.birt.data.aggregation.impl.AggrFunction;
import org.eclipse.birt.data.aggregation.impl.Constants;
import org.eclipse.birt.data.aggregation.impl.ParameterDefn;
import org.eclipse.birt.data.aggregation.impl.SummaryAccumulator;
import org.eclipse.birt.data.aggregation.impl.SupportedDataTypes;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IParameterDefn;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalWeightedAve
extends AggrFunction {
    public String getName() {
        return "WEIGHTEDAVE";
    }

    public int getType() {
        return 0;
    }

    public int getDataType() {
        return 3;
    }

    public IParameterDefn[] getParameterDefn() {
        return new IParameterDefn[]{new ParameterDefn("Expression", Constants.EXPRESSION_DISPLAY_NAME, false, true, SupportedDataTypes.CALCULATABLE, ""), new ParameterDefn("weight", Messages.getString("TotalWeightedAve.param.weight"), false, true, SupportedDataTypes.CALCULATABLE, "")};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    public String getDescription() {
        return Messages.getString("TotalWeightedAve.description");
    }

    public String getDisplayName() {
        return Messages.getString("TotalWeightedAve.displayName");
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private Number wsum = 0.0;
        private Number weightsum = 0.0;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.wsum = 0.0;
            this.weightsum = 0;
        }

        public void onRow(Object[] args) throws DataException {
            assert (args.length > 1);
            if (args[0] != null && args[1] != null) {
                if (this.calculator == null) {
                    this.calculator = CalculatorFactory.getCalculator(args[0].getClass());
                }
                this.wsum = this.calculator.add(this.wsum, this.calculator.multiply(args[0], args[1]));
                this.weightsum = this.calculator.add(this.weightsum, args[1]);
            }
        }

        public Object getSummaryValue() {
            try {
                if (this.weightsum instanceof Double) {
                    Double ws = (Double)this.weightsum;
                    return ws != 0.0 ? (Number)this.calculator.divide(this.wsum, this.weightsum) : (Number)null;
                }
                if (this.weightsum instanceof BigDecimal) {
                    BigDecimal ws = (BigDecimal)this.weightsum;
                    return ws.compareTo(BigDecimal.ZERO) != 0 ? (Number)this.calculator.divide(this.wsum, this.weightsum) : (Number)null;
                }
            }
            catch (BirtException birtException) {
                return null;
            }
            return null;
        }
    }
}

