/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.aggregation.calculator;

import com.ibm.icu.text.NumberFormat;
import com.ibm.icu.util.ULocale;
import java.text.ParseException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.exception.CoreException;
import org.eclipse.birt.data.aggregation.calculator.NumberCalculator;
import org.eclipse.birt.data.engine.core.DataException;

public class StringCalculator
extends NumberCalculator {
    private static ULocale locale = ULocale.getDefault();

    public Number add(Object a, Object b) throws DataException {
        Number[] args = this.convert(a, b);
        return super.add(args[0], args[1]);
    }

    public Number divide(Object dividend, Object divisor) throws DataException {
        Number[] args = this.convert(dividend, divisor);
        return super.divide(args[0], args[1]);
    }

    public Number multiply(Object a, Object b) throws DataException {
        Number[] args = this.convert(a, b);
        return super.multiply(args[0], args[1]);
    }

    public Number safeDivide(Object dividend, Object divisor, Number ifZero) throws DataException {
        Number[] args = this.convert(dividend, divisor);
        return super.safeDivide(args[0], args[1], ifZero);
    }

    public Number subtract(Object a, Object b) throws DataException {
        Number[] args = this.convert(a, b);
        return super.subtract(args[0], args[1]);
    }

    private Number[] convert(Object a, Object b) throws DataException {
        Number[] arguments = new Number[]{a instanceof String ? (Number)this.toDouble((String)a) : (Number)((Number)a), b instanceof String ? (Number)this.toDouble((String)b) : (Number)((Number)b)};
        return arguments;
    }

    private Double toDouble(String source) throws DataException {
        try {
            return Double.valueOf(source);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                Number number = NumberFormat.getInstance((ULocale)locale).parse(source);
                if (number != null) {
                    return new Double(number.doubleValue());
                }
                throw DataException.wrap((BirtException)new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"}));
            }
            catch (ParseException parseException) {
                throw DataException.wrap((BirtException)new CoreException("CONVERT_FAILS", new Object[]{source.toString(), "Double"}));
            }
        }
    }
}

