/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsl.xalan.debugger;

import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xalan.trace.EndSelectionEvent;
import org.apache.xalan.trace.ExtensionEvent;
import org.apache.xalan.trace.GenerateEvent;
import org.apache.xalan.trace.SelectionEvent;
import org.apache.xalan.trace.TraceListenerEx2;
import org.apache.xalan.trace.TracerEvent;
import org.eclipse.wst.xsl.jaxp.debug.debugger.BreakPoint;
import org.eclipse.wst.xsl.jaxp.debug.debugger.Variable;
import org.eclipse.wst.xsl.xalan.debugger.XalanDebugger;
import org.eclipse.wst.xsl.xalan.debugger.XalanRootStyleFrame;
import org.eclipse.wst.xsl.xalan.debugger.XalanStyleFrame;

public class XalanTraceListener
implements TraceListenerEx2 {
    private static final Log log;
    private final XalanDebugger debugger;
    private XalanRootStyleFrame rootStyleFrame;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xsl.xalan.debugger.XalanTraceListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public XalanTraceListener(XalanDebugger debugger) {
        this.debugger = debugger;
    }

    public void trace(TracerEvent ev) {
        XalanStyleFrame styleFrame = null;
        if (this.rootStyleFrame == null) {
            this.debugger.debuggerTransformStarted();
            this.debugger.setCurrentTraceListener(this);
            this.rootStyleFrame = new XalanRootStyleFrame(ev);
            styleFrame = this.rootStyleFrame;
            this.debugger.pushStyleFrame(styleFrame);
        } else if (ev.m_styleNode.getOwnerXSLTemplate() == ev.m_styleNode) {
            styleFrame = new XalanStyleFrame(this.debugger.peekStyleFrame(), ev);
            this.debugger.pushStyleFrame(styleFrame);
        } else if (ev.m_styleNode.getXSLToken() != 78) {
            styleFrame = (XalanStyleFrame)this.debugger.peekStyleFrame();
            styleFrame.pushElement(ev);
        } else {
            log.debug((Object)("Skipped push for element " + ev.m_styleNode.getLocalName()));
        }
        this.check(styleFrame);
    }

    public void traceEnd(TracerEvent ev) {
        XalanStyleFrame styleFrame = (XalanStyleFrame)this.debugger.peekStyleFrame();
        if (styleFrame != null) {
            if (ev.m_styleNode.getOwnerXSLTemplate() == ev.m_styleNode) {
                styleFrame.popElement();
            } else if (ev.m_styleNode.getXSLToken() != 78) {
                styleFrame.popElement();
            } else {
                log.debug((Object)("Skipped pop for element " + ev.m_styleNode.getLocalName()));
            }
            this.check(styleFrame);
            if (ev.m_styleNode.getOwnerXSLTemplate() == ev.m_styleNode) {
                this.debugger.popStyleFrame();
            } else {
                TracerEvent tel = styleFrame.peekElement();
                switch (tel.m_styleNode.getXSLToken()) {
                    case 37: {
                        styleFrame.popElement();
                        this.check(styleFrame);
                    }
                }
            }
        }
    }

    private void check(XalanStyleFrame styleFrame) {
        this.debugger.checkStopped();
        if (styleFrame != null) {
            BreakPoint breakpoint = new BreakPoint(styleFrame.getFilename(), styleFrame.getCurrentLine());
            this.debugger.checkSuspended(styleFrame, breakpoint);
        }
    }

    public void selected(SelectionEvent ev) throws TransformerException {
    }

    public void selectEnd(EndSelectionEvent ev) throws TransformerException {
    }

    public void generated(GenerateEvent ev) {
    }

    public void extension(ExtensionEvent ee) {
    }

    public void extensionEnd(ExtensionEvent ee) {
    }

    public Variable getVariable(int id) {
        return this.rootStyleFrame.getVariable(id);
    }
}

