/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.eclipse.birt.data.engine.core.security.FileSecurity;
import org.eclipse.birt.data.engine.olap.data.document.AbstractBufferedRandomAccessObject;

public class BufferedRandomAccessFile
extends AbstractBufferedRandomAccessObject {
    private RandomAccessFile delegate;
    private byte[] memoryDelegate;
    private int pointer;
    private int length;
    private File file;
    private String mode;
    private boolean pureMemory;

    public BufferedRandomAccessFile(File file, String mode, int bufferSize, int cacheSize) throws IOException {
        super(bufferSize);
        this.file = file;
        this.mode = mode;
        this.pureMemory = false;
        if (FileSecurity.fileExist(file) || cacheSize == 0) {
            this.createRandomAccessFile();
        } else if (cacheSize > 0) {
            this.memoryDelegate = new byte[cacheSize];
        } else {
            this.memoryDelegate = new byte[0x100000];
            this.pureMemory = true;
        }
        this.fillBuffer();
    }

    public BufferedRandomAccessFile(File file, String mode, int bufferSize) throws IOException {
        this(file, mode, bufferSize, 0);
    }

    private void createRandomAccessFile() throws IOException {
        File parent = this.file.getParentFile();
        if (!FileSecurity.fileExist(parent)) {
            FileSecurity.fileMakeDirs(parent);
        }
        this.delegate = FileSecurity.createRandomAccessFile(this.file, this.mode);
        if (this.memoryDelegate != null || this.length > 0) {
            this.delegate.write(this.memoryDelegate, 0, this.length);
            this.delegate.seek(this.pointer);
        }
    }

    protected void delegateClose() throws IOException {
        if (this.delegate == null) {
            return;
        }
        this.delegate.close();
    }

    protected long delegateGetFilePointer() throws IOException {
        if (this.delegate == null) {
            return this.pointer;
        }
        return this.delegate.getFilePointer();
    }

    protected long delegateLength() throws IOException {
        if (this.delegate == null) {
            return this.length;
        }
        return this.delegate.length();
    }

    protected int delegateRead(byte[] b, int pos, int len) throws IOException {
        if (this.delegate == null) {
            int size = Math.min(this.length - this.pointer, len);
            if (size <= 0) {
                return -1;
            }
            System.arraycopy(this.memoryDelegate, this.pointer, b, pos, size);
            return size;
        }
        return this.delegate.read(b, pos, len);
    }

    protected int delegateRead(byte[] b) throws IOException {
        return this.delegateRead(b, 0, b.length);
    }

    protected void delegateSeek(long pos) throws IOException {
        if (this.delegate == null) {
            if (pos > (long)this.memoryDelegate.length && !this.pureMemory) {
                this.createRandomAccessFile();
            } else {
                if (pos > (long)this.memoryDelegate.length) {
                    this.restructMemoryDelegate();
                }
                this.pointer = (int)pos;
                return;
            }
        }
        this.delegate.seek(pos);
    }

    private void restructMemoryDelegate() {
        byte[] tmpBuf = null;
        if (this.memoryDelegate.length * 2 < 0 || (long)this.memoryDelegate.length * 2L > Integer.MAX_VALUE) {
            tmpBuf = new byte[Integer.MAX_VALUE];
            this.pureMemory = false;
        } else {
            tmpBuf = new byte[this.memoryDelegate.length * 2];
        }
        System.arraycopy(this.memoryDelegate, 0, tmpBuf, 0, this.memoryDelegate.length);
        this.memoryDelegate = tmpBuf;
    }

    protected void delegateSetLength(long newLength) throws IOException {
        if (this.delegate == null) {
            if (newLength > (long)this.memoryDelegate.length && !this.pureMemory) {
                this.createRandomAccessFile();
            } else {
                if (newLength > (long)this.memoryDelegate.length) {
                    this.restructMemoryDelegate();
                }
                this.length = (int)newLength;
            }
            return;
        }
        this.delegate.setLength(newLength);
    }

    protected void delegateWrite(byte[] b, int pos, int len) throws IOException {
        if (this.delegate == null) {
            if (this.pointer + len > this.memoryDelegate.length && !this.pureMemory) {
                this.createRandomAccessFile();
            } else {
                if (this.pointer + len > this.memoryDelegate.length) {
                    this.restructMemoryDelegate();
                }
                System.arraycopy(b, pos, this.memoryDelegate, this.pointer, len);
                if (this.pointer + len > this.length) {
                    this.length = this.pointer + len;
                }
                this.pointer += len;
                return;
            }
        }
        this.delegate.write(b, pos, len);
    }
}

