/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.i18n.DataResourceHandle;
import org.eclipse.birt.data.engine.olap.data.api.IComputedMeasureHelper;
import org.eclipse.birt.data.engine.olap.data.api.IDimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.api.ILevel;
import org.eclipse.birt.data.engine.olap.data.api.MeasureInfo;
import org.eclipse.birt.data.engine.olap.data.api.cube.TimeDimensionUtil;
import org.eclipse.birt.data.engine.olap.data.impl.DimColumn;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ColumnInfo;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.IDataSet4Aggregation;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;
import org.eclipse.birt.data.engine.olap.data.impl.facttable.IFactTableRowIterator;
import org.eclipse.birt.data.engine.olap.util.filter.IFacttableRow;

public class DataSetFromOriginalCube
implements IDataSet4Aggregation {
    private IFactTableRowIterator factTableRowIterator;
    private IDimensionResultIterator[] dimensionResultIterators;
    private IComputedMeasureHelper computedMeasureHelper;
    private IFacttableRow facttableRow = null;

    public DataSetFromOriginalCube(IFactTableRowIterator factTableRowIterator, IDimensionResultIterator[] dimensionResultIterators, IComputedMeasureHelper computedMeasureHelper) {
        this.dimensionResultIterators = dimensionResultIterators;
        this.factTableRowIterator = factTableRowIterator;
        this.computedMeasureHelper = computedMeasureHelper;
        this.facttableRow = new FacttableRowForComputedMeasure();
    }

    public IDataSet4Aggregation.MetaInfo getMetaInfo() {
        return new IDataSet4Aggregation.MetaInfo(){

            public String[] getAttributeNames(int dimIndex, int levelIndex) {
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                if (!itr.getDimesion().isTime()) {
                    return itr.getDimesion().getHierarchy().getLevels()[levelIndex].getAttributeNames();
                }
                return null;
            }

            public ColumnInfo getColumnInfo(DimColumn dimColumn) throws DataException {
                String dimensionName = dimColumn.getDimensionName();
                String levelName = dimColumn.getLevelName();
                String columnName = dimColumn.getColumnName();
                int dimIndex = this.getDimensionIndex(dimensionName);
                if (dimIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentDimension")) + dimensionName);
                }
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                int levelIndex = itr.getLevelIndex(levelName);
                if (levelIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentLevel")) + "<" + dimensionName + " , " + levelName + ">");
                }
                ILevel levelInfo = itr.getDimesion().getHierarchy().getLevels()[levelIndex];
                int columnIndex = -1;
                boolean isKey = false;
                int i = 0;
                while (i < levelInfo.getKeyNames().length) {
                    if (levelInfo.getKeyNames()[i].equals(columnName)) {
                        columnIndex = i;
                        isKey = true;
                        break;
                    }
                    ++i;
                }
                if (!isKey) {
                    i = 0;
                    while (i < levelInfo.getAttributeNames().length) {
                        if (levelInfo.getAttributeNames()[i].equals(columnName)) {
                            columnIndex = i;
                            break;
                        }
                        ++i;
                    }
                }
                if (columnIndex < 0) {
                    throw new DataException(String.valueOf(DataResourceHandle.getInstance().getMessage("data.olap.NonexistentKeyOrAttr")) + "<" + dimensionName + " , " + levelName + " , " + columnName + ">");
                }
                return new ColumnInfo(dimIndex, levelIndex, columnIndex, isKey);
            }

            public int getDimensionIndex(String dimensionName) {
                int i = 0;
                while (i < DataSetFromOriginalCube.this.dimensionResultIterators.length) {
                    if (DataSetFromOriginalCube.this.dimensionResultIterators[i].getDimesion().getName().equals(dimensionName)) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public String[] getKeyNames(int dimIndex, int levelIndex) {
                IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                if (itr.getDimesion().isTime()) {
                    return new String[]{TimeDimensionUtil.getFieldName(levelIndex)};
                }
                return itr.getDimesion().getHierarchy().getLevels()[levelIndex].getKeyNames();
            }

            public int getLevelIndex(String dimensionName, String levelName) {
                int dimIndex = this.getDimensionIndex(dimensionName);
                if (dimIndex >= 0) {
                    IDimensionResultIterator itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex];
                    return itr.getLevelIndex(levelName);
                }
                return -1;
            }

            public int getMeasureIndex(String measureName) {
                if (measureName == null) {
                    return -1;
                }
                MeasureInfo[] measureInfo = this.getMeasureInfos();
                int i = 0;
                while (i < measureInfo.length) {
                    if (measureName.equals(measureInfo[i].getMeasureName())) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }

            public MeasureInfo[] getMeasureInfos() {
                if (DataSetFromOriginalCube.this.computedMeasureHelper != null && DataSetFromOriginalCube.this.computedMeasureHelper.getAllComputedMeasureInfos() != null) {
                    MeasureInfo[] cubeMeasureInfo = DataSetFromOriginalCube.this.factTableRowIterator.getMeasureInfos();
                    MeasureInfo[] computedMeasureInfo = DataSetFromOriginalCube.this.computedMeasureHelper.getAllComputedMeasureInfos();
                    MeasureInfo[] result = new MeasureInfo[computedMeasureInfo.length + cubeMeasureInfo.length];
                    System.arraycopy(cubeMeasureInfo, 0, result, 0, cubeMeasureInfo.length);
                    System.arraycopy(computedMeasureInfo, 0, result, cubeMeasureInfo.length, computedMeasureInfo.length);
                    return result;
                }
                return DataSetFromOriginalCube.this.factTableRowIterator.getMeasureInfos();
            }
        };
    }

    public boolean next() throws DataException, IOException {
        return this.factTableRowIterator.next();
    }

    public int[] getDimensionPosition() {
        return this.factTableRowIterator.getDimensionPosition();
    }

    public Object getMeasureValue(int measureIndex) throws DataException {
        if (measureIndex < this.factTableRowIterator.getMeasureCount()) {
            return this.factTableRowIterator.getMeasure(measureIndex);
        }
        if (this.computedMeasureHelper != null) {
            Object[] computedMeasure = this.computedMeasureHelper.computeMeasureValues(this.facttableRow);
            if (computedMeasure != null && measureIndex < this.factTableRowIterator.getMeasureCount() + computedMeasure.length) {
                return computedMeasure[measureIndex - this.factTableRowIterator.getMeasureCount()];
            }
            return null;
        }
        return null;
    }

    public Member getMember(int dimIndex, int levelIndex) throws DataException, IOException {
        String dimensionName = this.dimensionResultIterators[dimIndex].getDimesion().getName();
        int indexInFact = this.factTableRowIterator.getDimensionIndex(dimensionName);
        try {
            return this.getLevelObject(dimIndex, levelIndex, this.factTableRowIterator.getDimensionPosition(indexInFact));
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    private Member getLevelObject(int dimIndex, int levelIndex, int dimensionPosition) throws BirtException, IOException {
        if (this.dimensionResultIterators[dimIndex].locate(dimensionPosition)) {
            return this.dimensionResultIterators[dimIndex].getLevelMember(levelIndex);
        }
        return null;
    }

    public void close() throws DataException, IOException {
        this.factTableRowIterator.close();
        this.factTableRowIterator = null;
        int i = 0;
        while (i < this.dimensionResultIterators.length) {
            try {
                this.dimensionResultIterators[i].close();
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            ++i;
        }
        this.dimensionResultIterators = null;
    }

    public class FacttableRowForComputedMeasure
    implements IFacttableRow {
        public Object getLevelAttributeValue(String dimensionName, String levelName, String attributeName) throws DataException, IOException {
            Member member;
            int dimensionIndex = this.getDimensionIndex(dimensionName);
            if (dimensionIndex < 0) {
                return null;
            }
            try {
                member = this.getLevelMember(dimensionIndex, levelName);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            int attributeIndex = DataSetFromOriginalCube.this.dimensionResultIterators[dimensionIndex].getLevelAttributeIndex(levelName, attributeName);
            if (member != null && attributeIndex >= 0) {
                return member.getAttributes()[attributeIndex];
            }
            return null;
        }

        public Object[] getLevelKeyValue(String dimensionName, String levelName) throws DataException, IOException {
            Member member;
            try {
                member = this.getLevelMember(dimensionName, levelName);
            }
            catch (BirtException e) {
                throw DataException.wrap(e);
            }
            if (member != null) {
                return member.getKeyValues();
            }
            return null;
        }

        private Member getLevelMember(String dimensionName, String levelName) throws BirtException, IOException {
            int dimIndex = this.getDimensionIndex(dimensionName);
            return this.getLevelMember(dimIndex, levelName);
        }

        private Member getLevelMember(int dimIndex, String levelName) throws BirtException, IOException {
            IDimensionResultIterator itr;
            int levelIndex = -1;
            if (dimIndex >= 0 && (levelIndex = (itr = DataSetFromOriginalCube.this.dimensionResultIterators[dimIndex]).getLevelIndex(levelName)) >= 0) {
                return DataSetFromOriginalCube.this.getMember(dimIndex, levelIndex);
            }
            return null;
        }

        private int getDimensionIndex(String dimensionName) {
            int dimIndex = -1;
            int i = 0;
            while (i < DataSetFromOriginalCube.this.dimensionResultIterators.length) {
                if (DataSetFromOriginalCube.this.dimensionResultIterators[i].getDimesion().getName().equals(dimensionName)) {
                    dimIndex = i;
                }
                ++i;
            }
            return dimIndex;
        }

        public Object getMeasureValue(String measureName) throws DataException {
            return DataSetFromOriginalCube.this.factTableRowIterator.getMeasure(DataSetFromOriginalCube.this.factTableRowIterator.getMeasureIndex(measureName));
        }
    }
}

