/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.olap.data.impl.aggregation;

import java.io.IOException;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.StopSign;
import org.eclipse.birt.data.engine.olap.data.api.cube.IDimension;
import org.eclipse.birt.data.engine.olap.data.impl.Cube;
import org.eclipse.birt.data.engine.olap.data.impl.aggregation.ICubeDimensionReader;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Dimension;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.DimensionResultIterator;
import org.eclipse.birt.data.engine.olap.data.impl.dimension.Member;

public class CubeDimensionReader
implements ICubeDimensionReader {
    private DimensionResultIterator[] dimResultSet;
    private Cube cube;

    public CubeDimensionReader(Cube cube) {
        this.cube = cube;
        this.dimResultSet = new DimensionResultIterator[cube.getDimesions().length];
    }

    private void populateDimensionResultIterator(int dimIndex) throws DataException, IOException {
        IDimension[] dimensions = this.cube.getDimesions();
        this.dimResultSet[dimIndex] = new DimensionResultIterator((Dimension)dimensions[dimIndex], dimensions[dimIndex].findAll(), new StopSign());
    }

    public Member getLevelMember(int dimIndex, int levelIndex, int dimPos) throws IOException, DataException {
        if (this.dimResultSet[dimIndex] == null) {
            this.populateDimensionResultIterator(dimIndex);
        }
        this.dimResultSet[dimIndex].seek(dimPos);
        return this.dimResultSet[dimIndex].getLevelMember(levelIndex);
    }
}

