/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.Collection;
import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.data.engine.api.IGroupInstanceInfo;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.CachedQueryResults;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.document.QueryResults;
import org.mozilla.javascript.Scriptable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DummyPreparedQuery
implements IPreparedQuery {
    private IQueryDefinition queryDefn;
    private String tempDir;
    private DataEngineContext context;
    private List<IGroupInstanceInfo> targetGroups;
    private DataEngineSession session;

    public DummyPreparedQuery(IQueryDefinition queryDefn, DataEngineSession session) {
        this.queryDefn = queryDefn;
        this.session = session;
        this.tempDir = session.getTempDir();
    }

    public DummyPreparedQuery(IQueryDefinition queryDefn, DataEngineSession session, DataEngineContext context, List<IGroupInstanceInfo> targetGroups) {
        this(queryDefn, session);
        this.context = context;
        this.targetGroups = targetGroups;
    }

    @Override
    public IQueryResults execute(Scriptable queryScope) throws BirtException {
        return this.execute(null, queryScope);
    }

    @Override
    public IQueryResults execute(IQueryResults outerResults, Scriptable queryScope) throws BirtException {
        try {
            return this.execute((IBaseQueryResults)outerResults, queryScope);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }

    @Override
    public Collection getParameterMetaData() throws BirtException {
        return null;
    }

    @Override
    public IQueryDefinition getReportQueryDefn() {
        return this.queryDefn;
    }

    @Override
    public IQueryResults execute(IBaseQueryResults outerResults, Scriptable scope) throws DataException {
        try {
            if (this.context == null) {
                return new CachedQueryResults(this.session, this.queryDefn.getQueryResultsID(), this);
            }
            return new QueryResults(this.tempDir, this.context, this.queryDefn.getQueryResultsID(), outerResults, this.targetGroups);
        }
        catch (BirtException e) {
            throw DataException.wrap(e);
        }
    }
}

