/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetFromCache {
    private IResultClass rsMeta;
    private ILoadUtil loadUtil;
    private DataEngineSession session;
    private List addedTempComputedColumn;
    private int realColumnCount;

    public DataSetFromCache(DataEngineSession session) {
        this.session = session;
    }

    public IResultObject fetch() throws DataException {
        return this.loadObject();
    }

    private IResultObject loadObject() throws DataException {
        IResultObject cacheObject;
        if (this.rsMeta == null) {
            this.getResultClass();
        }
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        IResultObject iResultObject = cacheObject = this.loadUtil == null ? null : this.loadUtil.loadObject();
        if (cacheObject == null) {
            return cacheObject;
        }
        if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
            ResultObject resultObject = new ResultObject(this.getResultClass(), this.getAllObjects(cacheObject));
            return resultObject;
        }
        return cacheObject;
    }

    private Object[] getAllObjects(IResultObject cacheObject) throws DataException {
        Object[] objects = new Object[this.realColumnCount + this.addedTempComputedColumn.size()];
        int i = 0;
        while (i < this.realColumnCount) {
            objects[i] = cacheObject.getFieldValue(i + 1);
            ++i;
        }
        return objects;
    }

    private IResultClass loadResultClass() throws DataException {
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        return this.loadUtil.loadResultClass();
    }

    private IDataSetCacheObject getCacheObject() throws DataException {
        return this.session.getDataSetCacheManager().getCacheObject();
    }

    public IResultClass getResultClass() throws DataException {
        if (this.rsMeta == null) {
            this.rsMeta = this.loadResultClass();
            if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
                this.processResultClass();
            }
        }
        return this.rsMeta;
    }

    private void processResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> metadataList = new ArrayList<ResultFieldMetadata>();
        this.realColumnCount = 0;
        ResultFieldMetadata metadata = null;
        int i = 0;
        i = 0;
        while (i < this.rsMeta.getFieldCount()) {
            if (!this.isTempComputedColumn(this.rsMeta.getFieldName(i + 1))) {
                metadata = new ResultFieldMetadata(0, this.rsMeta.getFieldName(i + 1), this.rsMeta.getFieldLabel(i + 1), this.rsMeta.getFieldValueClass(i + 1), this.rsMeta.getFieldNativeTypeName(i + 1), this.rsMeta.isCustomField(i + 1));
                metadata.setAlias(this.rsMeta.getFieldAlias(i + 1));
                metadataList.add(metadata);
                ++this.realColumnCount;
            }
            ++i;
        }
        ComputedColumn tempComputedColumn = null;
        i = 0;
        while (i < this.addedTempComputedColumn.size()) {
            tempComputedColumn = (ComputedColumn)this.addedTempComputedColumn.get(i);
            metadata = new ResultFieldMetadata(0, tempComputedColumn.getName(), null, DataType.getClass((int)tempComputedColumn.getDataType()), null, true);
            metadataList.add(metadata);
            ++i;
        }
        this.rsMeta = new ResultClass(metadataList);
    }

    private boolean isTempComputedColumn(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public void setTempComputedColumn(List addedTempComputedColumn) {
        this.addedTempComputedColumn = addedTempComputedColumn;
    }

    public void close() throws DataException {
        if (this.loadUtil != null) {
            this.loadUtil.close();
            this.loadUtil = null;
        }
    }
}

