/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.oda.jdbc;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.data.oda.jdbc.Blob;
import org.eclipse.birt.report.data.oda.jdbc.Clob;
import org.eclipse.birt.report.data.oda.jdbc.JDBCException;
import org.eclipse.birt.report.data.oda.jdbc.ParameterDefn;
import org.eclipse.birt.report.data.oda.jdbc.ResultSet;
import org.eclipse.birt.report.data.oda.jdbc.ResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.SPParameterMetaData;
import org.eclipse.birt.report.data.oda.jdbc.SPParameterPositionUtil;
import org.eclipse.birt.report.data.oda.jdbc.SPResultSet;
import org.eclipse.birt.report.data.oda.jdbc.SPResultSetMetaData;
import org.eclipse.birt.report.data.oda.jdbc.Statement;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IParameterRowSet;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.SortSpec;
import org.eclipse.datatools.connectivity.oda.spec.QuerySpecification;

public class CallStatement
implements IAdvancedQuery {
    protected CallableStatement callStat;
    protected java.sql.ResultSet rs;
    protected Connection conn;
    protected int maxrows;
    protected boolean maxRowsUpToDate = false;
    private SPParameterPositionUtil paramUtil;
    private static final String ERRMSG_SET_PARAMETER = "Error setting value for SQL parameter #";
    private static Logger logger = Logger.getLogger(CallStatement.class.getName());
    private IParameterMetaData parameterDefn;
    private IResultSetMetaData cachedResultMetaData;
    private IResultSet cachedResultSet;
    private IParameterMetaData cachedParameterMetaData;
    protected String[] resultSetNames;
    private static final String ORACLE_FLOAT_NAME = "FLOAT";
    private static final String ORACLE_CURSOR_NAME = "REF CURSOR";
    private static final int ORACLE_CURSOR_TYPE = -10;
    private Map<String, java.sql.ResultSet> outputParameterResultSetsMap = new LinkedHashMap<String, java.sql.ResultSet>();
    private int resultIndex = 0;
    private boolean isExecuted = false;

    private void assertNotNull(Object o) throws OdaException {
        if (o == null) {
            throw new JDBCException("odajdbc.driver.StatementCannotNull", 117);
        }
    }

    public CallStatement(Connection connection) throws OdaException {
        if (connection == null) {
            throw new JDBCException("odajdbc.driver.ConnNotOpen", 111);
        }
        this.callStat = null;
        this.conn = connection;
        this.maxrows = 0;
    }

    public void prepare(String command) throws OdaException {
        logger.logp(Level.FINE, CallStatement.class.getName(), "prepare", "CallableStatement.prepare( \"" + command + "\" )");
        try {
            if (command == null) {
                logger.logp(Level.FINE, CallStatement.class.getName(), "prepare", "Query text can not be null.");
                throw new OdaException("Query text can not be null.");
            }
            this.paramUtil = new SPParameterPositionUtil(command, this.conn.getMetaData().getIdentifierQuoteString());
            this.callStat = this.conn.prepareCall(command);
            this.cachedResultMetaData = null;
            this.cachedResultSet = null;
            this.cachedParameterMetaData = null;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.StatementCannotPrepared", e);
        }
    }

    public void setAppContext(Object context) throws OdaException {
        if (context instanceof Map) {
            this.parameterDefn = (IParameterMetaData)((Map)context).get("org.eclipse.birt.report.data.oda.jdbc.ParameterHints");
        }
    }

    public void setProperty(String name, String value) throws OdaException {
        if (name == null) {
            throw new NullPointerException("name is null");
        }
        if (name.equals("queryTimeOut")) {
            if (value != null && value.length() > 0) {
                try {
                    double secs = Double.parseDouble(value);
                    this.callStat.setQueryTimeout((int)secs);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, "CallStatement.setQueryTimeout failed", e);
                }
            }
        } else if (name.equals("rowFetchSize")) {
            if (value != null && value.length() > 0) {
                try {
                    double fetchSize = Double.parseDouble(value);
                    this.callStat.setFetchSize((int)fetchSize);
                }
                catch (SQLException e) {
                    logger.log(Level.FINE, "CallStatement.setQueryTimeout failed", e);
                }
            }
        } else if (!(name.equals("OdaConnProfileName") || name.equals("OdaConnProfileStore") || name.equals("OdaConnProfileStorePath"))) {
            OdaException e = new OdaException("Unsupported query property: " + name);
            logger.logp(Level.FINE, CallStatement.class.getName(), "setProperty", "Unsupported property", e);
        }
    }

    public void close() throws OdaException {
        logger.logp(Level.FINE, CallStatement.class.getName(), "close", "CallStatement.close( )");
        try {
            if (this.callStat != null) {
                this.callStat.close();
            }
            this.cachedResultMetaData = null;
            this.cachedResultSet = null;
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotClosePreparedStatement", e);
        }
    }

    public void setMaxRows(int max) {
        logger.logp(Level.FINE, CallStatement.class.getName(), "setMaxRows", "CallStatement.setMaxRows( " + max + " )");
        if (max != this.maxrows && max >= 0) {
            this.maxrows = max;
            this.maxRowsUpToDate = false;
        }
    }

    public int getMaxRows() {
        logger.logp(Level.FINE, CallStatement.class.getName(), "getMaxRows", "CallStatement.getMaxRows( )");
        return this.maxrows;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        logger.logp(Level.FINE, CallStatement.class.getName(), "getMetaData", "CallableStatement.getMetaData( )");
        if (this.cachedResultMetaData != null) {
            return this.cachedResultMetaData;
        }
        java.sql.ResultSetMetaData resultmd = null;
        try {
            this.assertNotNull(this.callStat);
            resultmd = this.callStat.getMetaData();
        }
        catch (NullPointerException nullPointerException) {
            resultmd = null;
        }
        catch (SQLException sQLException) {}
        if (resultmd != null) {
            this.cachedResultMetaData = new ResultSetMetaData(resultmd);
        } else {
            try {
                this.cachedResultSet = this.executeQuery();
                this.cachedResultMetaData = this.cachedResultSet != null ? this.cachedResultSet.getMetaData() : new SPResultSetMetaData(null);
            }
            catch (OdaException odaException) {
                this.cachedResultSet = null;
            }
        }
        return this.cachedResultMetaData;
    }

    public IResultSet executeQuery() throws OdaException {
        logger.logp(Level.FINE, CallStatement.class.getName(), "executeQuery", "CallableStatement.executeQuery( )");
        if (this.cachedResultSet != null) {
            IResultSet ret = this.cachedResultSet;
            this.cachedResultSet = null;
            return ret;
        }
        if (!this.maxRowsUpToDate) {
            try {
                this.assertNotNull(this.callStat);
                this.callStat.setMaxRows(this.maxrows);
            }
            catch (SQLException sQLException) {}
            this.maxRowsUpToDate = true;
        }
        this.registerOutputParameter();
        try {
            java.sql.ResultSet resultSet;
            block10: {
                this.callStat.execute();
                this.isExecuted = true;
                this.rs = this.callStat.getResultSet();
                if (this.rs == null && this.callStat.getUpdateCount() != -1) {
                    int rowCount;
                    while ((rowCount = this.callStat.getUpdateCount()) != -1) {
                        if (this.callStat.getMoreResults() || this.callStat.getUpdateCount() != -1) continue;
                        break block10;
                    }
                    this.rs = this.callStat.getResultSet();
                }
            }
            if (this.rs != null) {
                return new ResultSet(this.rs);
            }
            this.populateOutputParamResultSet();
            java.sql.ResultSet resultSet2 = resultSet = this.outputParameterResultSetsMap.size() == 0 ? null : this.outputParameterResultSetsMap.values().iterator().next();
            if (resultSet != null) {
                return new ResultSet(resultSet);
            }
            return new SPResultSet(null);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotReturn", e);
        }
    }

    private java.sql.ResultSet getOutputParamResultSet() throws OdaException, SQLException {
        if (this.parameterDefn != null) {
            int i = 1;
            while (i <= this.parameterDefn.getParameterCount()) {
                Object expected;
                if (this.parameterDefn.getParameterMode(i) == 3 && (expected = this.callStat.getObject(i)) instanceof java.sql.ResultSet) {
                    return (java.sql.ResultSet)expected;
                }
                ++i;
            }
        }
        return null;
    }

    private void populateOutputParamResultSet() throws OdaException, SQLException {
        if (this.parameterDefn != null) {
            int i = 1;
            while (i <= this.parameterDefn.getParameterCount()) {
                Object expected;
                if (this.parameterDefn.getParameterMode(i) == 3 && (expected = this.callStat.getObject(i)) instanceof java.sql.ResultSet) {
                    this.outputParameterResultSetsMap.put(this.parameterDefn.getParameterName(i), (java.sql.ResultSet)expected);
                }
                ++i;
            }
        }
        this.resultSetNames = this.outputParameterResultSetsMap.keySet().toArray(new String[0]);
        this.resultIndex = 0;
    }

    private void registerOutputParameter() throws OdaException {
        if (this.parameterDefn != null) {
            int i = 1;
            while (i <= this.parameterDefn.getParameterCount()) {
                if (this.parameterDefn.getParameterMode(i) == 3 || this.parameterDefn.getParameterMode(i) == 2) {
                    this.registerOutParameter(i, this.getParameterType(i));
                }
                ++i;
            }
        }
    }

    private int getParameterType(int i) throws OdaException {
        if (this.parameterDefn.getParameterType(i) != 1) {
            return this.parameterDefn.getParameterType(i);
        }
        try {
            IParameterMetaData paramMetaData = this.getParameterMetaData();
            if (paramMetaData != null && paramMetaData.getParameterCount() >= i) {
                return paramMetaData.getParameterType(i);
            }
            return this.parameterDefn.getParameterType(i);
        }
        catch (OdaException odaException) {
            return this.parameterDefn.getParameterType(i);
        }
    }

    void registerOutParameter(int position, int type) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.registerOutParameter(position, type);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    void registerOutParameter(String name, int type) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.registerOutParameter(name, type);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.QueryExecuteFail", e);
        }
    }

    public boolean execute() throws OdaException {
        logger.logp(Level.FINE, CallStatement.class.getName(), "execute", "CallableStatement.execute( )");
        this.assertNotNull(this.callStat);
        return this.executeQuery() != null;
    }

    public void cancel() throws OdaException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void setInt(String parameterName, int value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setInt(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setInt(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setInt(int parameterId, int value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setInt(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetIntValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDouble(String parameterName, double value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDouble(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setDouble(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setDouble(int parameterId, double value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDouble(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDoubleValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBigDecimal(String parameterName, BigDecimal value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBigDecimal(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setBigDecimal(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setBigDecimal(int parameterId, BigDecimal value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBigDecimal(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBigDecimalValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setString(String parameterName, String value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setString(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setString(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setString(int parameterId, String value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setString(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetStringValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setDate(String parameterName, Date value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDate(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setDate(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setDate(int parameterId, Date value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setDate(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetDateValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTime(String parameterName, Time value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTime(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setTime(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setTime(int parameterId, Time value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTime(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimeValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setTimestamp(String parameterName, Timestamp value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTimestamp(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setTimestamp(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setTimestamp(int parameterId, Timestamp value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setTimestamp(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetTimestampValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setBoolean(String parameterName, boolean value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBoolean(parameterName, value);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    this.callStat.setBoolean(position, value);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e1);
                }
            }
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterName);
        }
    }

    public void setBoolean(int parameterId, boolean value) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            this.callStat.setBoolean(parameterId, value);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetBooleanValue", e);
        }
        catch (RuntimeException e1) {
            CallStatement.rethrowRunTimeException(e1, ERRMSG_SET_PARAMETER + parameterId);
        }
    }

    public void setObject(String parameterName, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setObject(int parameterId, Object value) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setNull(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        logger.logp(Level.FINE, Statement.class.getName(), "findInParameter", "No named Parameter supported.", e);
        throw e;
    }

    public void setNull(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            if (this.getParameterMetaData() != null) {
                this.callStat.setNull(parameterId, this.getParameterType(parameterId));
            } else {
                this.callStat.setNull(parameterId, 1111);
            }
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.PrepareStatement.CannotSetNullValue", e);
        }
    }

    public IParameterRowSet setNewRow(String parameterName) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRow(int parameterId) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRowSet(String parameterName) throws OdaException {
        return null;
    }

    public IParameterRowSet setNewRowSet(int parameterId) throws OdaException {
        return null;
    }

    public int getInt(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getInt(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getInt(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
        }
    }

    public int getInt(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getInt(parameterId);
        }
        catch (SQLException e) {
            try {
                return this.retryToGetParameterValue(parameterId);
            }
            catch (OdaException odaException) {
                throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
            }
            catch (SQLException sQLException) {
                throw new JDBCException("odajdbc.ResultSetCannotGetIntValue", e);
            }
        }
    }

    private int retryToGetParameterValue(int parameterId) throws OdaException, SQLException {
        IResultSet rs = this.getResultSet();
        while (rs.next()) {
        }
        return this.callStat.getInt(parameterId);
    }

    public double getDouble(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDouble(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getDouble(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public double getDouble(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDouble(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDoubleValue", e);
        }
    }

    public BigDecimal getBigDecimal(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBigDecimal(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getBigDecimal(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public BigDecimal getBigDecimal(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBigDecimal(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBigDecimalValue", e);
        }
    }

    public String getString(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getString(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getString(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public String getString(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getString(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetStringValue", e);
        }
    }

    public Date getDate(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDate(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getDate(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Date getDate(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getDate(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetDateValue", e);
        }
    }

    public Time getTime(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTime(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getTime(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Time getTime(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTime(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeValue", e);
        }
    }

    public Timestamp getTimestamp(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTimestamp(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getTimestamp(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public Timestamp getTimestamp(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getTimestamp(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetTimeStampValue", e);
        }
    }

    public IBlob getBlob(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Blob blob = this.callStat.getBlob(parameterName);
            return new Blob(blob);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return new Blob(this.callStat.getBlob(position));
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IBlob getBlob(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Blob blob = this.callStat.getBlob(parameterId);
            return new Blob(blob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBlobValue", e);
        }
    }

    public IClob getClob(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Clob clob = this.callStat.getClob(parameterName);
            return new Clob(clob);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return new Clob(this.callStat.getClob(position));
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetClobValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetClobValue", e);
        }
    }

    public IClob getClob(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            java.sql.Clob clob = this.callStat.getClob(parameterId);
            return new Clob(clob);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetClobValue", e);
        }
    }

    public boolean getBoolean(String parameterName) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBoolean(parameterName);
        }
        catch (SQLException e) {
            int position = this.findParameterPositionByAppContext(parameterName);
            if (position > 0) {
                try {
                    return this.callStat.getBoolean(position);
                }
                catch (SQLException e1) {
                    throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e1);
                }
            }
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public boolean getBoolean(int parameterId) throws OdaException {
        this.assertNotNull(this.callStat);
        try {
            return this.callStat.getBoolean(parameterId);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.ResultSetCannotGetBooleanValue", e);
        }
    }

    public Object getObject(int parameterId) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String parameterName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    private int findParameterPositionByAppContext(String name) throws OdaException {
        if (this.parameterDefn != null) {
            int i = 1;
            while (i <= this.parameterDefn.getParameterCount()) {
                if (this.parameterDefn.getParameterName(i).equals(name)) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public IParameterRowSet getRow(String parameterName) throws OdaException {
        return null;
    }

    public IResultSet getResultSet() throws OdaException {
        try {
            if (!this.isExecuted) {
                this.execute();
            }
            if (this.outputParameterResultSetsMap.size() > 0) {
                return new ResultSet(this.outputParameterResultSetsMap.get(this.resultSetNames[this.resultIndex]));
            }
            if (!this.isExecuted) {
                this.rs = this.callStat.getResultSet();
            }
            if (this.rs != null) {
                return new ResultSet(this.rs);
            }
            return new SPResultSet(null);
        }
        catch (SQLException e) {
            throw new JDBCException("odajdbc.CannotGetResultSet", e);
        }
    }

    public IResultSet getResultSet(String resultSetName) throws OdaException {
        if (this.outputParameterResultSetsMap.size() > 0 && this.outputParameterResultSetsMap.containsKey(resultSetName)) {
            return new ResultSet(this.outputParameterResultSetsMap.get(resultSetName));
        }
        throw new JDBCException("odajdbc.CannotGetResultSet", -1);
    }

    public boolean getMoreResults() throws OdaException {
        block5: {
            try {
                if (!this.isExecuted) {
                    this.execute();
                }
                if (this.outputParameterResultSetsMap.size() <= 0) break block5;
                ++this.resultIndex;
                return this.resultIndex < this.outputParameterResultSetsMap.size();
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetResultSet", e);
            }
        }
        boolean flag = this.callStat.getMoreResults();
        if (flag) {
            this.rs = this.callStat.getResultSet();
        }
        return flag;
    }

    public IParameterRowSet getRow(int parameterId) throws OdaException {
        return null;
    }

    public IResultSetMetaData getMetaDataOf(String resultSetName) throws OdaException {
        if (this.outputParameterResultSetsMap.size() == 0 || this.outputParameterResultSetsMap.get(resultSetName) == null) {
            this.getMetaData();
        }
        if (this.outputParameterResultSetsMap.get(resultSetName) != null) {
            try {
                if (this.outputParameterResultSetsMap.get(resultSetName) != null) {
                    return new ResultSetMetaData(this.outputParameterResultSetsMap.get(resultSetName).getMetaData());
                }
            }
            catch (SQLException e) {
                throw new JDBCException("odajdbc.CannotGetResultSetMetadata", e);
            }
        }
        return null;
    }

    public int findInParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        logger.logp(Level.FINE, Statement.class.getName(), "findInParameter", "No named Parameter supported.", e);
        throw e;
    }

    public int findOutParameter(String parameterName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("No named Parameter supported.");
        logger.logp(Level.FINE, Statement.class.getName(), "findOutParameter", "No named Parameter supported.", e);
        throw e;
    }

    public IParameterMetaData getParameterMetaData() throws OdaException {
        this.assertNotNull(this.callStat);
        if (this.cachedParameterMetaData != null) {
            return this.cachedParameterMetaData;
        }
        int[] positionArray = this.paramUtil.getParameterPositions();
        List paramMetaList1 = this.getCallableParamMetaData();
        ArrayList<ParameterDefn> paramMetaList2 = new ArrayList<ParameterDefn>();
        int containsReturnValue = 0;
        if (paramMetaList1.size() > 0 && ((ParameterDefn)paramMetaList1.get(0)).getParamInOutType() == 5) {
            if (this.paramUtil.containsReturnValue()) {
                paramMetaList2.add((ParameterDefn)paramMetaList1.get(0));
            }
            ++containsReturnValue;
        }
        int i = 0;
        while (i < positionArray.length) {
            int index = positionArray[i];
            if (paramMetaList1.size() < index + containsReturnValue) {
                throw new OdaException("odajdbc.CannotGetParameterMetadata");
            }
            paramMetaList2.add((ParameterDefn)paramMetaList1.get(index - 1 + containsReturnValue));
            ++i;
        }
        this.cachedParameterMetaData = new SPParameterMetaData(paramMetaList2);
        return this.cachedParameterMetaData;
    }

    private List getCallableParamMetaData() {
        ArrayList<ParameterDefn> paramMetaDataList = new ArrayList<ParameterDefn>();
        try {
            DatabaseMetaData metaData = this.conn.getMetaData();
            String cataLog = this.conn.getCatalog();
            String procedureNamePattern = this.getNamePattern(this.paramUtil.getProcedure());
            String schemaPattern = null;
            if (this.paramUtil.getSchema() != null) {
                schemaPattern = this.getNamePattern(this.paramUtil.getSchema());
            }
            if (!metaData.supportsCatalogsInProcedureCalls() && this.paramUtil.getPackage() != null) {
                cataLog = this.getNamePattern(this.paramUtil.getPackage());
            }
            java.sql.ResultSet rs = null;
            rs = metaData.getProcedureColumns(cataLog, schemaPattern, procedureNamePattern, null);
            while (rs.next()) {
                ParameterDefn p = new ParameterDefn();
                p.setParamName(rs.getString("COLUMN_NAME"));
                p.setParamInOutType(rs.getInt("COLUMN_TYPE"));
                p.setParamType(rs.getInt("DATA_TYPE"));
                p.setParamTypeName(rs.getString("TYPE_NAME"));
                p.setPrecision(rs.getInt("PRECISION"));
                p.setScale(rs.getInt("SCALE"));
                p.setIsNullable(rs.getInt("NULLABLE"));
                if (p.getParamType() == 1111) {
                    this.correctParamType(p);
                }
                paramMetaDataList.add(p);
            }
            rs.close();
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Fail to get SP paramters", e);
        }
        catch (JDBCException ex) {
            logger.log(Level.SEVERE, "Fail to get SP paramters", (Throwable)((Object)ex));
        }
        return paramMetaDataList;
    }

    private String getNamePattern(SPParameterPositionUtil.SPElement spElement) throws SQLException {
        assert (spElement != null);
        DatabaseMetaData dmd = this.conn.getMetaData();
        if (spElement.isIdentifierQuoted()) {
            if (dmd.storesLowerCaseQuotedIdentifiers()) {
                return spElement.getName().toLowerCase();
            }
            if (dmd.storesUpperCaseQuotedIdentifiers()) {
                return spElement.getName().toUpperCase();
            }
            return spElement.getName();
        }
        if (dmd.storesLowerCaseIdentifiers()) {
            return spElement.getName().toLowerCase();
        }
        if (dmd.storesUpperCaseIdentifiers()) {
            return spElement.getName().toUpperCase();
        }
        return spElement.getName();
    }

    private void correctParamType(ParameterDefn parameterDefn) {
        String parameterName = parameterDefn.getParamTypeName().toUpperCase();
        if (parameterName.equals(ORACLE_FLOAT_NAME)) {
            parameterDefn.setParamType(6);
        } else if (parameterName.equals(ORACLE_CURSOR_NAME)) {
            parameterDefn.setParamType(-10);
        } else {
            parameterDefn.setParamType(12);
        }
    }

    public void setSortSpec(SortSpec sortBy) throws OdaException {
        this.setSortSpec(null, sortBy);
    }

    public void setSortSpec(String resultSetName, SortSpec sortBy) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        logger.logp(Level.FINE, CallStatement.class.getName(), "setSortSpec", "setSortSpec is not supported.", e);
        throw e;
    }

    public SortSpec getSortSpec() throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        logger.logp(Level.FINE, CallStatement.class.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public void setSpecification(QuerySpecification querySpec) throws OdaException, UnsupportedOperationException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSpecification is not supported.");
        logger.logp(Level.FINE, CallStatement.class.getName(), "setSpecification", "setSpecification is not supported.", e);
        throw e;
    }

    public QuerySpecification getSpecification() {
        return null;
    }

    public String getEffectiveQueryText() {
        throw new UnsupportedOperationException();
    }

    public SortSpec getSortSpec(String resultSetName) throws OdaException {
        UnsupportedOperationException e = new UnsupportedOperationException("setSortSpec is not supported.");
        logger.logp(Level.FINE, CallStatement.class.getName(), "getSortSpec", "getSortSpec is not supported.", e);
        throw e;
    }

    public void clearInParameters() throws OdaException {
        try {
            this.assertNotNull(this.callStat);
            this.callStat.clearParameters();
        }
        catch (SQLException ex) {
            throw new JDBCException("odajdbc.ClearParametersError", ex);
        }
    }

    private static void rethrowRunTimeException(RuntimeException e, String msg) throws OdaException {
        OdaException odaException = new OdaException(msg);
        odaException.initCause((Throwable)e);
        logger.logp(Level.FINE, CallStatement.class.getName(), "rethrowRunTimeException", msg, odaException);
        throw odaException;
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public String[] getResultSetNames() throws OdaException {
        return this.resultSetNames;
    }
}

