/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal.navigator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jpt.core.JpaPlatform;
import org.eclipse.jpt.core.context.JpaContextNode;
import org.eclipse.jpt.ui.JptUiPlugin;
import org.eclipse.jpt.ui.jface.DelegatingContentAndLabelProvider;
import org.eclipse.jpt.ui.jface.ItemLabelProvider;
import org.eclipse.jpt.ui.jface.ItemLabelProviderFactory;
import org.eclipse.jpt.ui.navigator.JpaNavigatorProvider;

public class JpaNavigatorItemLabelProviderFactory
implements ItemLabelProviderFactory {
    private final Map<String, ItemLabelProviderFactory> delegates = new HashMap<String, ItemLabelProviderFactory>();

    public ItemLabelProvider buildItemLabelProvider(Object item, DelegatingContentAndLabelProvider contentAndLabelProvider) {
        ItemLabelProviderFactory delegate = this.getDelegate(item);
        if (delegate != null) {
            return delegate.buildItemLabelProvider(item, contentAndLabelProvider);
        }
        return null;
    }

    private ItemLabelProviderFactory getDelegate(Object element) {
        if (!(element instanceof IAdaptable)) {
            return null;
        }
        JpaContextNode contextNode = (JpaContextNode)((IAdaptable)element).getAdapter(JpaContextNode.class);
        if (contextNode == null) {
            return null;
        }
        JpaPlatform platform = contextNode.getJpaProject().getJpaPlatform();
        String platformId = platform.getId();
        if (this.delegates.containsKey(platformId)) {
            return this.delegates.get(platformId);
        }
        JpaNavigatorProvider navigatorProvider = JptUiPlugin.instance().getJpaNavigatorProvider(platform);
        ItemLabelProviderFactory delegate = null;
        if (navigatorProvider != null) {
            delegate = navigatorProvider.getItemLabelProviderFactory();
        }
        this.delegates.put(platformId, delegate);
        return delegate;
    }
}

