/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposalComputer;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jpt.core.JpaFile;
import org.eclipse.jpt.core.JpaStructureNode;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.context.java.JavaPersistentType;
import org.eclipse.jpt.core.internal.utility.jdt.ASTTools;
import org.eclipse.jpt.utility.Filter;
import org.eclipse.jpt.utility.internal.CollectionTools;
import org.eclipse.jpt.utility.internal.HashBag;
import org.eclipse.jpt.utility.internal.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaJavaCompletionProposalComputer
implements IJavaCompletionProposalComputer {
    public void sessionStarted() {
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return context instanceof JavaContentAssistInvocationContext ? this.computeCompletionProposals((JavaContentAssistInvocationContext)context) : Collections.emptyList();
    }

    private List<ICompletionProposal> computeCompletionProposals(JavaContentAssistInvocationContext context) {
        try {
            return this.computeCompletionProposals_(context);
        }
        catch (Exception exception) {
            return Collections.emptyList();
        }
    }

    private List<ICompletionProposal> computeCompletionProposals_(JavaContentAssistInvocationContext context) {
        ICompilationUnit cu = context.getCompilationUnit();
        if (cu == null) {
            return Collections.emptyList();
        }
        IFile file = this.getCorrespondingResource(cu);
        if (file == null) {
            return Collections.emptyList();
        }
        JpaFile jpaFile = JptCorePlugin.getJpaFile((IFile)file);
        if (jpaFile == null) {
            return Collections.emptyList();
        }
        HashBag rootStructureNodes = CollectionTools.collection((Iterator)jpaFile.rootStructureNodes());
        if (rootStructureNodes.isEmpty()) {
            return Collections.emptyList();
        }
        CompletionContext cc = context.getCoreContext();
        char[] prefix = cc.getToken();
        Filter filter = prefix == null ? Filter.Null.instance() : new IgnoreCasePrefixFilter(prefix);
        int tokenStart = cc.getTokenStart();
        int tokenEnd = cc.getTokenEnd();
        if (tokenStart == -1) {
            return Collections.emptyList();
        }
        CompilationUnit astRoot = ASTTools.buildASTRoot((ICompilationUnit)cu);
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        for (JpaStructureNode structureNode : rootStructureNodes) {
            Iterator stream = ((JavaPersistentType)structureNode).javaCompletionProposals(context.getInvocationOffset(), filter, astRoot);
            while (stream.hasNext()) {
                String s = (String)stream.next();
                proposals.add((ICompletionProposal)new CompletionProposal(s, tokenStart, tokenEnd - tokenStart + 1, s.length()));
            }
        }
        return proposals;
    }

    private IFile getCorrespondingResource(ICompilationUnit cu) {
        try {
            return (IFile)cu.getCorrespondingResource();
        }
        catch (JavaModelException ex) {
            JptCorePlugin.log((Throwable)ex);
            return null;
        }
    }

    public List computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IgnoreCasePrefixFilter
    implements Filter<String> {
        private final char[] prefix;

        IgnoreCasePrefixFilter(char[] prefix) {
            this.prefix = prefix;
        }

        public boolean accept(String s) {
            return StringTools.stringStartsWithIgnoreCase((char[])s.toCharArray(), (char[])this.prefix);
        }
    }
}

