/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.jsf.common.ui.internal.guiutils.SWTUtils;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.dialog.StatusDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class LocaleDialog
extends StatusDialog {
    private Text inputText;
    private TableViewer tableViewer;
    private String newLocale;
    private List existedLocaleList;
    private List itemsList;
    private static final int TEXT_MINI_WIDTH = 350;
    private static final int TABLEVIEWER_MINI_WIDTH = 200;

    public LocaleDialog(Shell parentShell, List existedLocaleList) {
        super(parentShell);
        this.existedLocaleList = existedLocaleList;
        Locale[] locales = Locale.getAvailableLocales();
        this.itemsList = new ArrayList(locales.length);
        int i = 0;
        int n = locales.length;
        while (i < n) {
            this.itemsList.add(locales[i].toString());
            ++i;
        }
        this.setStatusMessage(EditorMessages.LocaleConfigSection_Wizard_Page_AlreadyExistsError);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(EditorMessages.LocaleConfigSection_Wizard_WindowTitle);
    }

    protected Control createDialogContents(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        parent.setLayout((Layout)layout);
        SWTUtils.createLabel((Composite)parent, (String)EditorMessages.LocaleConfigSection_Wizard_Page_LabelText, (int)1);
        this.inputText = SWTUtils.createTextBox((Composite)parent, (int)1);
        GridData gd = new GridData(768);
        gd.widthHint = 350;
        this.inputText.setLayoutData((Object)gd);
        this.inputText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                LocaleDialog.this.newLocale = LocaleDialog.this.inputText.getText();
                LocaleDialog.this.tableViewer.resetFilters();
                LocaleDialog.this.tableViewer.addFilter((ViewerFilter)new LocaleViewerFilter(LocaleDialog.this.newLocale));
                LocaleDialog.this.tableViewer.add(LocaleDialog.this.itemsList.toArray());
                LocaleDialog.this.updateStatus();
            }
        });
        this.createTableViewer(parent);
        return parent;
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.tableViewer.add(this.itemsList.toArray());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String text;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (text = (String)selection.getFirstElement()) != null && text.length() > 0) {
                    LocaleDialog.this.newLocale = text;
                    LocaleDialog.this.inputText.setText(text);
                    LocaleDialog.this.updateStatus();
                }
            }
        });
    }

    protected boolean isValid() {
        return this.existedLocaleList == null || !this.existedLocaleList.contains(this.newLocale);
    }

    public String getResult() {
        return this.newLocale;
    }

    class LocaleViewerFilter
    extends ViewerFilter {
        private String locale;

        LocaleViewerFilter(String locale) {
            this.locale = locale;
        }

        public boolean select(Viewer v, Object parent, Object object) {
            if (object instanceof String) {
                if (this.locale == null || this.locale.length() == 0) {
                    return true;
                }
                String aLocale = (String)object;
                return aLocale.startsWith(this.locale);
            }
            return false;
        }
    }
}

