/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.util.AttachmentUtil;
import org.eclipse.mylyn.internal.tasks.ui.util.TasksUiInternal;
import org.eclipse.mylyn.tasks.core.ITask;

public class TaskPropertyTester
extends PropertyTester {
    private static final String PROPERTY_CAN_GET_ATTACHEMNT = "canGetAttachment";
    private static final String PROPERTY_CAN_POST_ATTACHMENT = "canPostAttachment";
    private static final String PROPERTY_CONNECTOR_KIND = "connectorKind";
    private static final String PROPERTY_HAS_ACTIVE_TIME = "hasActiveTime";
    private static final String PROPERTY_HAS_EDITS = "hasEdits";
    private static final String PROPERTY_HAS_LOCAL_CONTEXT = "hasLocalContext";
    private static final String PROPERTY_HAS_REPOSITORY_CONTEXT = "hasRepositoryContext";
    private static final String PROPERTY_IS_COMPLETED = "isCompleted";
    private static final String PROPERTY_IS_LOCAL = "isLocal";
    private static final String PROPERTY_LOCAL_COMPLETION_STATE = "hasLocalCompletionState";

    private boolean equals(boolean value, Object expectedValue) {
        return new Boolean(value).equals(expectedValue);
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof ITask) {
            ITask task = (ITask)receiver;
            if (PROPERTY_CONNECTOR_KIND.equals(property)) {
                return task.getConnectorKind().equals(expectedValue);
            }
            if (PROPERTY_CAN_POST_ATTACHMENT.equals(property)) {
                return this.equals(AttachmentUtil.canDownloadAttachment(task), expectedValue);
            }
            if (PROPERTY_CAN_GET_ATTACHEMNT.equals(property)) {
                return this.equals(AttachmentUtil.canUploadAttachment(task), expectedValue);
            }
            if (PROPERTY_HAS_ACTIVE_TIME.equals(property)) {
                return this.equals(TasksUiInternal.getActiveTime(task) > 0L, expectedValue);
            }
            if (PROPERTY_HAS_EDITS.equals(property)) {
                return this.equals(ClearOutgoingAction.hasOutgoingChanges(task), expectedValue);
            }
            if (PROPERTY_HAS_LOCAL_CONTEXT.equals(property)) {
                return this.equals(AttachmentUtil.hasLocalContext(task), expectedValue);
            }
            if (PROPERTY_HAS_REPOSITORY_CONTEXT.equals(property)) {
                return this.equals(AttachmentUtil.hasContextAttachment(task), expectedValue);
            }
            if (PROPERTY_IS_COMPLETED.equals(property)) {
                return this.equals(task.isCompleted(), expectedValue);
            }
            if (PROPERTY_IS_LOCAL.equals(property)) {
                return task instanceof AbstractTask && this.equals(((AbstractTask)task).isLocal(), expectedValue);
            }
            if (PROPERTY_LOCAL_COMPLETION_STATE.equals(property)) {
                return this.equals(TasksUiInternal.hasLocalCompletionState(task), expectedValue);
            }
        }
        return false;
    }
}

