/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.internal.corext.refactoring.rename.RenameFieldProcessor;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameInputWizardPage;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameRefactoringWizard;

public class RenameFieldWizard
extends RenameRefactoringWizard {
    public RenameFieldWizard(Refactoring refactoring) {
        super(refactoring, RefactoringMessages.RenameFieldWizard_defaultPageTitle, RefactoringMessages.RenameFieldWizard_inputPage_description, JavaPluginImages.DESC_WIZBAN_REFACTOR_FIELD, "org.eclipse.wst.jsdt.ui.rename_field_wizard_page_context");
    }

    protected RenameInputWizardPage createInputPage(String message, String initialSetting) {
        return new RenameFieldInputWizardPage(message, "org.eclipse.wst.jsdt.ui.rename_field_wizard_page_context", initialSetting){

            protected RefactoringStatus validateTextField(String text) {
                RefactoringStatus result = RenameFieldWizard.this.validateNewName(text);
                this.updateGetterSetterLabels();
                return result;
            }
        };
    }

    private static class RenameFieldInputWizardPage
    extends RenameInputWizardPage {
        private Button fRenameGetter;
        private Button fRenameSetter;
        private String fGetterRenamingErrorMessage;
        private String fSetterRenamingErrorMessage;

        public RenameFieldInputWizardPage(String message, String contextHelpId, String initialValue) {
            super(message, contextHelpId, true, initialValue);
        }

        public void createControl(Composite parent) {
            super.createControl(parent);
            Composite parentComposite = (Composite)this.getControl();
            Composite composite = new Composite(parentComposite, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(1808));
            Label separator = new Label(composite, 258);
            separator.setLayoutData((Object)new GridData(768));
            this.getGetterSetterRenamingEnablement();
            this.fRenameGetter = new Button(composite, 32);
            boolean getterEnablement = this.fGetterRenamingErrorMessage == null;
            this.fRenameGetter.setEnabled(getterEnablement);
            boolean getterSelection = getterEnablement && this.getBooleanSetting("renameGetter", this.getRenameFieldProcessor().getRenameGetter());
            this.fRenameGetter.setSelection(getterSelection);
            this.getRenameFieldProcessor().setRenameGetter(getterSelection);
            this.fRenameGetter.setLayoutData((Object)new GridData(768));
            this.fRenameGetter.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ RenameFieldInputWizardPage this$1;
                {
                    this.this$1 = renameFieldInputWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    RenameFieldInputWizardPage.access$0(this.this$1).setRenameGetter(RenameFieldInputWizardPage.access$1(this.this$1).getSelection());
                    this.this$1.updateLeaveDelegateCheckbox(RenameFieldInputWizardPage.access$0(this.this$1).getDelegateCount());
                }
            });
            this.fRenameSetter = new Button(composite, 32);
            boolean setterEnablement = this.fSetterRenamingErrorMessage == null;
            this.fRenameSetter.setEnabled(setterEnablement);
            boolean setterSelection = setterEnablement && this.getBooleanSetting("renameSetter", this.getRenameFieldProcessor().getRenameSetter());
            this.fRenameSetter.setSelection(setterSelection);
            this.getRenameFieldProcessor().setRenameSetter(setterSelection);
            this.fRenameSetter.setLayoutData((Object)new GridData(768));
            this.fRenameSetter.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ RenameFieldInputWizardPage this$1;
                {
                    this.this$1 = renameFieldInputWizardPage;
                }

                public void widgetSelected(SelectionEvent e) {
                    RenameFieldInputWizardPage.access$0(this.this$1).setRenameSetter(RenameFieldInputWizardPage.access$2(this.this$1).getSelection());
                    this.this$1.updateLeaveDelegateCheckbox(RenameFieldInputWizardPage.access$0(this.this$1).getDelegateCount());
                }
            });
            this.updateGetterSetterLabels();
            this.updateLeaveDelegateCheckbox(this.getRenameFieldProcessor().getDelegateCount());
            Dialog.applyDialogFont((Control)composite);
        }

        public void dispose() {
            if (this.saveSettings()) {
                if (this.fRenameGetter.isEnabled()) {
                    this.saveBooleanSetting("renameGetter", this.fRenameGetter);
                }
                if (this.fRenameSetter.isEnabled()) {
                    this.saveBooleanSetting("renameSetter", this.fRenameSetter);
                }
            }
            super.dispose();
        }

        private void getGetterSetterRenamingEnablement() {
            BusyIndicator.showWhile((Display)this.getShell().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ RenameFieldInputWizardPage this$1;
                {
                    this.this$1 = renameFieldInputWizardPage;
                }

                public void run() {
                    RenameFieldInputWizardPage.access$3(this.this$1);
                    RenameFieldInputWizardPage.access$4(this.this$1);
                }
            });
        }

        protected void updateGetterSetterLabels() {
            this.fRenameGetter.setText(this.getRenameGetterLabel());
            this.fRenameSetter.setText(this.getRenameSetterLabel());
        }

        private String getRenameGetterLabel() {
            String defaultLabel = RefactoringMessages.RenameFieldInputWizardPage_rename_getter;
            if (this.fGetterRenamingErrorMessage != null) {
                return this.constructDisabledGetterRenamingLabel(defaultLabel);
            }
            try {
                IFunction getter = this.getRenameFieldProcessor().getGetter();
                if (getter == null || !getter.exists()) {
                    return defaultLabel;
                }
                String oldGetterName = getter.getElementName();
                String newGetterName = this.createNewGetterName();
                return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_rename_getter_to, new String[]{oldGetterName, newGetterName});
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                return defaultLabel;
            }
        }

        private String getRenameSetterLabel() {
            String defaultLabel = RefactoringMessages.RenameFieldInputWizardPage_rename_setter;
            if (this.fSetterRenamingErrorMessage != null) {
                return this.constructDisabledSetterRenamingLabel(defaultLabel);
            }
            try {
                IFunction setter = this.getRenameFieldProcessor().getSetter();
                if (setter == null || !setter.exists()) {
                    return defaultLabel;
                }
                String oldSetterName = setter.getElementName();
                String newSetterName = this.createNewSetterName();
                return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_rename_setter_to, new String[]{oldSetterName, newSetterName});
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                return defaultLabel;
            }
        }

        private String constructDisabledSetterRenamingLabel(String defaultLabel) {
            if (this.fSetterRenamingErrorMessage.equals("")) {
                return defaultLabel;
            }
            Object[] keys = new String[]{defaultLabel, this.fSetterRenamingErrorMessage};
            return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_setter_label, keys);
        }

        private String constructDisabledGetterRenamingLabel(String defaultLabel) {
            if (this.fGetterRenamingErrorMessage.equals("")) {
                return defaultLabel;
            }
            Object[] keys = new String[]{defaultLabel, this.fGetterRenamingErrorMessage};
            return Messages.format(RefactoringMessages.RenameFieldInputWizardPage_getter_label, keys);
        }

        private String createNewGetterName() throws CoreException {
            return this.getRenameFieldProcessor().getNewGetterName();
        }

        private String createNewSetterName() throws CoreException {
            return this.getRenameFieldProcessor().getNewSetterName();
        }

        private String checkGetterRenamingEnablement() {
            if (this.fGetterRenamingErrorMessage != null) {
                return this.fGetterRenamingErrorMessage;
            }
            try {
                this.fGetterRenamingErrorMessage = this.getRenameFieldProcessor().canEnableGetterRenaming();
                return this.fGetterRenamingErrorMessage;
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                return "";
            }
        }

        private String checkSetterRenamingEnablement() {
            if (this.fSetterRenamingErrorMessage != null) {
                return this.fSetterRenamingErrorMessage;
            }
            try {
                this.fSetterRenamingErrorMessage = this.getRenameFieldProcessor().canEnableSetterRenaming();
                return this.fSetterRenamingErrorMessage;
            }
            catch (CoreException e) {
                JavaScriptPlugin.log(e);
                return "";
            }
        }

        private RenameFieldProcessor getRenameFieldProcessor() {
            return (RenameFieldProcessor)((RenameRefactoring)this.getRefactoring()).getProcessor();
        }

        static /* synthetic */ RenameFieldProcessor access$0(RenameFieldInputWizardPage renameFieldInputWizardPage) {
            return renameFieldInputWizardPage.getRenameFieldProcessor();
        }

        static /* synthetic */ Button access$1(RenameFieldInputWizardPage renameFieldInputWizardPage) {
            return renameFieldInputWizardPage.fRenameGetter;
        }

        static /* synthetic */ Button access$2(RenameFieldInputWizardPage renameFieldInputWizardPage) {
            return renameFieldInputWizardPage.fRenameSetter;
        }

        static /* synthetic */ String access$3(RenameFieldInputWizardPage renameFieldInputWizardPage) {
            return renameFieldInputWizardPage.checkGetterRenamingEnablement();
        }

        static /* synthetic */ String access$4(RenameFieldInputWizardPage renameFieldInputWizardPage) {
            return renameFieldInputWizardPage.checkSetterRenamingEnablement();
        }
    }
}

