/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.utility;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jpt.core.internal.utility.JobCommand;
import org.eclipse.jpt.utility.internal.StringTools;
import org.eclipse.jpt.utility.internal.synchronizers.Synchronizer;

public class JobSynchronizer
implements Synchronizer {
    private final SynchronizationJob job;

    public JobSynchronizer(String jobName, JobCommand command) {
        this(jobName, command, null);
    }

    public JobSynchronizer(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
        this.job = this.buildJob(jobName, command, schedulingRule);
    }

    SynchronizationJob buildJob(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
        return new SynchronizationJob(jobName, command, schedulingRule);
    }

    public void start() {
        this.job.start();
    }

    public void synchronize() {
        this.job.synchronize();
    }

    public void stop() {
        this.job.stop();
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)((Object)this.job));
    }

    static class SynchronizationJob
    extends Job {
        private final JobCommand command;
        volatile boolean shouldSchedule;

        SynchronizationJob(String jobName, JobCommand command, ISchedulingRule schedulingRule) {
            super(jobName);
            if (command == null) {
                throw new NullPointerException();
            }
            this.command = command;
            this.shouldSchedule = false;
            this.setRule(schedulingRule);
        }

        void start() {
            if (this.shouldSchedule) {
                throw new IllegalStateException("The Synchronizer was not stopped.");
            }
            this.shouldSchedule = true;
        }

        void synchronize() {
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            return this.command.execute(monitor);
        }

        void stop() {
            if (!this.shouldSchedule) {
                throw new IllegalStateException("The Synchronizer was not started.");
            }
            this.shouldSchedule = false;
            this.cancel();
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {}
        }

        public boolean shouldSchedule() {
            return this.shouldSchedule;
        }
    }
}

