/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.resource.java.binary;

import java.util.ListIterator;
import java.util.Vector;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryAnnotation;
import org.eclipse.jpt.core.internal.resource.java.binary.BinaryUniqueConstraintAnnotation;
import org.eclipse.jpt.core.resource.java.BaseTableAnnotation;
import org.eclipse.jpt.core.resource.java.JavaResourceNode;
import org.eclipse.jpt.core.resource.java.UniqueConstraintAnnotation;
import org.eclipse.jpt.core.utility.TextRange;
import org.eclipse.jpt.utility.internal.iterators.CloneListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BinaryBaseTableAnnotation
extends BinaryAnnotation
implements BaseTableAnnotation {
    String name = this.buildName();
    String schema = this.buildSchema();
    String catalog = this.buildCatalog();
    final Vector<UniqueConstraintAnnotation> uniqueConstraints = this.buildUniqueConstraints();

    protected BinaryBaseTableAnnotation(JavaResourceNode parent, IAnnotation jdtAnnotation) {
        super(parent, jdtAnnotation);
    }

    @Override
    public void update() {
        super.update();
        this.setName_(this.buildName());
        this.setSchema_(this.buildSchema());
        this.setCatalog_(this.buildCatalog());
        this.updateUniqueConstraints();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.name);
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        throw new UnsupportedOperationException();
    }

    private void setName_(String name) {
        String old = this.name;
        this.name = name;
        this.firePropertyChanged("name", old, name);
    }

    private String buildName() {
        return (String)this.getJdtMemberValue(this.getNameElementName());
    }

    protected abstract String getNameElementName();

    @Override
    public TextRange getNameTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean nameTouches(int pos, CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSchema() {
        return this.schema;
    }

    @Override
    public void setSchema(String schema) {
        throw new UnsupportedOperationException();
    }

    private void setSchema_(String schema) {
        String old = this.schema;
        this.schema = schema;
        this.firePropertyChanged("schema", old, schema);
    }

    private String buildSchema() {
        return (String)this.getJdtMemberValue(this.getSchemaElementName());
    }

    protected abstract String getSchemaElementName();

    @Override
    public TextRange getSchemaTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean schemaTouches(int pos, CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    @Override
    public void setCatalog(String catalog) {
        throw new UnsupportedOperationException();
    }

    private void setCatalog_(String catalog) {
        String old = this.catalog;
        this.catalog = catalog;
        this.firePropertyChanged("catalog", old, catalog);
    }

    private String buildCatalog() {
        return (String)this.getJdtMemberValue(this.getCatalogElementName());
    }

    protected abstract String getCatalogElementName();

    @Override
    public TextRange getCatalogTextRange(CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean catalogTouches(int pos, CompilationUnit astRoot) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<UniqueConstraintAnnotation> uniqueConstraints() {
        return new CloneListIterator(this.uniqueConstraints);
    }

    @Override
    public int uniqueConstraintsSize() {
        return this.uniqueConstraints.size();
    }

    @Override
    public UniqueConstraintAnnotation uniqueConstraintAt(int index) {
        return this.uniqueConstraints.get(index);
    }

    @Override
    public int indexOfUniqueConstraint(UniqueConstraintAnnotation uniqueConstraint) {
        return this.uniqueConstraints.indexOf(uniqueConstraint);
    }

    @Override
    public UniqueConstraintAnnotation addUniqueConstraint(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeUniqueConstraint(int index) {
        throw new UnsupportedOperationException();
    }

    private Vector<UniqueConstraintAnnotation> buildUniqueConstraints() {
        Object[] jdtUniqueConstraints = this.getJdtMemberValues(this.getUniqueConstraintElementName());
        Vector<UniqueConstraintAnnotation> result = new Vector<UniqueConstraintAnnotation>(jdtUniqueConstraints.length);
        Object[] objectArray = jdtUniqueConstraints;
        int n = jdtUniqueConstraints.length;
        int n2 = 0;
        while (n2 < n) {
            Object jdtUniqueConstraint = objectArray[n2];
            result.add(new BinaryUniqueConstraintAnnotation(this, (IAnnotation)jdtUniqueConstraint));
            ++n2;
        }
        return result;
    }

    protected abstract String getUniqueConstraintElementName();

    private void updateUniqueConstraints() {
        throw new UnsupportedOperationException();
    }
}

