/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.core.internal.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jem.util.emf.workbench.ProjectUtilities;
import org.eclipse.jpt.core.JpaProject;
import org.eclipse.jpt.core.JptCorePlugin;
import org.eclipse.jpt.core.internal.operations.JpaFileCreationDataModelProperties;
import org.eclipse.jpt.core.resource.AbstractXmlResourceProvider;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;

public abstract class AbstractJpaFileCreationOperation
extends AbstractDataModelOperation
implements JpaFileCreationDataModelProperties {
    protected IFolder createdSourceFolder;
    protected IFile createdFile;

    protected AbstractJpaFileCreationOperation(IDataModel dataModel) {
        super(dataModel);
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.createSourceFolder();
        this.createFile();
        return OK_STATUS;
    }

    protected IProject getProject() throws ExecutionException {
        String projectName = (String)this.getDataModel().getProperty("JpaFileCreationDataModelProperties.PROJECT_NAME");
        IProject project = ProjectUtilities.getProject((String)projectName);
        if (project == null) {
            throw new ExecutionException("No project name specified");
        }
        return project;
    }

    protected JpaProject getJpaProject() throws ExecutionException {
        IProject project = this.getProject();
        JpaProject jpaProject = JptCorePlugin.getJpaProject(project);
        if (jpaProject == null) {
            throw new ExecutionException("Project does not have JPA content");
        }
        return jpaProject;
    }

    protected void createSourceFolder() throws ExecutionException {
        String folderPath = this.model.getStringProperty("JpaFileCreationDataModelProperties.SOURCE_FOLDER");
        IProject project = this.getProject();
        IFolder folder = project.getWorkspace().getRoot().getFolder((IPath)new Path(folderPath));
        if (!folder.exists()) {
            try {
                folder.create(true, true, null);
            }
            catch (CoreException e) {
                throw new ExecutionException("Could not create folder", (Throwable)e);
            }
        }
        this.createdSourceFolder = folder;
    }

    protected void createFile() {
        String filePath = this.getDataModel().getStringProperty("JpaFileCreationDataModelProperties.FILE_PATH");
        IFile newFile = this.createdSourceFolder.getFile((IPath)new Path(filePath));
        AbstractXmlResourceProvider resourceProvider = this.getXmlResourceProvider(newFile);
        try {
            resourceProvider.createFileAndResource(this.getDataModel());
        }
        catch (CoreException e) {
            JptCorePlugin.log(e);
            newFile = null;
        }
        this.createdFile = newFile;
    }

    public ISchedulingRule getSchedulingRule() {
        try {
            return this.getProject();
        }
        catch (ExecutionException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected abstract AbstractXmlResourceProvider getXmlResourceProvider(IFile var1);
}

