/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.ui.widgets;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIMessages;
import org.eclipse.jst.ws.internal.cxf.creation.ui.CXFCreationUIPlugin;
import org.eclipse.jst.ws.internal.cxf.ui.widgets.Java2WSWidgetFactory;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.command.internal.env.ui.widgets.SimpleWidgetDataContributor;
import org.eclipse.wst.command.internal.env.ui.widgets.WidgetDataEvents;

public class Java2WSInterfaceConfigWidget
extends SimpleWidgetDataContributor {
    private IStatus IMPL_SELECTION_STATUS = Status.OK_STATUS;
    private Java2WSDataModel model;
    private IType startingPointType;
    private Combo selectImplementationCombo;

    public void setJava2WSDataModel(Java2WSDataModel model) {
        this.model = model;
    }

    public void setJavaStartingPointType(IType startingPointType) {
        this.startingPointType = startingPointType;
    }

    public WidgetDataEvents addControls(Composite parent, final Listener statusListener) {
        final Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, false);
        composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)gridData);
        Java2WSWidgetFactory.createSelectImplementationLabel((Composite)composite);
        this.selectImplementationCombo = Java2WSWidgetFactory.createSelectImplementationCombo((Composite)composite, (Java2WSDataModel)this.model, (IType)this.startingPointType);
        gridData = new GridData(4, 4, true, false);
        this.selectImplementationCombo.setLayoutData((Object)gridData);
        this.selectImplementationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Java2WSInterfaceConfigWidget.this.validateImplementationSelection();
                statusListener.handleEvent(null);
            }
        });
        this.selectImplementationCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                Java2WSInterfaceConfigWidget.this.validateImplementationSelection();
                statusListener.handleEvent(null);
            }
        });
        Button browseImplButton = Java2WSWidgetFactory.createBrowseButton((Composite)composite);
        gridData = new GridData(4, 4, false, false);
        browseImplButton.setLayoutData((Object)gridData);
        browseImplButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog selectionDialog = Java2WSWidgetFactory.createElementTreeSelectionDialog((Shell)composite.getShell(), (String)CXFCreationUIMessages.JAVA2WS_SELECT_IMPL_DIALOG_TITLE, (String)CXFCreationUIMessages.JAVA2WS_SELECT_IMPL_DIALOG_DESCRIPTION, (IJavaProject)JDTUtils.getJavaProject((String)Java2WSInterfaceConfigWidget.this.model.getProjectName()), (int)5);
                int returnCode = selectionDialog.open();
                if (returnCode == 0) {
                    ICompilationUnit selectedCompilationUnit = (ICompilationUnit)selectionDialog.getFirstResult();
                    String selectedImplementation = selectedCompilationUnit.findPrimaryType().getFullyQualifiedName();
                    List<String> impls = Arrays.asList(Java2WSInterfaceConfigWidget.this.selectImplementationCombo.getItems());
                    if (!impls.contains(selectedImplementation)) {
                        Java2WSInterfaceConfigWidget.this.selectImplementationCombo.add(selectedImplementation);
                    }
                    Java2WSInterfaceConfigWidget.this.selectImplementationCombo.setText(selectedImplementation);
                }
            }
        });
        return this;
    }

    public IStatus getStatus() {
        return this.IMPL_SELECTION_STATUS;
    }

    private void validateImplementationSelection() {
        IType implType = JDTUtils.findType((String)this.model.getProjectName(), (String)this.selectImplementationCombo.getText());
        if (implType != null) {
            try {
                IMethod[] seiMethods;
                IMethod[] iMethodArray = seiMethods = this.startingPointType.getMethods();
                int n = seiMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    IMethod seiMethod = iMethodArray[n2];
                    IMethod[] implMethod = implType.findMethods(seiMethod);
                    if (implMethod == null) {
                        this.IMPL_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.bind((String)CXFCreationUIMessages.WEBSERVICE_ENPOINTINTERFACE_MUST_IMPLEMENT, (Object)this.getImplementsMessage(this.startingPointType, seiMethod)));
                        break;
                    }
                    this.IMPL_SELECTION_STATUS = Status.OK_STATUS;
                    ++n2;
                }
                this.model.setServiceEndpointInterfaceName(this.startingPointType.getFullyQualifiedName());
                this.model.setFullyQualifiedJavaClassName(this.selectImplementationCombo.getText());
            }
            catch (JavaModelException jme) {
                CXFCreationUIPlugin.log(jme.getStatus());
            }
        } else {
            this.IMPL_SELECTION_STATUS = new Status(4, "org.eclipse.jst.ws.cxf.creation.ui", CXFCreationUIMessages.bind((String)CXFCreationUIMessages.WEBSERVICE_IMPLEMENTATION_NOT_FOUND, (Object)this.selectImplementationCombo.getText()));
        }
    }

    private String getImplementsMessage(IType seiType, IMethod seiMethod) {
        StringBuilder message = new StringBuilder(seiType.getElementName());
        message.append(".");
        message.append(seiMethod.getElementName());
        message.append("(");
        String[] parameterTypes = seiMethod.getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            String parameterType = Signature.toString((String)parameterTypes[i]);
            message.append(parameterType);
            if (i < parameterTypes.length - 1) {
                message.append(", ");
            }
            ++i;
        }
        message.append(")");
        return message.toString();
    }
}

