/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.jsdt.debug.core.breakpoints.IJavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.core.jsdi.ScriptReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.ThreadReference;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.DebuggerStatementEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ScriptLoadEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ThreadEnterEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.ThreadExitEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.VMDeathEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.VMDisconnectEvent;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.DebuggerStatementRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ScriptLoadRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadEnterRequest;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.ThreadExitRequest;
import org.eclipse.wst.jsdt.debug.core.model.IJavaScriptDebugTarget;
import org.eclipse.wst.jsdt.debug.core.model.IScript;
import org.eclipse.wst.jsdt.debug.core.model.IScriptGroup;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptPreferencesManager;
import org.eclipse.wst.jsdt.debug.internal.core.breakpoints.JavaScriptBreakpoint;
import org.eclipse.wst.jsdt.debug.internal.core.model.EventDispatcher;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugElement;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptThread;
import org.eclipse.wst.jsdt.debug.internal.core.model.ModelMessages;
import org.eclipse.wst.jsdt.debug.internal.core.model.Script;
import org.eclipse.wst.jsdt.debug.internal.core.model.ScriptGroup;

public class JavaScriptDebugTarget
extends JavaScriptDebugElement
implements IJavaScriptDebugTarget,
IDebugEventSetListener,
ILaunchListener,
IJavaScriptEventListener {
    static final String DEFAULT_NAME = ModelMessages.JSDIDebugTarget_jsdi_debug_target;
    static Comparator scriptcompare = new ScriptComparator();
    private ArrayList iScriptCache = null;
    private final IProcess process;
    private final VirtualMachine vm;
    private final ILaunch launch;
    private final boolean supportsTerminate;
    private final boolean supportsDisconnect;
    private final String name;
    private final EventDispatcher eventDispatcher;
    private ArrayList threads = new ArrayList();
    private ArrayList breakpoints = new ArrayList();
    private IScriptGroup scriptgroup = null;
    private boolean disconnected = false;
    private boolean terminating = false;
    private boolean terminated = false;
    private boolean suspended = false;
    private ThreadEnterRequest threadEnterRequest;
    private ThreadExitRequest threadExitRequest;
    private ScriptLoadRequest scriptLoadrequest;
    private DebuggerStatementRequest debuggerStatementRequest;
    static /* synthetic */ Class class$0;

    public JavaScriptDebugTarget(VirtualMachine vm, IProcess process, ILaunch launch, String name, boolean supportsTerminate, boolean supportsDisconnect) {
        super(null);
        this.vm = vm;
        this.process = process;
        this.launch = launch;
        this.supportsTerminate = supportsTerminate;
        this.supportsDisconnect = supportsDisconnect;
        this.name = name != null ? name : (vm.name() != null ? vm.name() : DEFAULT_NAME);
        this.eventDispatcher = new EventDispatcher(this);
        this.scriptgroup = new ScriptGroup(this);
        this.initialize();
    }

    public synchronized void initialize() {
        this.initializeThreads();
        this.initializeBreakpoints();
        this.scriptLoadrequest = this.getEventRequestManager().createScriptLoadRequest();
        this.scriptLoadrequest.setEnabled(true);
        this.addJSDIEventListener(this, this.scriptLoadrequest);
        this.getLaunch().addDebugTarget((IDebugTarget)this);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.addDebugEventListener((IDebugEventSetListener)this);
        plugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        this.fireCreationEvent();
        plugin.asyncExec(new Runnable(){

            public void run() {
                Thread t = new Thread((Runnable)JavaScriptDebugTarget.this.eventDispatcher, "JavaScriptDebugModel.EventDispatcher");
                t.setDaemon(true);
                t.start();
            }
        });
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void shutdown() {
        try {
            try {
                if (this.supportsTerminate) {
                    this.terminate();
                } else if (this.supportsDisconnect) {
                    this.disconnect();
                }
            }
            catch (DebugException e) {
                JavaScriptDebugPlugin.log(e);
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.cleanup();
            this.fireTerminateEvent();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.cleanup();
        }
        this.fireTerminateEvent();
    }

    void cleanup() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
        this.getEventDispatcher().shutdown();
        this.removeAllThreads();
        this.removeAllBreakpoints();
        this.removeJSDIEventListener(this, this.scriptLoadrequest);
        this.scriptgroup = null;
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public String getName() throws DebugException {
        return this.name;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public boolean canTerminate() {
        return this.supportsTerminate && this.isAvailable();
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean canDisconnect() {
        return this.supportsDisconnect && this.isAvailable();
    }

    public boolean isDisconnected() {
        return this.disconnected;
    }

    public synchronized List underlyingScripts(String name) {
        List scripts = this.getVM().allScripts();
        if (!scripts.isEmpty()) {
            ArrayList<ScriptReference> byname = new ArrayList<ScriptReference>();
            ScriptReference script = null;
            Iterator iter = scripts.iterator();
            while (iter.hasNext()) {
                script = (ScriptReference)iter.next();
                if (!URIUtil.lastSegment((URI)script.sourceURI()).equals(name)) continue;
                byname.add(script);
            }
            return byname;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized List allScriptsByName(String name) {
        List scripts = this.allScripts();
        if (scripts.size() > 0) {
            ArrayList<IScript> byname = new ArrayList<IScript>();
            IScript script = null;
            Iterator iter = scripts.iterator();
            while (iter.hasNext()) {
                script = (IScript)iter.next();
                if (!URIUtil.lastSegment((URI)script.sourceURI()).equals(name)) continue;
                byname.add(script);
            }
            return byname;
        }
        return Collections.EMPTY_LIST;
    }

    public synchronized List allScripts() {
        ArrayList all;
        if (this.iScriptCache == null && (all = (ArrayList)this.getVM().allScripts()).size() > 0) {
            this.iScriptCache = new ArrayList(all.size());
            int i = 0;
            while (i < all.size()) {
                this.iScriptCache.add(new Script(this, (ScriptReference)all.get(i)));
                ++i;
            }
            Collections.sort(this.iScriptCache, scriptcompare);
        }
        if (this.iScriptCache == null) {
            return Collections.EMPTY_LIST;
        }
        return this.iScriptCache;
    }

    private synchronized void initializeThreads() {
        this.threadEnterRequest = this.vm.eventRequestManager().createThreadEnterRequest();
        this.threadEnterRequest.setEnabled(true);
        this.eventDispatcher.addEventListener(this, this.threadEnterRequest);
        this.threadExitRequest = this.vm.eventRequestManager().createThreadExitRequest();
        this.threadExitRequest.setEnabled(true);
        this.eventDispatcher.addEventListener(this, this.threadExitRequest);
        List allThreads = this.vm.allThreads();
        ThreadReference threadReference = null;
        Iterator iterator = allThreads.iterator();
        while (iterator.hasNext()) {
            threadReference = (ThreadReference)iterator.next();
            this.createThread(threadReference, false);
        }
    }

    private synchronized void removeAllThreads() {
        Iterator iter = this.getThreadIterator();
        while (iter.hasNext()) {
            JavaScriptThread thread = (JavaScriptThread)iter.next();
            thread.terminated();
        }
        this.threads.clear();
        this.removeJSDIEventListener(this, this.threadEnterRequest);
        this.removeJSDIEventListener(this, this.threadExitRequest);
    }

    public synchronized IThread[] getThreads() throws DebugException {
        return this.threads.toArray(new IThread[this.threads.size()]);
    }

    public synchronized boolean hasThreads() throws DebugException {
        return !this.threads.isEmpty();
    }

    synchronized void initializeBreakpoints() {
        this.debuggerStatementRequest = this.getEventRequestManager().createDebuggerStatementRequest();
        this.debuggerStatementRequest.setEnabled(true);
        this.addJSDIEventListener(this, this.debuggerStatementRequest);
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        manager.addBreakpointListener((IBreakpointListener)this);
        IBreakpoint[] managerBreakpoints = manager.getBreakpoints("org.eclipse.wst.jsdt.debug.model");
        int i = 0;
        while (i < managerBreakpoints.length) {
            this.breakpointAdded(managerBreakpoints[i]);
            ++i;
        }
        IJavaScriptBreakpoint[] breakpoints = JavaScriptPreferencesManager.getAllManagedBreakpoints();
        int i2 = 0;
        while (i2 < breakpoints.length) {
            this.breakpointAdded(breakpoints[i2]);
            ++i2;
        }
    }

    private synchronized void removeAllBreakpoints() {
        Iterator iter = ((ArrayList)this.breakpoints.clone()).iterator();
        JavaScriptBreakpoint breakpoint = null;
        while (iter.hasNext()) {
            breakpoint = (JavaScriptBreakpoint)iter.next();
            breakpoint.removeFromTarget(this);
        }
        this.breakpoints.clear();
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return "org.eclipse.wst.jsdt.debug.model".equals(breakpoint.getModelIdentifier());
    }

    public boolean canResume() {
        if ((this.isSuspended() || this.canResumeThreads()) && this.isAvailable()) {
            if (this.threads.size() == 0) {
                return true;
            }
            Iterator iter = this.getThreadIterator();
            while (iter.hasNext()) {
                IThread thread = (IThread)iter.next();
                if (!thread.canResume()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean canResumeThreads() {
        Iterator iter = this.getThreadIterator();
        IThread thread = null;
        while (iter.hasNext()) {
            thread = (IThread)iter.next();
            if (!thread.canResume()) continue;
            return true;
        }
        return false;
    }

    public boolean canSuspend() {
        if (!this.isSuspended() && this.isAvailable()) {
            Iterator iter = this.getThreadIterator();
            while (iter.hasNext()) {
                IThread thread = (IThread)iter.next();
                if (!thread.isSuspended()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator getThreadIterator() {
        List threadList;
        ArrayList arrayList = this.threads;
        synchronized (arrayList) {
            threadList = (List)this.threads.clone();
        }
        return threadList.iterator();
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        Iterator iter = this.getThreadIterator();
        JavaScriptThread thread = null;
        while (iter.hasNext()) {
            thread = (JavaScriptThread)iter.next();
            if (!thread.isSuspended()) continue;
            thread.targetResume();
        }
        this.suspended = false;
        this.resumeVM(false);
        this.fireResumeEvent(32);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void suspend() throws DebugException {
        if (this.isSuspended()) return;
        if (!this.isAvailable()) {
            return;
        }
        try {
            this.suspended = true;
            if (this.vm != null) {
                this.vm.suspend();
            }
            Iterator iter = this.getThreadIterator();
            while (iter.hasNext()) {
                JavaScriptThread thread = (JavaScriptThread)iter.next();
                if (thread.isSuspended()) continue;
                thread.markSuspended();
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.fireSuspendEvent(32);
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        this.fireSuspendEvent(32);
    }

    public IScriptGroup getScriptGroup() {
        return this.scriptgroup;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void disconnect() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.supportsDisconnect) {
            this.notSupported(NLS.bind((String)ModelMessages.JSDIDebugTarget_not_support_disconnect, (Object)this.getName()), null);
        }
        try {
            try {
                this.resumeVM(true);
            }
            catch (RuntimeException runtimeException) {}
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.cleanup();
            this.disposeVM(true);
            this.disconnected = true;
            this.fireTerminateEvent();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.cleanup();
        }
        this.disposeVM(true);
        this.disconnected = true;
        this.fireTerminateEvent();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void terminate() throws DebugException {
        if (!this.isAvailable()) {
            return;
        }
        if (!this.supportsTerminate) {
            this.notSupported(NLS.bind((String)ModelMessages.JSDIDebugTarget_not_support_terminate, (Object)this.getName()), null);
        }
        this.terminating = true;
        try {
            this.resumeVM(true);
            if (this.process != null) {
                this.process.terminate();
            }
            this.terminated = true;
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.disposeVM(true);
            this.cleanup();
            this.terminating = false;
            this.fireTerminateEvent();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.disposeVM(true);
        this.cleanup();
        this.terminating = false;
        this.fireTerminateEvent();
    }

    void disposeVM(boolean shutdown) throws DebugException {
        block3: {
            if (this.vm != null) {
                try {
                    this.vm.dispose();
                }
                catch (RuntimeException runtimeException) {
                    if (shutdown) break block3;
                    this.disconnect();
                }
            }
        }
    }

    void resumeVM(boolean shutdown) throws DebugException {
        block3: {
            if (this.vm != null) {
                try {
                    this.vm.resume();
                }
                catch (RuntimeException runtimeException) {
                    if (shutdown) break block3;
                    this.disconnect();
                }
            }
        }
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        this.notSupported(ModelMessages.JSDIDebugTarget_unsupported_operation, null);
        return null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public VirtualMachine getVM() {
        return this.vm;
    }

    public boolean isAvailable() {
        return !this.terminated && !this.terminating && !this.disconnected;
    }

    EventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    private synchronized JavaScriptThread createThread(ThreadReference thread, boolean fireEvent) {
        if (this.isDisconnected()) {
            return null;
        }
        JavaScriptThread jsdiThread = this.findThread(thread);
        if (jsdiThread != null) {
            return jsdiThread;
        }
        jsdiThread = new JavaScriptThread(this, thread);
        this.threads.add(jsdiThread);
        if (fireEvent) {
            jsdiThread.fireCreationEvent();
        }
        return jsdiThread;
    }

    private synchronized void terminateThread(ThreadReference thread) {
        if (this.isDisconnected()) {
            return;
        }
        JavaScriptThread jsdiThread = this.findThread(thread);
        if (jsdiThread == null) {
            return;
        }
        this.threads.remove(jsdiThread);
        jsdiThread.markTerminated();
        jsdiThread.fireTerminateEvent();
    }

    public synchronized JavaScriptThread findThread(ThreadReference thread) {
        Iterator iterator = this.threads.iterator();
        while (iterator.hasNext()) {
            JavaScriptThread jsdiThread = (JavaScriptThread)iterator.next();
            if (!jsdiThread.matches(thread)) continue;
            return jsdiThread;
        }
        return null;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (adapter == clazz) {
            return this;
        }
        return super.getAdapter(adapter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.isAvailable() || !this.supportsBreakpoint(breakpoint)) {
            return;
        }
        try {
            ((JavaScriptBreakpoint)breakpoint).addToTarget(this);
            ArrayList arrayList = this.breakpoints;
            synchronized (arrayList) {
                this.breakpoints.add(breakpoint);
            }
        }
        catch (CoreException ce) {
            JavaScriptDebugPlugin.log(ce);
        }
    }

    public synchronized void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.breakpointRemoved(breakpoint, delta);
        this.breakpointAdded(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.isAvailable() || !this.supportsBreakpoint(breakpoint)) {
            return;
        }
        ((JavaScriptBreakpoint)breakpoint).removeFromTarget(this);
        ArrayList arrayList = this.breakpoints;
        synchronized (arrayList) {
            this.breakpoints.remove(breakpoint);
        }
        if (this.threads != null) {
            Iterator iter = this.threads.iterator();
            while (iter.hasNext()) {
                ((JavaScriptThread)iter.next()).removeBreakpoint((JavaScriptBreakpoint)breakpoint);
            }
        }
    }

    public List getBreakpoints() {
        return this.breakpoints;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (events.length == 1) {
            DebugEvent event = events[0];
            switch (event.getKind()) {
                case 8: {
                    if (!event.getSource().equals(this.getProcess())) break;
                    this.shutdown();
                }
            }
        }
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.isAvailable()) {
            return;
        }
        if (launch.equals(this.getLaunch())) {
            this.disconnected();
        }
    }

    protected void disconnected() {
        if (!this.isDisconnected()) {
            this.disconnected = true;
            this.shutdown();
        }
    }

    public void launchAdded(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void eventSetComplete(Event event, JavaScriptDebugTarget target, boolean suspend, EventSet eventSet) {
        if (event instanceof DebuggerStatementEvent) {
            DebuggerStatementEvent debuggerStatementEvent = (DebuggerStatementEvent)event;
            ThreadReference threadReference = debuggerStatementEvent.thread();
            JavaScriptThread thread = this.findThread(threadReference);
            thread.fireSuspendEvent(16);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean handleEvent(Event event, JavaScriptDebugTarget target, boolean suspendVote, EventSet eventSet) {
        if (event instanceof ThreadEnterEvent) {
            ThreadEnterEvent threadEnterEvent = (ThreadEnterEvent)event;
            this.createThread(threadEnterEvent.thread(), true);
            return false;
        }
        if (event instanceof ThreadExitEvent) {
            ThreadExitEvent threadExitEvent = (ThreadExitEvent)event;
            this.terminateThread(threadExitEvent.thread());
            return false;
        }
        if (event instanceof ScriptLoadEvent) {
            if (this.iScriptCache != null) {
                this.iScriptCache.clear();
                this.iScriptCache = null;
            }
            this.fireEvent(new DebugEvent((Object)this.scriptgroup, 32, 1));
            return true;
        }
        if (event instanceof DebuggerStatementEvent) {
            DebuggerStatementEvent debuggerStatementEvent = (DebuggerStatementEvent)event;
            ThreadReference threadReference = debuggerStatementEvent.thread();
            JavaScriptThread thread = this.findThread(threadReference);
            if (!thread.isSuspended()) {
                thread.markSuspended();
            }
            return false;
        }
        if (event instanceof VMDeathEvent) {
            try {
                if (!this.terminated) {
                    this.eventCleanup();
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                this.shutdown();
                throw throwable;
            }
            {
                Object var5_9 = null;
                this.shutdown();
                return false;
            }
        }
        if (!(event instanceof VMDisconnectEvent)) {
            throw new IllegalArgumentException(NLS.bind((String)ModelMessages.JSDIDebugTarget_recieved_unknown_event, (Object)event.toString()));
        }
        try {
            if (!this.disconnected) {
                this.eventCleanup();
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            this.shutdown();
            throw throwable;
        }
        {
            Object var5_11 = null;
            this.shutdown();
            return false;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void eventCleanup() {
        try {
            this.cleanup();
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.disconnected = true;
            this.terminated = true;
            this.fireTerminateEvent();
            throw throwable;
        }
        {
            Object var1_3 = null;
            this.disconnected = true;
            this.terminated = true;
        }
        this.fireTerminateEvent();
    }

    static class ScriptComparator
    implements Comparator {
        ScriptComparator() {
        }

        public int compare(Object o1, Object o2) {
            return URIUtil.lastSegment((URI)((IScript)o1).sourceURI()).compareTo(URIUtil.lastSegment((URI)((IScript)o2).sourceURI()));
        }
    }
}

