/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigDecimal;
import org.eclipse.wst.xml.xpath2.processor.DynamicContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpEq;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpGt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.CmpLt;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathDiv;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathMinus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathPlus;
import org.eclipse.wst.xml.xpath2.processor.internal.function.MathTimes;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyAtomicType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.CalendarType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.NumericType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSAnyURI;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBase64Binary;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSBoolean;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDayTimeDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDecimal;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDouble;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSDuration;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSHexBinary;

public class XSYearMonthDuration
extends XSDuration
implements CmpEq,
CmpLt,
CmpGt,
MathPlus,
MathMinus,
MathTimes,
MathDiv {
    private static final String XS_YEAR_MONTH_DURATION = "xs:yearMonthDuration";

    public XSYearMonthDuration(int year, int month, boolean negative) {
        super(year, month, 0, 0, 0, 0.0, negative);
    }

    public XSYearMonthDuration(int months) {
        this(0, Math.abs(months), months < 0);
    }

    public XSYearMonthDuration() {
        this(0, 0, false);
    }

    public static XSDuration parseYMDuration(String str) {
        boolean negative = false;
        int year = 0;
        int month = 0;
        int state = 0;
        String digits = "";
        int i = 0;
        while (i < str.length()) {
            char x = str.charAt(i);
            switch (state) {
                case 0: {
                    if (x == '-') {
                        negative = true;
                        state = 4;
                        break;
                    }
                    if (x == 'P') {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 4: {
                    if (x == 'P') {
                        state = 5;
                        break;
                    }
                    return null;
                }
                case 5: {
                    if ('0' <= x && x <= '9') {
                        digits = String.valueOf(digits) + x;
                        break;
                    }
                    if (x == 'Y') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        year = Integer.parseInt(digits);
                        digits = "";
                        state = 6;
                        break;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 6: {
                    if ('0' <= x && x <= '9') {
                        digits = String.valueOf(digits) + x;
                        break;
                    }
                    if (x == 'M') {
                        if (digits.length() == 0) {
                            return null;
                        }
                        month = Integer.parseInt(digits);
                        state = 7;
                        break;
                    }
                    return null;
                }
                case 7: {
                    return null;
                }
                default: {
                    assert (false);
                    return null;
                }
            }
            ++i;
        }
        return new XSYearMonthDuration(year, month, negative);
    }

    public String type_name() {
        return "yearMonthDuration";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyAtomicType aat = (AnyAtomicType)arg.first();
        if (aat instanceof NumericType || aat instanceof CalendarType || aat instanceof XSBoolean || aat instanceof XSBase64Binary || aat instanceof XSHexBinary || aat instanceof XSAnyURI) {
            throw DynamicError.invalidType();
        }
        if (!this.isCastable(aat)) {
            throw DynamicError.cant_cast(null);
        }
        XSDuration ymd = this.castYearMonthDuration(aat);
        if (ymd == null) {
            throw DynamicError.cant_cast(null);
        }
        rs.add(ymd);
        return rs;
    }

    private XSDuration castYearMonthDuration(AnyAtomicType aat) {
        if (aat instanceof XSDuration) {
            XSDuration duration = (XSDuration)aat;
            return new XSYearMonthDuration(duration.year(), duration.month(), duration.negative());
        }
        return XSYearMonthDuration.parseYMDuration(aat.string_value());
    }

    public boolean negative() {
        return this._negative;
    }

    public String string_value() {
        int months;
        String strval = "";
        if (this.negative()) {
            strval = String.valueOf(strval) + "-";
        }
        strval = String.valueOf(strval) + "P";
        int years = this.year();
        if (years != 0) {
            strval = String.valueOf(strval) + years + "Y";
        }
        if ((months = this.month()) == 0) {
            if (years == 0) {
                strval = String.valueOf(strval) + months + "M";
            }
        } else {
            strval = String.valueOf(strval) + months + "M";
        }
        return strval;
    }

    public String string_type() {
        return XS_YEAR_MONTH_DURATION;
    }

    public int monthValue() {
        int ret = this.year() * 12 + this.month();
        if (this.negative()) {
            ret *= -1;
        }
        return ret;
    }

    public boolean eq(AnyType arg, DynamicContext context) throws DynamicError {
        if (arg instanceof XSDayTimeDuration) {
            XSDayTimeDuration dayTimeDuration = (XSDayTimeDuration)arg;
            return this.monthValue() == 0 && dayTimeDuration.value() == 0.0;
        }
        if (arg instanceof XSYearMonthDuration) {
            XSYearMonthDuration yearMonthDuration = (XSYearMonthDuration)arg;
            return this.monthValue() == yearMonthDuration.monthValue();
        }
        XSDuration val = (XSDuration)NumericType.get_single_type(arg, XSDuration.class);
        return super.eq(val, context);
    }

    public boolean lt(AnyType arg, DynamicContext context) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        return this.monthValue() < val.monthValue();
    }

    public boolean gt(AnyType arg, DynamicContext context) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        return this.monthValue() > val.monthValue();
    }

    public ResultSequence plus(ResultSequence arg) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        int res = this.monthValue() + val.monthValue();
        return ResultSequenceFactory.create_new(new XSYearMonthDuration(res));
    }

    public ResultSequence minus(ResultSequence arg) throws DynamicError {
        XSYearMonthDuration val = (XSYearMonthDuration)NumericType.get_single_type(arg, XSYearMonthDuration.class);
        int res = this.monthValue() - val.monthValue();
        return ResultSequenceFactory.create_new(new XSYearMonthDuration(res));
    }

    public ResultSequence times(ResultSequence arg) throws DynamicError {
        XSDouble val;
        AnyType argValue;
        ResultSequence convertedRS = arg;
        if (arg.size() == 1 && (argValue = arg.first()) instanceof XSDecimal) {
            convertedRS = ResultSequenceFactory.create_new(new XSDouble(argValue.string_value()));
        }
        if ((val = (XSDouble)NumericType.get_single_type(convertedRS, XSDouble.class)).nan()) {
            throw DynamicError.nan();
        }
        if (val.infinite()) {
            throw DynamicError.overflowDateTime();
        }
        int res = (int)Math.round((double)this.monthValue() * val.double_value());
        return ResultSequenceFactory.create_new(new XSYearMonthDuration(res));
    }

    public ResultSequence div(ResultSequence arg) throws DynamicError {
        AnyType at;
        if (arg.size() != 1) {
            DynamicError.throw_type_error();
        }
        if ((at = arg.first()) instanceof XSDouble) {
            XSDouble dt = (XSDouble)at;
            int ret = 0;
            if (!dt.zero()) {
                ret = (int)Math.round((double)this.monthValue() / dt.double_value());
            }
            return ResultSequenceFactory.create_new(new XSYearMonthDuration(ret));
        }
        if (at instanceof XSDecimal) {
            XSDecimal dt = (XSDecimal)at;
            int ret = 0;
            if (!dt.zero()) {
                ret = (int)Math.round((double)this.monthValue() / dt.getValue().doubleValue());
            }
            return ResultSequenceFactory.create_new(new XSYearMonthDuration(ret));
        }
        if (at instanceof XSYearMonthDuration) {
            XSYearMonthDuration md = (XSYearMonthDuration)at;
            double res = (double)this.monthValue() / (double)md.monthValue();
            return ResultSequenceFactory.create_new(new XSDecimal(BigDecimal.valueOf(res)));
        }
        DynamicError.throw_type_error();
        return null;
    }
}

