/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.types;

import java.math.BigInteger;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.ResultSequence;
import org.eclipse.wst.xml.xpath2.processor.ResultSequenceFactory;
import org.eclipse.wst.xml.xpath2.processor.internal.types.AnyType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSNonPositiveInteger;

public class XSNegativeInteger
extends XSNonPositiveInteger {
    private static final String XS_NEGATIVE_INTEGER = "xs:negativeInteger";

    public XSNegativeInteger() {
        this(BigInteger.valueOf(-1L));
    }

    public XSNegativeInteger(BigInteger x) {
        super(x);
    }

    public String string_type() {
        return XS_NEGATIVE_INTEGER;
    }

    public String type_name() {
        return "negativeInteger";
    }

    public ResultSequence constructor(ResultSequence arg) throws DynamicError {
        ResultSequence rs = ResultSequenceFactory.create_new();
        if (arg.empty()) {
            return rs;
        }
        AnyType aat = arg.first();
        try {
            BigInteger bigInt = new BigInteger(aat.string_value());
            BigInteger max = BigInteger.valueOf(-1L);
            if (bigInt.compareTo(max) > 0) {
                throw DynamicError.cant_cast(null);
            }
            rs.add(new XSNegativeInteger(bigInt));
            return rs;
        }
        catch (NumberFormatException numberFormatException) {
            throw DynamicError.cant_cast(null);
        }
    }
}

