"use strict";
/*******************************************************************************
* Copyright (c) 2019 IBM Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v2.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v20.html
*
* Contributors:
*     IBM Corporation - initial API and implementation
*******************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Immutable authorization token for use in HTTP(S) requests and WebSocket
 * connections
 */
class FWAuthToken {
    constructor(accessToken, tokenType) {
        if (!accessToken || !tokenType) {
            throw new Error("Invalid parameters to FWAuthToken: " + accessToken + " " + tokenType);
        }
        this._accessToken = accessToken;
        this._tokenType = tokenType;
    }
    get accessToken() {
        return this._accessToken;
    }
    get tokenType() {
        return this._tokenType;
    }
}
exports.FWAuthToken = FWAuthToken;
