/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.filewatchers.core;

import java.nio.file.Path;
import org.eclipse.codewind.filewatchers.core.PathUtils;

public class WatchEventEntry {
    private final EventType eventType;
    private final Path path;
    private final String absolutePath;
    private final boolean directory;

    public WatchEventEntry(EventType eventType, Path path, boolean directory) {
        this.eventType = eventType;
        this.path = path;
        this.directory = directory;
        this.absolutePath = PathUtils.normalizePath(path.toFile().getPath());
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public String getAbsolutePathWithUnixSeparators() {
        return this.absolutePath;
    }

    public Path getLocalOSSpecificPath() {
        return this.path;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    public String toString() {
        return "[" + this.eventType.name() + "] " + this.absolutePath;
    }

    public static enum EventType {
        CREATE,
        MODIFY,
        DELETE;

    }
}

