/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.codewind.core.CodewindCorePlugin;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.FileUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.PlatformUtil;
import org.eclipse.codewind.core.internal.ProcessHelper;
import org.eclipse.codewind.core.internal.cli.CLIInfo;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;

public class CLIUtil {
    public static final String CODEWIND_STORE_DIR = ".codewind";
    public static final String JSON_OPTION = "--json";
    public static final String INSECURE_OPTION = "--insecure";
    public static final String[] GLOBAL_JSON = new String[]{"--json"};
    public static final String[] GLOBAL_INSECURE = new String[]{"--insecure"};
    public static final String[] GLOBAL_JSON_INSECURE = new String[]{"--json", "--insecure"};
    public static final String CON_ID_OPTION = "--conid";
    public static final String ERROR_KEY = "error";
    public static final String ERROR_DESCRIPTION_KEY = "error_description";
    private static final String STATUS_KEY = "status";
    private static final String STATUS_MSG_KEY = "status_message";
    private static final String STATUS_OK_VALUE = "OK";
    private static final String INSTALLER_DIR = "installerWorkDir";
    private static final Map<PlatformUtil.OperatingSystem, String> cwctlMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final Map<PlatformUtil.OperatingSystem, String> appsodyMap = new HashMap<PlatformUtil.OperatingSystem, String>();
    private static final CLIInfo codewindInfo;
    private static final CLIInfo appsodyInfo;
    private static final CLIInfo[] cliInfos;

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options) throws IOException {
        return CLIUtil.runCWCTL(globalOptions, cmd, options, null);
    }

    public static Process runCWCTL(String[] globalOptions, String[] cmd, String[] options, String[] args) throws IOException {
        for (int i = 0; i < cliInfos.length; ++i) {
            if (cliInfos[i] == null) continue;
            cliInfos[i].setInstallPath(CLIUtil.getCLIExecutable(cliInfos[i]));
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(codewindInfo.getInstallPath());
        CLIUtil.addOptions(cmdList, globalOptions);
        CLIUtil.addOptions(cmdList, cmd);
        CLIUtil.addOptions(cmdList, options);
        CLIUtil.addOptions(cmdList, args);
        String[] command = cmdList.toArray(new String[cmdList.size()]);
        ProcessBuilder builder = new ProcessBuilder(command);
        if (PlatformUtil.getOS() == PlatformUtil.OperatingSystem.MAC) {
            String pathVar = System.getenv("PATH");
            pathVar = "/usr/local/bin:" + pathVar;
            Map<String, String> env = builder.environment();
            env.put("PATH", pathVar);
        }
        return builder.start();
    }

    private static void addOptions(List<String> cmdList, String[] options) {
        if (options != null) {
            for (String opt : options) {
                cmdList.add(opt);
            }
        }
    }

    public static String getCWCTLExecutable() throws IOException {
        return CLIUtil.getCLIExecutable(codewindInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCLIExecutable(CLIInfo operation) throws IOException {
        String installPath = operation.getInstallPath();
        if (installPath != null && new File(installPath).exists()) {
            return installPath;
        }
        PlatformUtil.OperatingSystem os = PlatformUtil.getOS(System.getProperty("os.name"));
        Map<PlatformUtil.OperatingSystem, String> osPathMap = operation.getOSPathMap();
        if (osPathMap == null) {
            String msg = "Failed to get the list of operating specific paths for installing the executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String relPath = osPathMap.get((Object)os);
        if (relPath == null) {
            String msg = "Failed to get the relative path for the install executable " + operation.getInstallName();
            Logger.logError(msg);
            throw new IOException(msg);
        }
        String installerDir = CLIUtil.getCLIInstallDir();
        String execName = relPath.substring(relPath.lastIndexOf(47) + 1);
        String execPath = installerDir + File.separator + execName;
        if (!FileUtil.makeDir(installerDir)) {
            String msg = "Failed to make the directory for the installer utility: " + installerDir;
            Logger.logError(msg);
            throw new IOException(msg);
        }
        InputStream stream = null;
        try {
            stream = FileLocator.openStream((Bundle)CodewindCorePlugin.getDefault().getBundle(), (IPath)new Path(relPath), (boolean)false);
            FileUtil.copyFile(stream, execPath);
            if (PlatformUtil.getOS() != PlatformUtil.OperatingSystem.WINDOWS) {
                Set<PosixFilePermission> permissions = PosixFilePermissions.fromString("rwxr-xr-x");
                File file = new File(execPath);
                Files.setPosixFilePermissions(file.toPath(), permissions);
            }
            String string = execPath;
            return string;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static String getCLIInstallDir() {
        IPath userHome = CoreUtil.getUserHome();
        if (userHome != null) {
            return userHome.append(CODEWIND_STORE_DIR).append("0.8.0").toOSString();
        }
        IPath stateLoc = CodewindCorePlugin.getDefault().getStateLocation();
        return stateLoc.append(INSTALLER_DIR).toOSString();
    }

    public static void checkResult(String[] command, ProcessHelper.ProcessResult result, boolean checkOutput) throws IOException {
        CLIUtil.checkErrorResult(command, result);
        if (result.getExitValue() != 0) {
            String error = result.getError() != null && !result.getError().isEmpty() ? result.getError() : result.getOutput();
            String msg = error == null || error.isEmpty() ? String.format("The %s command exited with return code %d", Arrays.toString(command), result.getExitValue()) : String.format("The %s command exited with return code %d and error: %s", Arrays.toString(command), result.getExitValue(), error);
            Logger.logError(msg);
            throw new IOException(msg);
        }
        if (checkOutput && (result.getOutput() == null || result.getOutput().isEmpty())) {
            String msg = String.format("The %s command exited with return code 0 but the output was empty", Arrays.toString(command));
            Logger.logError(msg);
            throw new IOException(msg);
        }
    }

    private static void checkErrorResult(String[] command, ProcessHelper.ProcessResult result) throws IOException {
        try {
            if (result.getOutput() != null && !result.getOutput().isEmpty()) {
                JSONObject obj = new JSONObject(result.getOutput());
                if (obj.has(ERROR_KEY)) {
                    String msg = String.format("The %s command failed with error: %s", Arrays.toString(command), obj.getString(ERROR_DESCRIPTION_KEY));
                    Logger.logError(msg);
                    throw new IOException(msg);
                }
                if (obj.has(STATUS_KEY) && !STATUS_OK_VALUE.equals(obj.getString(STATUS_KEY))) {
                    String msg = String.format("The %s command failed with error: %s", Arrays.toString(command), obj.getString(STATUS_MSG_KEY));
                    Logger.logError(msg);
                    throw new IOException(msg);
                }
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    static {
        cwctlMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/cwctl");
        cwctlMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/cwctl.exe");
        appsodyMap.put(PlatformUtil.OperatingSystem.LINUX, "binaries/linux/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.MAC, "binaries/darwin/appsody");
        appsodyMap.put(PlatformUtil.OperatingSystem.WINDOWS, "binaries/windows/appsody.exe");
        codewindInfo = new CLIInfo("Codewind", cwctlMap);
        appsodyInfo = new CLIInfo("Appsody", appsodyMap);
        cliInfos = new CLIInfo[]{codewindInfo, appsodyInfo};
    }
}

