/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.codewind.core.internal.IDebugLauncher;
import org.eclipse.codewind.core.internal.IUpdateHandler;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.connection.CodewindConnectionManager;
import org.eclipse.codewind.core.internal.constants.ProjectLanguage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class CodewindCorePlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.codewind.core";
    public static final String FEATURE_VERSION = "0.7.0";
    public static final String DEFAULT_ICON_PATH = "icons/codewind.png";
    public static final String CW_INSTALL_TIMEOUT = "cwInstallTimeout";
    public static final String CW_START_TIMEOUT = "cwStartTimeout";
    public static final String CW_STOP_TIMEOUT = "cwStopTimeout";
    public static final String CW_UNINSTALL_TIMEOUT = "cwUninstallTimeout";
    public static final String AUTO_OPEN_OVERVIEW_PAGE = "autoOpenOverviewPage";
    public static final String DEBUG_CONNECT_TIMEOUT_PREFSKEY = "serverDebugTimeout";
    public static final String NODEJS_DEBUG_BROWSER_PREFSKEY = "nodejsDebugBrowserName";
    private static CodewindCorePlugin plugin;
    private static IUpdateHandler updateHandler;
    private static Map<ProjectLanguage, IDebugLauncher> debugLaunchers;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        context.registerService(DebugOptionsListener.class, (Object)Logger.instance(), null);
        this.getPreferenceStore().setDefault("stopAppContainers", "stopAppContainersPrompt");
        this.getPreferenceStore().setDefault(DEBUG_CONNECT_TIMEOUT_PREFSKEY, 3);
        this.getPreferenceStore().setDefault(CW_INSTALL_TIMEOUT, 300);
        this.getPreferenceStore().setDefault(CW_UNINSTALL_TIMEOUT, 60);
        this.getPreferenceStore().setDefault(CW_START_TIMEOUT, 60);
        this.getPreferenceStore().setDefault(CW_STOP_TIMEOUT, 300);
        this.getPreferenceStore().setDefault(AUTO_OPEN_OVERVIEW_PAGE, true);
    }

    public void stop(BundleContext context) throws Exception {
        CodewindConnectionManager.clear();
        plugin = null;
        super.stop(context);
    }

    public static CodewindCorePlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getIcon(String path) {
        URL url = CodewindCorePlugin.getDefault().getBundle().getEntry(DEFAULT_ICON_PATH);
        return ImageDescriptor.createFromURL((URL)url);
    }

    public static void setUpdateHandler(IUpdateHandler handler) {
        updateHandler = handler;
    }

    public static IUpdateHandler getUpdateHandler() {
        return updateHandler;
    }

    public static void addDebugLauncher(ProjectLanguage language, IDebugLauncher launcher) {
        debugLaunchers.put(language, launcher);
    }

    public static IDebugLauncher getDebugLauncher(ProjectLanguage language) {
        return debugLaunchers.get((Object)language);
    }

    static {
        debugLaunchers = new HashMap<ProjectLanguage, IDebugLauncher>();
    }
}

