/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cft.server.core.internal.client;

import org.eclipse.cft.server.core.internal.CFLoginHandler;
import org.eclipse.cft.server.core.internal.CloudErrorUtil;
import org.eclipse.cft.server.core.internal.CloudFoundryPlugin;
import org.eclipse.cft.server.core.internal.CloudFoundryServer;
import org.eclipse.cft.server.core.internal.Messages;
import org.eclipse.cft.server.core.internal.client.CFClient;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.internal.Server;

public abstract class CloudServerRequest<T> {
    protected final String requestLabel;
    private CloudFoundryServer cloudServer;
    private CFClient client;

    public CloudServerRequest(CloudFoundryServer cloudServer, CFClient client, String label) {
        Assert.isNotNull((Object)label);
        Assert.isNotNull((Object)((Object)cloudServer));
        Assert.isNotNull((Object)client);
        this.cloudServer = cloudServer;
        this.requestLabel = this.generateRequestLabel(label, cloudServer);
        this.client = client;
    }

    protected T runRequestWithReattempts(CFClient client, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        Throwable error = null;
        boolean reattempt = true;
        long timeLeft = this.getRetryTimeout();
        while (reattempt) {
            long interval = -1L;
            try {
                return this.runRequest(client, monitor);
            }
            catch (Throwable e) {
                error = e;
                interval = this.getRetryInterval(error, monitor);
                boolean bl = reattempt = !monitor.isCanceled() && (timeLeft -= interval) >= 0L && interval > 0L;
                if (!reattempt) continue;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException(Messages.bind((String)Messages.OPERATION_CANCELED, (Object)this.requestLabel));
        }
        if (error instanceof OperationCanceledException) {
            throw (OperationCanceledException)error;
        }
        throw this.getErrorOnLastFailedAttempt(error);
    }

    protected CloudFoundryServer getCloudServer() {
        return this.cloudServer;
    }

    public T run(IProgressMonitor monitor) throws CoreException {
        SubMonitor subProgress = SubMonitor.convert((IProgressMonitor)monitor);
        subProgress.subTask(this.requestLabel);
        try {
            T t = this.promptCredentialsAndRun((IProgressMonitor)subProgress);
            return t;
        }
        catch (CoreException ce) {
            String connectionError = CloudErrorUtil.getConnectionError(ce);
            if (connectionError != null) {
                throw CloudErrorUtil.asCoreException(connectionError, ce, true);
            }
            throw ce;
        }
        finally {
            subProgress.done();
        }
    }

    protected T checkClientConnectionAndRun(CFClient client, IProgressMonitor monitor) throws CoreException {
        try {
            return this.runRequestWithReattempts(client, monitor);
        }
        catch (CoreException ce) {
            CloudFoundryServer server = this.getCloudServer();
            if (server != null) {
                CFLoginHandler handler = new CFLoginHandler(client, server);
                CoreException accessError = null;
                String accessErrorMessage = null;
                if (handler.shouldAttemptClientLogin(ce)) {
                    CloudFoundryPlugin.logWarning(NLS.bind((String)Messages.ClientRequest_RETRY_REQUEST, (Object)this.requestLabel));
                    accessError = ce;
                    int attempts = 3;
                    String token = handler.login(monitor, attempts, 2000L);
                    if (token == null) {
                        accessErrorMessage = Messages.ClientRequest_NO_TOKEN;
                    } else {
                        try {
                            return this.runRequestWithReattempts(client, monitor);
                        }
                        catch (CoreException e) {
                            accessError = e;
                        }
                    }
                }
                if (accessError != null) {
                    Throwable cause;
                    Throwable throwable = cause = accessError.getCause() != null ? accessError.getCause() : accessError;
                    if (accessErrorMessage == null) {
                        accessErrorMessage = accessError.getMessage();
                    }
                    accessErrorMessage = NLS.bind((String)Messages.ClientRequest_SECOND_ATTEMPT_FAILED, (Object)this.requestLabel, (Object)accessErrorMessage);
                    throw CloudErrorUtil.toCoreException(accessErrorMessage, cause);
                }
            }
            throw ce;
        }
    }

    protected long getRetryInterval(Throwable exception, IProgressMonitor monitor) throws CoreException {
        return -1L;
    }

    protected long getRetryTimeout() {
        return 15000L;
    }

    public T promptCredentialsAndRun(IProgressMonitor monitor) throws CoreException {
        Server server;
        CloudFoundryServer cloudServer = this.getCloudServer();
        if (!cloudServer.isSso()) {
            if (cloudServer.getUsername() == null || cloudServer.getUsername().length() == 0 || cloudServer.getPassword() == null || cloudServer.getPassword().length() == 0) {
                CloudFoundryPlugin.getCallback().getCredentials(cloudServer);
            }
        } else if (cloudServer.getToken() == null) {
            CloudFoundryPlugin.getCallback().ssoLoginUserPrompt(cloudServer);
        }
        if ((server = (Server)cloudServer.getServer()).getServerState() == 4 || server.getServerState() == 3) {
            server.setServerState(1);
        }
        try {
            CFClient client = this.getClient(monitor);
            if (client == null) {
                throw CloudErrorUtil.toCoreException(NLS.bind((String)Messages.ERROR_NO_CLIENT, (Object)this.requestLabel));
            }
            this.httpTrace(client);
            T result = this.checkClientConnectionAndRun(client, monitor);
            if (server.getServerState() != 2) {
                server.setServerState(2);
            }
            return result;
        }
        catch (CoreException ce) {
            if (CloudErrorUtil.isConnectionError(ce) && server.getServerState() == 1) {
                server.setServerState(4);
            }
            throw ce;
        }
    }

    private void httpTrace(CFClient client) {
    }

    protected CFClient getClient(IProgressMonitor monitor) throws CoreException {
        return this.client;
    }

    protected String generateRequestLabel(String originalLabel, CloudFoundryServer cloudServer) {
        String requestLabel = originalLabel;
        String serverName = null;
        try {
            if (cloudServer != null && cloudServer.getServer() != null) {
                serverName = NLS.bind((String)Messages.LocalServerRequest_SERVER_LABEL, (Object)cloudServer.getServer().getId());
            }
        }
        catch (Throwable throwable) {}
        if (serverName != null) {
            requestLabel = String.valueOf(originalLabel) + " - " + serverName;
        }
        return requestLabel;
    }

    protected CoreException getErrorOnLastFailedAttempt(Throwable error) {
        if (error instanceof CoreException) {
            return (CoreException)error;
        }
        return CloudErrorUtil.toCoreException(error);
    }

    protected abstract T runRequest(CFClient var1, IProgressMonitor var2) throws CoreException;
}

