/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layout;

import java.util.AbstractList;
import java.util.Iterator;
import org.apache.fop.layout.AreaContainer;
import org.apache.fop.layout.ColumnArea;
import org.apache.fop.layout.FontState;
import org.apache.fop.layout.Page;
import org.apache.fop.render.Renderer;

public class SpanArea
extends AreaContainer {
    private int columnCount;
    private int currentColumn = 1;
    private int columnGap = 0;
    private boolean isBalanced = false;

    public SpanArea(FontState fontState, int xPosition, int yPosition, int allocationWidth, int maxHeight, int columnCount, int columnGap) {
        super(fontState, xPosition, yPosition, allocationWidth, maxHeight, 1);
        this.contentRectangleWidth = allocationWidth;
        this.columnCount = columnCount;
        this.columnGap = columnGap;
        int columnWidth = (allocationWidth - columnGap * (columnCount - 1)) / columnCount;
        int columnIndex = 0;
        while (columnIndex < columnCount) {
            int colXPosition = xPosition + columnIndex * (columnWidth + columnGap);
            int colYPosition = yPosition;
            ColumnArea colArea = new ColumnArea(fontState, colXPosition, colYPosition, columnWidth, maxHeight, columnCount);
            this.addChild(colArea);
            colArea.setColumnIndex(columnIndex + 1);
            ++columnIndex;
        }
    }

    public void end() {
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public int getCurrentColumn() {
        return this.currentColumn;
    }

    public AreaContainer getCurrentColumnArea() {
        return (AreaContainer)this.getChildren().get(this.currentColumn - 1);
    }

    public int getMaxContentHeight() {
        int maxContentHeight = 0;
        Iterator e = ((AbstractList)this.getChildren()).iterator();
        while (e.hasNext()) {
            AreaContainer nextElm = (AreaContainer)e.next();
            if (nextElm.getContentHeight() <= maxContentHeight) continue;
            maxContentHeight = nextElm.getContentHeight();
        }
        return maxContentHeight;
    }

    public int getTotalContentHeight() {
        int totalContentHeight = 0;
        Iterator e = ((AbstractList)this.getChildren()).iterator();
        while (e.hasNext()) {
            totalContentHeight += ((AreaContainer)e.next()).getContentHeight();
        }
        return totalContentHeight;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public boolean isLastColumn() {
        return this.currentColumn == this.columnCount;
    }

    public void render(Renderer renderer) {
        renderer.renderSpanArea(this);
    }

    public void setCurrentColumn(int currentColumn) {
        this.currentColumn = currentColumn <= this.columnCount ? currentColumn : this.columnCount;
    }

    public void setIsBalanced() {
        this.isBalanced = true;
    }

    public void setPage(Page page) {
        this.page = page;
        Iterator e = ((AbstractList)this.getChildren()).iterator();
        while (e.hasNext()) {
            ((AreaContainer)e.next()).setPage(page);
        }
    }

    public int spaceLeft() {
        return this.maxHeight - this.currentHeight;
    }

    public void start() {
    }
}

