/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.net.URL;
import java.util.Map;
import org.apache.tapestry5.Asset;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.internal.services.UrlAsset;
import org.apache.tapestry5.internal.services.UrlResource;
import org.apache.tapestry5.services.AssetFactory;

public class ExternalUrlAssetFactory
implements AssetFactory {
    private final String protocol;
    private final UrlResource rootResource;
    private final Map<URL, Asset> cache = CollectionFactory.newMap();

    public ExternalUrlAssetFactory(String protocol) {
        this.protocol = protocol;
        if (protocol.equals("//")) {
            protocol = "http";
        }
        this.rootResource = new UrlResource();
    }

    @Override
    public Resource getRootResource() {
        return this.rootResource;
    }

    @Override
    public Asset createAsset(Resource resource) {
        URL url = resource.toURL();
        Asset asset = this.cache.get(url);
        if (asset == null) {
            asset = new UrlAsset(url.toExternalForm(), resource);
            this.cache.put(url, asset);
        }
        return asset;
    }
}

