/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.annotations.PreventServiceDecoration;
import org.apache.tapestry5.ioc.services.AspectDecorator;
import org.apache.tapestry5.ioc.services.AspectInterceptorBuilder;
import org.apache.tapestry5.ioc.services.LoggingAdvisor;
import org.apache.tapestry5.ioc.services.LoggingDecorator;
import org.slf4j.Logger;

@PreventServiceDecoration
public class LoggingDecoratorImpl
implements LoggingDecorator {
    private final AspectDecorator aspectDecorator;
    private final LoggingAdvisor advisor;

    public LoggingDecoratorImpl(AspectDecorator aspectDecorator, LoggingAdvisor advisor) {
        this.aspectDecorator = aspectDecorator;
        this.advisor = advisor;
    }

    @Override
    public <T> T build(Class<T> serviceInterface, T delegate, String serviceId, Logger logger) {
        AspectInterceptorBuilder<T> builder = this.aspectDecorator.createBuilder(serviceInterface, delegate, String.format("<Logging interceptor for %s(%s)>", serviceId, serviceInterface.getName()));
        this.advisor.addLoggingAdvice(logger, builder);
        return builder.build();
    }
}

