/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.apache.tapestry5.commons.Messages;
import org.apache.tapestry5.internal.services.assets.ResourceChangeTracker;
import org.apache.tapestry5.internal.util.VirtualResource;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.messages.ComponentMessagesSource;

public class MessageCatalogResource
extends VirtualResource {
    private final Locale locale;
    private final ComponentMessagesSource messagesSource;
    private final boolean compactJSON;
    private volatile byte[] bytes;

    public MessageCatalogResource(Locale locale, ComponentMessagesSource messagesSource, ResourceChangeTracker changeTracker, boolean compactJSON) {
        this.locale = locale;
        this.messagesSource = messagesSource;
        this.compactJSON = compactJSON;
        messagesSource.getInvalidationEventHub().addInvalidationCallback(new Runnable(){

            @Override
            public void run() {
                MessageCatalogResource.access$002(MessageCatalogResource.this, null);
            }
        });
    }

    public String toString() {
        return String.format("MessageCatalogResource[%s]", this.locale);
    }

    @Override
    public String getFile() {
        return String.format("virtual-%s.js", this.locale);
    }

    @Override
    public URL toURL() {
        return null;
    }

    public InputStream openStream() throws IOException {
        return this.toInputStream(this.getBytes());
    }

    private byte[] getBytes() throws IOException {
        if (this.bytes == null) {
            this.bytes = this.assembleCatalog().getBytes(UTF8);
        }
        return this.bytes;
    }

    private String assembleCatalog() {
        Messages messages = this.messagesSource.getApplicationCatalog(this.locale);
        JSONObject catalog = new JSONObject();
        for (String key : messages.getKeys()) {
            String value;
            if (key.startsWith("private-") || (value = messages.get(key)).contains("%")) continue;
            catalog.put(key, (Object)value);
        }
        StringBuilder builder = new StringBuilder(2000);
        builder.append("define(").append(catalog.toString(this.compactJSON)).append(");");
        return builder.toString();
    }

    static /* synthetic */ byte[] access$002(MessageCatalogResource x0, byte[] x1) {
        x0.bytes = x1;
        return x1;
    }
}

