/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.beanmodel.services.PlasticProxyFactoryImpl;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.ObjectCreator;
import org.apache.tapestry5.commons.Resource;
import org.apache.tapestry5.commons.services.PlasticProxyFactory;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.commons.util.ExceptionUtils;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.model.MutableComponentModelImpl;
import org.apache.tapestry5.internal.plastic.PlasticInternalUtils;
import org.apache.tapestry5.internal.services.ClassNameHolder;
import org.apache.tapestry5.internal.services.ComponentDependencyRegistry;
import org.apache.tapestry5.internal.services.ComponentInstantiatorSource;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.services.InternalComponentInvalidationEventHub;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.LoggerSource;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.annotations.PostInjection;
import org.apache.tapestry5.ioc.annotations.Primary;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.ClasspathResource;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.URLChangeTracker;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.ClasspathURLConverter;
import org.apache.tapestry5.ioc.services.UpdateListener;
import org.apache.tapestry5.ioc.services.UpdateListenerHub;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.ConstructorCallback;
import org.apache.tapestry5.plastic.InstanceContext;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodAdvice;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.MethodInvocation;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassEvent;
import org.apache.tapestry5.plastic.PlasticClassListener;
import org.apache.tapestry5.plastic.PlasticClassTransformation;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticManager;
import org.apache.tapestry5.plastic.PlasticManagerDelegate;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.apache.tapestry5.plastic.PlasticUtils;
import org.apache.tapestry5.plastic.TransformationOption;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.runtime.ComponentResourcesAware;
import org.apache.tapestry5.runtime.PageLifecycleListener;
import org.apache.tapestry5.services.ComponentClassResolver;
import org.apache.tapestry5.services.ComponentEventHandler;
import org.apache.tapestry5.services.TransformConstants;
import org.apache.tapestry5.services.pageload.PageClassLoaderContext;
import org.apache.tapestry5.services.pageload.PageClassLoaderContextManager;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.ControlledPackageType;
import org.apache.tapestry5.services.transform.TransformationSupport;
import org.slf4j.Logger;

public final class ComponentInstantiatorSourceImpl
implements ComponentInstantiatorSource,
UpdateListener,
Runnable,
PlasticManagerDelegate,
PlasticClassListener {
    private final Set<String> controlledPackageNames = CollectionFactory.newSet();
    private final URLChangeTracker<ClassName> changeTracker;
    private final ClassLoader parent;
    private final ComponentClassTransformWorker2 transformerChain;
    private final LoggerSource loggerSource;
    private final Logger logger;
    private final OperationTracker tracker;
    private final InternalComponentInvalidationEventHub invalidationHub;
    private final boolean productionMode;
    private final boolean multipleClassLoaders;
    private final ComponentClassResolver resolver;
    private final PageClassLoaderContextManager pageClassLoaderContextManager;
    private PageClassLoaderContext rootPageClassloaderContext;
    private PlasticProxyFactoryProxy plasticProxyFactoryProxy;
    private ComponentDependencyRegistry componentDependencyRegistry;
    private static final ThreadLocal<String> CURRENT_PAGE = ThreadLocal.withInitial(() -> null);
    private final Map<String, Instantiator> classToInstantiator = CollectionFactory.newConcurrentMap();
    private final Map<String, ComponentModel> classToModel = CollectionFactory.newMap();
    private final MethodDescription GET_COMPONENT_RESOURCES = PlasticUtils.getMethodDescription(ComponentResourcesAware.class, (String)"getComponentResources", (Class[])new Class[0]);
    private final ConstructorCallback REGISTER_AS_PAGE_LIFECYCLE_LISTENER = new ConstructorCallback(){

        public void onConstruct(Object instance, InstanceContext context) {
            InternalComponentResources resources = (InternalComponentResources)context.get(InternalComponentResources.class);
            resources.addPageLifecycleListener((PageLifecycleListener)instance);
        }
    };
    private static final ThreadLocal<Set<String>> OPEN_INSTANTIATORS = ThreadLocal.withInitial(HashSet::new);

    public ComponentInstantiatorSourceImpl(Logger logger, LoggerSource loggerSource, @Builtin PlasticProxyFactory proxyFactory, @Primary ComponentClassTransformWorker2 transformerChain, ClasspathURLConverter classpathURLConverter, OperationTracker tracker, Map<String, ControlledPackageType> configuration, @Symbol(value="tapestry.production-mode") boolean productionMode, @Symbol(value="tapestry.multiple-classloaders") boolean multipleClassLoaders, ComponentClassResolver resolver, InternalComponentInvalidationEventHub invalidationHub, PageClassLoaderContextManager pageClassLoaderContextManager, ComponentDependencyRegistry componentDependencyRegistry) {
        this.parent = proxyFactory.getClassLoader();
        this.transformerChain = transformerChain;
        this.logger = logger;
        this.loggerSource = loggerSource;
        this.changeTracker = new URLChangeTracker(classpathURLConverter);
        this.tracker = tracker;
        this.invalidationHub = invalidationHub;
        this.productionMode = productionMode;
        this.multipleClassLoaders = multipleClassLoaders;
        this.resolver = resolver;
        this.pageClassLoaderContextManager = pageClassLoaderContextManager;
        this.componentDependencyRegistry = componentDependencyRegistry;
        this.controlledPackageNames.addAll(configuration.keySet());
        this.initializeService();
        pageClassLoaderContextManager.initialize(this.rootPageClassloaderContext, this::createPlasticProxyFactory);
    }

    @PostInjection
    public void listenForUpdates(UpdateListenerHub hub) {
        this.invalidationHub.addInvalidationCallback(this::invalidate);
        hub.addUpdateListener((UpdateListener)this);
    }

    public synchronized void checkForUpdates() {
        Set changedResources = this.changeTracker.getChangedResourcesInfo();
        if (!changedResources.isEmpty()) {
            List<String> classNames = changedResources.stream().map(ClassName::getClassName).collect(Collectors.toList());
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Component class(es) changed: {}", (Object)String.join((CharSequence)", ", classNames));
            }
            if (this.multipleClassLoaders) {
                HashSet<String> classesToInvalidate = new HashSet<String>();
                for (String className : classNames) {
                    PageClassLoaderContext context = this.rootPageClassloaderContext.findByClassName(className);
                    if (context == this.rootPageClassloaderContext || context == null) continue;
                    classesToInvalidate.addAll(this.pageClassLoaderContextManager.invalidate(context));
                }
                classNames.clear();
                classNames.addAll(classesToInvalidate);
                this.invalidate(classNames);
                this.invalidationHub.fireInvalidationEvent(classNames);
            } else {
                this.invalidationHub.classInControlledPackageHasChanged();
            }
        }
    }

    private List<String> invalidate(List<String> classNames) {
        if (classNames.isEmpty()) {
            this.clearCaches();
        } else {
            String currentPage = CURRENT_PAGE.get();
            Iterator<Map.Entry<String, Instantiator>> classToInstantiatorIterator = this.classToInstantiator.entrySet().iterator();
            while (classToInstantiatorIterator.hasNext()) {
                String className = classToInstantiatorIterator.next().getKey();
                if (className.equals(currentPage) || !classNames.contains(className)) continue;
                classToInstantiatorIterator.remove();
            }
            Iterator<Map.Entry<String, ComponentModel>> classToModelIterator = this.classToModel.entrySet().iterator();
            while (classToModelIterator.hasNext()) {
                String className = classToModelIterator.next().getKey();
                if (className.equals(currentPage) || !classNames.contains(className)) continue;
                classToModelIterator.remove();
            }
        }
        return Collections.emptyList();
    }

    @Override
    public void forceComponentInvalidation() {
        this.clearCaches();
        this.invalidationHub.classInControlledPackageHasChanged();
    }

    private void clearCaches() {
        this.classToInstantiator.clear();
        this.pageClassLoaderContextManager.clear();
    }

    @Override
    public void run() {
        this.changeTracker.clear();
        this.classToInstantiator.clear();
        this.classToModel.clear();
        this.pageClassLoaderContextManager.clear();
        this.initializeService();
    }

    private void initializeService() {
        this.pageClassLoaderContextManager.clear();
        if (this.rootPageClassloaderContext == null) {
            this.logger.info("Initializing page pool. Production mode " + (this.productionMode ? "enabled" : "disabled") + ". Multiple classloaders " + (!this.productionMode && this.multipleClassLoaders ? "enabled" : "disabled") + ".");
            this.pageClassLoaderContextManager.clear();
            PlasticProxyFactory proxyFactory = this.createPlasticProxyFactory(this.parent);
            this.rootPageClassloaderContext = new PageClassLoaderContext("root", null, Collections.emptySet(), proxyFactory, this.pageClassLoaderContextManager::get);
        } else {
            this.logger.info("Restarting page pool");
        }
        this.classToInstantiator.clear();
        this.classToModel.clear();
    }

    private PlasticProxyFactory createPlasticProxyFactory(ClassLoader parentClassloader) {
        PlasticManager.PlasticManagerBuilder builder = PlasticManager.withClassLoader((ClassLoader)parentClassloader).delegate((PlasticManagerDelegate)this).packages(this.controlledPackageNames);
        if (!this.productionMode) {
            builder.enable(TransformationOption.FIELD_WRITEBEHIND);
        }
        PlasticManager plasticManager = builder.create();
        plasticManager.addPlasticClassListener((PlasticClassListener)this);
        PlasticProxyFactoryImpl proxyFactory = new PlasticProxyFactoryImpl(plasticManager, this.logger);
        return proxyFactory;
    }

    @Override
    public Instantiator getInstantiator(String className) {
        return this.classToInstantiator.computeIfAbsent(className, this::createInstantiatorForClass);
    }

    private Instantiator createInstantiatorForClass(final String className) {
        return (Instantiator)this.tracker.invoke(String.format("Creating instantiator for component class %s", className), (Invokable)new Invokable<Instantiator>(){

            public Instantiator invoke() {
                PageClassLoaderContext context;
                ((Set)OPEN_INSTANTIATORS.get()).add(className);
                ComponentInstantiatorSourceImpl.this.componentDependencyRegistry.disableInvalidations();
                try {
                    context = ComponentInstantiatorSourceImpl.this.pageClassLoaderContextManager.get(className);
                }
                finally {
                    ComponentInstantiatorSourceImpl.this.componentDependencyRegistry.enableInvalidations();
                }
                Set<String> dependencies = ComponentInstantiatorSourceImpl.this.componentDependencyRegistry.getDependencies(className, ComponentDependencyRegistry.DependencyType.USAGE);
                for (String dependency : dependencies) {
                    if (((Set)OPEN_INSTANTIATORS.get()).contains(dependency)) continue;
                    ComponentInstantiatorSourceImpl.this.createInstantiatorForClass(dependency);
                }
                final ClassInstantiator plasticInstantiator = context.getPlasticManager().getClassInstantiator(className);
                final ComponentModel model = (ComponentModel)ComponentInstantiatorSourceImpl.this.classToModel.get(className);
                ((Set)OPEN_INSTANTIATORS.get()).remove(className);
                return new Instantiator(){

                    @Override
                    public Component newInstance(InternalComponentResources resources) {
                        return (Component)plasticInstantiator.with(ComponentResources.class, (Object)resources).with(InternalComponentResources.class, (Object)resources).newInstance();
                    }

                    @Override
                    public ComponentModel getModel() {
                        return model;
                    }

                    public String toString() {
                        return String.format("[Instantiator[%s:%s]", className, context);
                    }
                };
            }
        });
    }

    @Override
    public boolean exists(String className) {
        return this.parent.getResource(PlasticInternalUtils.toClassPath((String)className)) != null;
    }

    @Override
    public PlasticProxyFactory getProxyFactory() {
        if (this.plasticProxyFactoryProxy == null) {
            this.plasticProxyFactoryProxy = new PlasticProxyFactoryProxy();
        }
        return this.plasticProxyFactoryProxy;
    }

    public void transform(final PlasticClass plasticClass) {
        this.tracker.run(String.format("Running component class transformations on %s", plasticClass.getClassName()), new Runnable(){

            @Override
            public void run() {
                boolean isRoot;
                String className = plasticClass.getClassName();
                String parentClassName = plasticClass.getSuperClassName();
                ComponentModel parentModel = (ComponentModel)ComponentInstantiatorSourceImpl.this.classToModel.get(parentClassName);
                boolean bl = isRoot = parentModel == null;
                if (isRoot && !parentClassName.equals("java.lang.Object") && !parentClassName.equals("groovy.lang.GroovyObjectSupport")) {
                    String suggestedPackageName = ComponentInstantiatorSourceImpl.this.buildSuggestedPackageName(className);
                    throw new RuntimeException(String.format("Base class %s (super class of %s) is not in a controlled package and is therefore not valid. You should try moving the class to package %s.", parentClassName, className, suggestedPackageName));
                }
                Logger logger = ComponentInstantiatorSourceImpl.this.loggerSource.getLogger(className);
                ClasspathResource baseResource = new ClasspathResource(ComponentInstantiatorSourceImpl.this.parent, PlasticInternalUtils.toClassPath((String)className));
                ComponentInstantiatorSourceImpl.this.changeTracker.add(baseResource.toURL(), (Object)new ClassName(className));
                if (isRoot) {
                    ComponentInstantiatorSourceImpl.this.implementComponentInterface(plasticClass);
                }
                boolean isPage = ComponentInstantiatorSourceImpl.this.resolver.isPage(className);
                boolean superClassImplementsPageLifecycle = plasticClass.isInterfaceImplemented(PageLifecycleListener.class);
                String libraryName = ComponentInstantiatorSourceImpl.this.resolver.getLibraryNameForClass(className);
                MutableComponentModelImpl model = new MutableComponentModelImpl(className, logger, (Resource)baseResource, parentModel, isPage, libraryName);
                TransformationSupportImpl transformationSupport = new TransformationSupportImpl(plasticClass, isRoot, model);
                ComponentInstantiatorSourceImpl.this.transformerChain.transform(plasticClass, transformationSupport, model);
                transformationSupport.commit();
                if (!superClassImplementsPageLifecycle && plasticClass.isInterfaceImplemented(PageLifecycleListener.class)) {
                    plasticClass.onConstruct(ComponentInstantiatorSourceImpl.this.REGISTER_AS_PAGE_LIFECYCLE_LISTENER);
                }
                ComponentInstantiatorSourceImpl.this.classToModel.put(className, model);
            }
        });
    }

    private void implementComponentInterface(PlasticClass plasticClass) {
        plasticClass.introduceInterface(Component.class);
        final PlasticField resourcesField = plasticClass.introduceField(InternalComponentResources.class, "internalComponentResources").injectFromInstanceContext();
        plasticClass.introduceMethod(this.GET_COMPONENT_RESOURCES, new InstructionBuilderCallback(){

            public void doBuild(InstructionBuilder builder) {
                builder.loadThis().getField(resourcesField).returnResult();
            }
        });
    }

    public <T> ClassInstantiator<T> configureInstantiator(String className, ClassInstantiator<T> instantiator) {
        return instantiator;
    }

    private String buildSuggestedPackageName(String className) {
        for (String subpackage : InternalConstants.SUBPACKAGES) {
            String term = "." + subpackage + ".";
            int pos = className.indexOf(term);
            if (pos <= 0) continue;
            return className.substring(0, pos + 1) + "base";
        }
        return null;
    }

    public void classWillLoad(PlasticClassEvent event) {
        Logger logger = this.loggerSource.getLogger("tapestry.transformer." + event.getPrimaryClassName());
        if (logger.isDebugEnabled()) {
            logger.debug(event.getDissasembledBytecode());
        }
    }

    private class PlasticProxyFactoryProxy
    implements PlasticProxyFactory {
        private PlasticProxyFactoryProxy() {
        }

        public void addPlasticClassListener(PlasticClassListener listener) {
            throw new UnsupportedOperationException();
        }

        public void removePlasticClassListener(PlasticClassListener listener) {
            throw new UnsupportedOperationException();
        }

        public ClassLoader getClassLoader() {
            return ComponentInstantiatorSourceImpl.this.rootPageClassloaderContext.getProxyFactory().getClassLoader();
        }

        public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, PlasticClassTransformer callback) {
            return this.getProxyFactory(interfaceType.getName()).createProxy(interfaceType, callback);
        }

        public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback, boolean introduceInterface) {
            throw new UnsupportedOperationException();
        }

        public <T> ClassInstantiator<T> createProxy(Class<T> interfaceType, Class<? extends T> implementationType, PlasticClassTransformer callback) {
            throw new UnsupportedOperationException();
        }

        public <T> PlasticClassTransformation<T> createProxyTransformation(Class<T> interfaceType) {
            throw new UnsupportedOperationException();
        }

        public <T> PlasticClassTransformation<T> createProxyTransformation(Class<T> interfaceType, Class<? extends T> implementationType) {
            throw new UnsupportedOperationException();
        }

        public <T> T createProxy(Class<T> interfaceType, ObjectCreator<T> creator, String description) {
            throw new UnsupportedOperationException();
        }

        public <T> T createProxy(Class<T> interfaceType, Class<? extends T> implementationType, ObjectCreator<T> creator, String description) {
            throw new UnsupportedOperationException();
        }

        public Location getMethodLocation(Method method) {
            return this.getProxyFactory(method.getDeclaringClass().getName()).getMethodLocation(method);
        }

        public Location getConstructorLocation(Constructor constructor) {
            return this.getProxyFactory(constructor.getDeclaringClass().getName()).getConstructorLocation(constructor);
        }

        public void clearCache() {
            throw new UnsupportedOperationException();
        }

        public PlasticManager getPlasticManager() {
            return ComponentInstantiatorSourceImpl.this.rootPageClassloaderContext.getProxyFactory().getPlasticManager();
        }

        public PlasticProxyFactory getProxyFactory(String className) {
            PageClassLoaderContext context = ComponentInstantiatorSourceImpl.this.rootPageClassloaderContext.findByClassName(className);
            if (context == null) {
                context = ComponentInstantiatorSourceImpl.this.pageClassLoaderContextManager.get(className);
            }
            return context.getProxyFactory();
        }
    }

    private static class ClassName
    implements ClassNameHolder {
        private String className;

        public ClassName(String className) {
            this.className = className;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        public int hashCode() {
            return Objects.hash(this.className);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ClassName)) {
                return false;
            }
            ClassName other = (ClassName)obj;
            return Objects.equals(this.className, other.className);
        }

        public String toString() {
            return this.className;
        }
    }

    private static class EventMethodAdvice
    implements MethodAdvice {
        final OperationTracker tracker;
        final String eventType;
        final int minContextValues;
        final String operationDescription;
        final ComponentEventHandler handler;

        public EventMethodAdvice(OperationTracker tracker, String eventType, int minContextValues, String operationDescription, ComponentEventHandler handler) {
            this.tracker = tracker;
            this.eventType = eventType;
            this.minContextValues = minContextValues;
            this.operationDescription = operationDescription;
            this.handler = handler;
        }

        public void advise(final MethodInvocation invocation) {
            boolean matches;
            final ComponentEvent event = (ComponentEvent)invocation.getParameter(0);
            boolean bl = matches = !event.isAborted() && event.matches(this.eventType, "", this.minContextValues);
            if (matches) {
                this.tracker.run(this.operationDescription, new Runnable(){

                    @Override
                    public void run() {
                        Component instance = (Component)invocation.getInstance();
                        handler.handleEvent(instance, event);
                    }
                });
            }
            invocation.proceed();
            if (matches) {
                invocation.setReturnValue((Object)true);
            }
        }
    }

    private class TransformationSupportImpl
    implements TransformationSupport {
        private final PlasticClass plasticClass;
        private final boolean root;
        private final MutableComponentModel model;
        private final List<MethodAdvice> eventHandlerAdvice = CollectionFactory.newList();

        public TransformationSupportImpl(PlasticClass plasticClass, boolean root, MutableComponentModel model) {
            this.plasticClass = plasticClass;
            this.root = root;
            this.model = model;
        }

        public void commit() {
            if (!this.eventHandlerAdvice.isEmpty()) {
                PlasticMethod dispatchMethod = this.plasticClass.introduceMethod(TransformConstants.DISPATCH_COMPONENT_EVENT_DESCRIPTION);
                for (MethodAdvice advice : this.eventHandlerAdvice) {
                    dispatchMethod.addAdvice(advice);
                }
            }
        }

        @Override
        public Class toClass(String typeName) {
            try {
                PageClassLoaderContext context = ComponentInstantiatorSourceImpl.this.pageClassLoaderContextManager.get(typeName);
                return PlasticInternalUtils.toClass((ClassLoader)context.getPlasticManager().getClassLoader(), (String)typeName);
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(String.format("Unable to convert type '%s' to a Class: %s", typeName, ExceptionUtils.toMessage((Throwable)ex)), ex);
            }
        }

        @Override
        public boolean isRootTransformation() {
            return this.root;
        }

        @Override
        public void addEventHandler(String eventType, int minContextValues, String operationDescription, ComponentEventHandler handler) {
            assert (InternalUtils.isNonBlank((String)eventType));
            assert (minContextValues >= 0);
            assert (handler != null);
            this.model.addEventHandler(eventType);
            EventMethodAdvice advice = new EventMethodAdvice(ComponentInstantiatorSourceImpl.this.tracker, eventType, minContextValues, operationDescription, handler);
            this.eventHandlerAdvice.add(advice);
        }
    }
}

