/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.bindings;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.tapestry5.beanmodel.PropertyConduit;
import org.apache.tapestry5.beanmodel.PropertyConduit2;
import org.apache.tapestry5.beanmodel.internal.services.Invariant;
import org.apache.tapestry5.commons.Location;
import org.apache.tapestry5.commons.internal.util.TapestryException;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.internal.bindings.AbstractBinding;
import org.apache.tapestry5.internal.bindings.InternalPropBinding;

public class PropBinding
extends AbstractBinding
implements InternalPropBinding {
    private final Object root;
    private final PropertyConduit conduit;
    private final String toString;
    private boolean invariant;
    private final String expression;

    public PropBinding(Location location, Object root, PropertyConduit conduit, String expression, String toString) {
        super(location);
        this.root = root;
        this.conduit = conduit;
        this.expression = expression.intern();
        this.toString = toString;
        this.invariant = conduit.getAnnotation(Invariant.class) != null;
    }

    @Override
    public Object get() {
        try {
            return this.conduit.get(this.root);
        }
        catch (Exception ex) {
            throw new TapestryException(ex.getMessage(), this.getLocation(), (Throwable)ex);
        }
    }

    @Override
    public void set(Object value) {
        try {
            this.conduit.set(this.root, value);
        }
        catch (Exception ex) {
            throw new TapestryException(ex.getMessage(), this.getLocation(), (Throwable)ex);
        }
    }

    public String toString() {
        return this.toString;
    }

    @Override
    public boolean isInvariant() {
        return this.invariant;
    }

    @Override
    public Class getBindingType() {
        return this.conduit.getPropertyType();
    }

    @Override
    public Type getBindingGenericType() {
        if (this.conduit instanceof PropertyConduit2) {
            return ((PropertyConduit2)this.conduit).getPropertyGenericType();
        }
        return this.conduit.getPropertyType();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.conduit.getAnnotation(annotationClass);
    }

    @Override
    public String getPropertyName() {
        return TapestryInternalUtils.toInternalPropertyConduit(this.conduit).getPropertyName();
    }

    public String getExpression() {
        return this.expression;
    }
}

