/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.status;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.spark.JobExecutionStatus;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.executor.ExecutorMetrics;
import org.apache.spark.status.AppStatusListener;
import org.apache.spark.status.AppStatusSource;
import org.apache.spark.status.AppStatusStore$;
import org.apache.spark.status.AppStatusUtils$;
import org.apache.spark.status.AppSummary;
import org.apache.spark.status.ApplicationEnvironmentInfoWrapper;
import org.apache.spark.status.ApplicationInfoWrapper;
import org.apache.spark.status.CachedQuantile;
import org.apache.spark.status.ExecutorStageSummaryWrapper;
import org.apache.spark.status.ExecutorSummaryWrapper;
import org.apache.spark.status.JobDataWrapper;
import org.apache.spark.status.KVUtils$;
import org.apache.spark.status.PoolData;
import org.apache.spark.status.ProcessSummaryWrapper;
import org.apache.spark.status.RDDOperationGraphWrapper;
import org.apache.spark.status.RDDStorageInfoWrapper;
import org.apache.spark.status.ResourceProfileWrapper;
import org.apache.spark.status.SpeculationStageSummaryWrapper;
import org.apache.spark.status.StageDataWrapper;
import org.apache.spark.status.StreamBlockData;
import org.apache.spark.status.TaskDataWrapper;
import org.apache.spark.status.api.v1.ApplicationAttemptInfo;
import org.apache.spark.status.api.v1.ApplicationEnvironmentInfo;
import org.apache.spark.status.api.v1.ApplicationInfo;
import org.apache.spark.status.api.v1.ExecutorMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorPeakMetricsDistributions;
import org.apache.spark.status.api.v1.ExecutorStageSummary;
import org.apache.spark.status.api.v1.ExecutorSummary;
import org.apache.spark.status.api.v1.InputMetricDistributions;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.OutputMetricDistributions;
import org.apache.spark.status.api.v1.ProcessSummary;
import org.apache.spark.status.api.v1.RDDStorageInfo;
import org.apache.spark.status.api.v1.ResourceProfileInfo;
import org.apache.spark.status.api.v1.ShufflePushReadMetricDistributions;
import org.apache.spark.status.api.v1.ShuffleReadMetricDistributions;
import org.apache.spark.status.api.v1.ShuffleWriteMetricDistributions;
import org.apache.spark.status.api.v1.SpeculationStageSummary;
import org.apache.spark.status.api.v1.StageData;
import org.apache.spark.status.api.v1.StageStatus;
import org.apache.spark.status.api.v1.TaskData;
import org.apache.spark.status.api.v1.TaskMetricDistributions;
import org.apache.spark.status.api.v1.TaskSorting;
import org.apache.spark.status.api.v1.TaskStatus;
import org.apache.spark.storage.FallbackStorage$;
import org.apache.spark.ui.scope.RDDOperationGraph;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.kvstore.KVStore;
import org.apache.spark.util.kvstore.KVStoreIterator;
import org.apache.spark.util.kvstore.KVStoreView;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.IndexedSeq$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0011\rc!\u0002'N\u0001=+\u0006\u0002\u0003/\u0001\u0005\u000b\u0007I\u0011\u00010\t\u0011\u001d\u0004!\u0011!Q\u0001\n}C\u0001\u0002\u001b\u0001\u0003\u0006\u0004%\t!\u001b\u0005\tc\u0002\u0011\t\u0011)A\u0005U\"A!\u000f\u0001BC\u0002\u0013\u00051\u000f\u0003\u0005~\u0001\t\u0005\t\u0015!\u0003u\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u001d\tI\u0001\u0001C\u0001\u0003\u0017Aq!!\b\u0001\t\u0003\ty\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L!9\u00111\u000e\u0001\u0005\u0002\u00055\u0004bBA=\u0001\u0011\u0005\u00111\u0010\u0005\b\u0003\u001b\u0003A\u0011AAH\u0011\u001d\t\u0019\u000b\u0001C\u0005\u0003KCq!a+\u0001\t\u0013\ti\u000bC\u0004\u0002<\u0002!I!!0\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011Q\u0019\u0001\u0005\u0002\u0005\u001d\u0007bBAj\u0001\u0011\u0005\u0011Q\u001b\u0005\b\u0003W\u0004A\u0011AAw\u0011\u001d\t9\u0010\u0001C\u0001\u0003sD\u0011B!\u000b\u0001#\u0003%\tAa\u000b\t\u0013\t\u0005\u0003!%A\u0005\u0002\t-\u0002\"\u0003B\"\u0001E\u0005I\u0011\u0001B#\u0011%\u0011I\u0005AI\u0001\n\u0003\u0011Y\u0005C\u0004\u0003P\u0001!\tA!\u0015\t\u0013\t}\u0003!%A\u0005\u0002\t-\u0002\"\u0003B1\u0001E\u0005I\u0011\u0001B&\u0011%\u0011\u0019\u0007AI\u0001\n\u0003\u0011Y\u0003C\u0005\u0003f\u0001\t\n\u0011\"\u0001\u0003F!9!q\r\u0001\u0005\u0002\t%\u0004b\u0002B7\u0001\u0011\u0005!q\u000e\u0005\n\u0005\u0007\u0003\u0011\u0013!C\u0001\u0005WA\u0011B!\"\u0001#\u0003%\tAa\u0013\t\u0013\t\u001d\u0005!%A\u0005\u0002\t-\u0002\"\u0003BE\u0001E\u0005I\u0011\u0001B#\u0011\u001d\u0011Y\t\u0001C\u0001\u0005\u001bCqAa%\u0001\t\u0003\u0011)\nC\u0004\u0003\"\u0002!\tAa)\t\u000f\tM\u0006\u0001\"\u0003\u00036\"9!1\u0018\u0001\u0005\n\tu\u0006b\u0002Ba\u0001\u0011\u0005!1\u0019\u0005\b\u0005\u0003\u0004A\u0011\u0001Bk\u0011\u001d\u0011\t\r\u0001C\u0001\u0005_D\u0011ba\u0001\u0001#\u0003%\tAa\u0013\t\u000f\u0005M\u0007\u0001\"\u0001\u0004\u0006!91Q\u0003\u0001\u0005\u0002\r]\u0001bBB\u0013\u0001\u0011\u00051q\u0005\u0005\n\u0007k\u0001\u0011\u0013!C\u0001\u0005WAqaa\u000e\u0001\t\u0003\u0019I\u0004C\u0004\u0004`\u0001!\ta!\u0019\t\u0013\rE\u0004!%A\u0005\u0002\t-\u0002\"CB:\u0001E\u0005I\u0011\u0001B&\u0011%\u0019)\bAI\u0001\n\u0003\u0011Y\u0003C\u0005\u0004x\u0001\t\n\u0011\"\u0001\u0003F!91\u0011\u0010\u0001\u0005\u0002\rm\u0004bBBF\u0001\u0011\u00051Q\u0012\u0005\b\u0007'\u0003A\u0011ABK\u0011\u001d\u0019y\n\u0001C\u0001\u0007CCqa!.\u0001\t\u0003\u00199\fC\u0004\u0004F\u0002!\taa2\t\u000f\rM\u0007\u0001\"\u0001\u0004V\"91Q\u001c\u0001\u0005\u0002\r}\u0007bBBt\u0001\u0011%1q\u001c\u0005\b\u0007S\u0004A\u0011ABv\u000f!\u0019i0\u0014E\u0001\u001f\u000e}ha\u0002'N\u0011\u0003yE\u0011\u0001\u0005\u0007}\u0012#\t\u0001b\u0004\t\u0013\u0011EAI1A\u0005\u0002\u0011M\u0001\u0002\u0003C\u000b\t\u0002\u0006I!!\"\t\u000f\u0011]A\t\"\u0001\u0005\u001a!IA\u0011\u0007#\u0012\u0002\u0013\u0005A1\u0007\u0005\n\to!\u0015\u0013!C\u0001\tsA\u0011\u0002\"\u0010E#\u0003%\t\u0001b\u0010\u0003\u001d\u0005\u0003\bo\u0015;biV\u001c8\u000b^8sK*\u0011ajT\u0001\u0007gR\fG/^:\u000b\u0005A\u000b\u0016!B:qCJ\\'B\u0001*T\u0003\u0019\t\u0007/Y2iK*\tA+A\u0002pe\u001e\u001c\"\u0001\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0003e\u000bQa]2bY\u0006L!a\u0017-\u0003\r\u0005s\u0017PU3g\u0003\u0015\u0019Ho\u001c:f\u0007\u0001)\u0012a\u0018\t\u0003A\u0016l\u0011!\u0019\u0006\u0003E\u000e\fqa\u001b<ti>\u0014XM\u0003\u0002e\u001f\u0006!Q\u000f^5m\u0013\t1\u0017MA\u0004L-N#xN]3\u0002\rM$xN]3!\u0003!a\u0017n\u001d;f]\u0016\u0014X#\u00016\u0011\u0007][W.\u0003\u0002m1\n1q\n\u001d;j_:\u0004\"A\\8\u000e\u00035K!\u0001]'\u0003#\u0005\u0003\bo\u0015;biV\u001cH*[:uK:,'/A\u0005mSN$XM\\3sA\u0005I1\u000f^8sKB\u000bG\u000f[\u000b\u0002iB\u0019qk[;\u0011\u0005Y\\X\"A<\u000b\u0005aL\u0018AA5p\u0015\u0005Q\u0018\u0001\u00026bm\u0006L!\u0001`<\u0003\t\u0019KG.Z\u0001\u000bgR|'/\u001a)bi\"\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0005\u0002\u0002\u0005\r\u0011QAA\u0004!\tq\u0007\u0001C\u0003]\u000f\u0001\u0007q\fC\u0004i\u000fA\u0005\t\u0019\u00016\t\u000fI<\u0001\u0013!a\u0001i\u0006y\u0011\r\u001d9mS\u000e\fG/[8o\u0013:4w\u000e\u0006\u0002\u0002\u000eA!\u0011qBA\r\u001b\t\t\tB\u0003\u0003\u0002\u0014\u0005U\u0011A\u0001<2\u0015\r\t9\"T\u0001\u0004CBL\u0017\u0002BA\u000e\u0003#\u0011q\"\u00119qY&\u001c\u0017\r^5p]&sgm\\\u0001\u0010K:4\u0018N]8o[\u0016tG/\u00138g_R\u0011\u0011\u0011\u0005\t\u0005\u0003\u001f\t\u0019#\u0003\u0003\u0002&\u0005E!AG!qa2L7-\u0019;j_:,eN^5s_:lWM\u001c;J]\u001a|\u0017a\u0005:fg>,(oY3Qe>4\u0017\u000e\\3J]\u001a|GCAA\u0016!\u0019\ti#!\u0010\u0002D9!\u0011qFA\u001d\u001d\u0011\t\t$a\u000e\u000e\u0005\u0005M\"bAA\u001b;\u00061AH]8pizJ\u0011!W\u0005\u0004\u0003wA\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003\u007f\t\tEA\u0002TKFT1!a\u000fY!\u0011\ty!!\u0012\n\t\u0005\u001d\u0013\u0011\u0003\u0002\u0014%\u0016\u001cx.\u001e:dKB\u0013xNZ5mK&sgm\\\u0001\tU>\u00147\u000fT5tiR!\u0011QJA+!\u0019\ti#!\u0010\u0002PA!\u0011qBA)\u0013\u0011\t\u0019&!\u0005\u0003\u000f){'\rR1uC\"9\u0011qK\u0006A\u0002\u0005e\u0013\u0001C:uCR,8/Z:\u0011\r\u0005m\u0013qLA2\u001b\t\tiF\u0003\u0002es&!\u0011\u0011MA/\u0005\u0011a\u0015n\u001d;\u0011\t\u0005\u0015\u0014qM\u0007\u0002\u001f&\u0019\u0011\u0011N(\u0003%){'-\u0012=fGV$\u0018n\u001c8Ti\u0006$Xo]\u0001\u0004U>\u0014G\u0003BA(\u0003_Bq!!\u001d\r\u0001\u0004\t\u0019(A\u0003k_\nLE\rE\u0002X\u0003kJ1!a\u001eY\u0005\rIe\u000e^\u0001\u0015U>\u0014w+\u001b;i\u0003N\u001cxnY5bi\u0016$7+\u001d7\u0015\t\u0005u\u00141\u0012\t\b/\u0006}\u0014qJAB\u0013\r\t\t\t\u0017\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t][\u0017Q\u0011\t\u0004/\u0006\u001d\u0015bAAE1\n!Aj\u001c8h\u0011\u001d\t\t(\u0004a\u0001\u0003g\nA\"\u001a=fGV$xN\u001d'jgR$B!!%\u0002\u001aB1\u0011QFA\u001f\u0003'\u0003B!a\u0004\u0002\u0016&!\u0011qSA\t\u0005=)\u00050Z2vi>\u00148+^7nCJL\bbBAN\u001d\u0001\u0007\u0011QT\u0001\u000bC\u000e$\u0018N^3P]2L\bcA,\u0002 &\u0019\u0011\u0011\u0015-\u0003\u000f\t{w\u000e\\3b]\u0006Y!/\u001a9mC\u000e,W\t_3d)\u0011\t\u0019*a*\t\u000f\u0005%v\u00021\u0001\u0002\u0014\u00061qN]5hS:\f1C]3qY\u0006\u001cW\r\u0012:jm\u0016\u0014xi\u0019+j[\u0016$\u0002\"a%\u00020\u0006M\u0016q\u0017\u0005\b\u0003c\u0003\u0002\u0019AAJ\u0003\u0019\u0019x.\u001e:dK\"9\u0011Q\u0017\tA\u0002\u0005\r\u0015a\u0003;pi\u0006dwi\u0019+j[\u0016Dq!!/\u0011\u0001\u0004\t\u0019)\u0001\u0007u_R\fG.\u00119q)&lW-A\u0007fqR\u0014\u0018m\u0019;HGRKW.\u001a\u000b\u0005\u0003\u0007\u000by\fC\u0004\u00022F\u0001\r!a%\u0002\u001d\u0015DHO]1di\u0006\u0003\b\u000fV5nKV\u0011\u00111Q\u0001\u0019[&\u001c8-\u001a7mC:,w.^:Qe>\u001cWm]:MSN$H\u0003BAe\u0003#\u0004b!!\f\u0002>\u0005-\u0007\u0003BA\b\u0003\u001bLA!a4\u0002\u0012\tq\u0001K]8dKN\u001c8+^7nCJL\bbBAN'\u0001\u0007\u0011QT\u0001\u0010Kb,7-\u001e;peN+X.\\1ssR!\u00111SAl\u0011\u001d\tI\u000e\u0006a\u0001\u00037\f!\"\u001a=fGV$xN]%e!\u0011\ti.!:\u000f\t\u0005}\u0017\u0011\u001d\t\u0004\u0003cA\u0016bAAr1\u00061\u0001K]3eK\u001aLA!a:\u0002j\n11\u000b\u001e:j]\u001eT1!a9Y\u00031\t7\r^5wKN#\u0018mZ3t)\t\ty\u000f\u0005\u0004\u0002.\u0005u\u0012\u0011\u001f\t\u0005\u0003\u001f\t\u00190\u0003\u0003\u0002v\u0006E!!C*uC\u001e,G)\u0019;b\u0003%\u0019H/Y4f\u0019&\u001cH\u000f\u0006\u0007\u0002p\u0006m(Q\u0001B\u0005\u0005\u001b\u0011i\u0002C\u0004\u0002XY\u0001\r!!@\u0011\r\u0005m\u0013qLA\u0000!\u0011\tyA!\u0001\n\t\t\r\u0011\u0011\u0003\u0002\f'R\fw-Z*uCR,8\u000fC\u0005\u0003\bY\u0001\n\u00111\u0001\u0002\u001e\u00069A-\u001a;bS2\u001c\b\"\u0003B\u0006-A\u0005\t\u0019AAO\u000359\u0018\u000e\u001e5Tk6l\u0017M]5fg\"I!q\u0002\f\u0011\u0002\u0003\u0007!\u0011C\u0001\u0012k:\u001cxN\u001d;fIF+\u0018M\u001c;jY\u0016\u001c\b#B,\u0003\u0014\t]\u0011b\u0001B\u000b1\n)\u0011I\u001d:bsB\u0019qK!\u0007\n\u0007\tm\u0001L\u0001\u0004E_V\u0014G.\u001a\u0005\n\u0005?1\u0002\u0013!a\u0001\u0005C\t!\u0002^1tWN#\u0018\r^;t!\u0019\tY&a\u0018\u0003$A!\u0011q\u0002B\u0013\u0013\u0011\u00119#!\u0005\u0003\u0015Q\u000b7o[*uCR,8/A\nti\u0006<W\rT5ti\u0012\"WMZ1vYR$#'\u0006\u0002\u0003.)\"\u0011Q\u0014B\u0018W\t\u0011\t\u0004\u0005\u0003\u00034\tuRB\u0001B\u001b\u0015\u0011\u00119D!\u000f\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u001e1\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t}\"Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aE:uC\u001e,G*[:uI\u0011,g-Y;mi\u0012\u001a\u0014aE:uC\u001e,G*[:uI\u0011,g-Y;mi\u0012\"TC\u0001B$U\u0011\u0011\tBa\f\u0002'M$\u0018mZ3MSN$H\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t5#\u0006\u0002B\u0011\u0005_\t\u0011b\u001d;bO\u0016$\u0015\r^1\u0015\u0019\u0005=(1\u000bB,\u00053\u0012YF!\u0018\t\u000f\tU3\u00041\u0001\u0002t\u000591\u000f^1hK&#\u0007\"\u0003B\u00047A\u0005\t\u0019AAO\u0011%\u0011yb\u0007I\u0001\u0002\u0004\u0011\t\u0003C\u0005\u0003\fm\u0001\n\u00111\u0001\u0002\u001e\"I!qB\u000e\u0011\u0002\u0003\u0007!\u0011C\u0001\u0014gR\fw-\u001a#bi\u0006$C-\u001a4bk2$HEM\u0001\u0014gR\fw-\u001a#bi\u0006$C-\u001a4bk2$HeM\u0001\u0014gR\fw-\u001a#bi\u0006$C-\u001a4bk2$H\u0005N\u0001\u0014gR\fw-\u001a#bi\u0006$C-\u001a4bk2$H%N\u0001\u0011Y\u0006\u001cHo\u0015;bO\u0016\fE\u000f^3naR$B!!=\u0003l!9!Q\u000b\u0011A\u0002\u0005M\u0014\u0001D:uC\u001e,\u0017\t\u001e;f[B$HC\u0004B9\u0005k\u00129Ha\u001f\u0003~\t}$\u0011\u0011\t\b/\u0006}\u0014\u0011\u001fB:!\u0019\ti#!\u0010\u0002t!9!QK\u0011A\u0002\u0005M\u0004b\u0002B=C\u0001\u0007\u00111O\u0001\u000fgR\fw-Z!ui\u0016l\u0007\u000f^%e\u0011%\u00119!\tI\u0001\u0002\u0004\ti\nC\u0005\u0003 \u0005\u0002\n\u00111\u0001\u0003\"!I!1B\u0011\u0011\u0002\u0003\u0007\u0011Q\u0014\u0005\n\u0005\u001f\t\u0003\u0013!a\u0001\u0005#\tac\u001d;bO\u0016\fE\u000f^3naR$C-\u001a4bk2$HeM\u0001\u0017gR\fw-Z!ui\u0016l\u0007\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%i\u000512\u000f^1hK\u0006#H/Z7qi\u0012\"WMZ1vYR$S'\u0001\fti\u0006<W-\u0011;uK6\u0004H\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0003%!\u0018m]6D_VtG\u000f\u0006\u0004\u0002\u0006\n=%\u0011\u0013\u0005\b\u0005+2\u0003\u0019AA:\u0011\u001d\u0011IH\na\u0001\u0003g\nq\u0002\\8dC2LG/_*v[6\f'/\u001f\u000b\u0007\u0005/\u0013iJa(\u0011\u0011\u0005u'\u0011TAn\u0003\u000bKAAa'\u0002j\n\u0019Q*\u00199\t\u000f\tUs\u00051\u0001\u0002t!9!\u0011P\u0014A\u0002\u0005M\u0014a\u0003;bg.\u001cV/\\7bef$\u0002B!*\u0003.\n=&\u0011\u0017\t\u0005/.\u00149\u000b\u0005\u0003\u0002\u0010\t%\u0016\u0002\u0002BV\u0003#\u0011q\u0003V1tW6+GO]5d\t&\u001cHO]5ckRLwN\\:\t\u000f\tU\u0003\u00061\u0001\u0002t!9!\u0011\u0010\u0015A\u0002\u0005M\u0004b\u0002B\bQ\u0001\u0007!\u0011C\u0001\u0014g\"|W\u000f\u001c3DC\u000eDW-U;b]RLG.\u001a\u000b\u0005\u0003;\u00139\fC\u0004\u0003:&\u0002\rAa\u0006\u0002\u0003E\f\u0001#];b]RLG.\u001a+p'R\u0014\u0018N\\4\u0015\t\u0005m'q\u0018\u0005\b\u0005sS\u0003\u0019\u0001B\f\u0003!!\u0018m]6MSN$H\u0003\u0003Bc\u0005\u001b\u0014yM!5\u0011\r\u00055\u0012Q\bBd!\u0011\tyA!3\n\t\t-\u0017\u0011\u0003\u0002\t)\u0006\u001c8\u000eR1uC\"9!QK\u0016A\u0002\u0005M\u0004b\u0002B=W\u0001\u0007\u00111\u000f\u0005\b\u0005'\\\u0003\u0019AA:\u0003!i\u0017\r\u001f+bg.\u001cHC\u0004Bc\u0005/\u0014INa7\u0003`\n\r(Q\u001e\u0005\b\u0005+b\u0003\u0019AA:\u0011\u001d\u0011I\b\fa\u0001\u0003gBqA!8-\u0001\u0004\t\u0019(\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005Cd\u0003\u0019AA:\u0003\u0019aWM\\4uQ\"9!Q\u001d\u0017A\u0002\t\u001d\u0018AB:peR\u0014\u0015\u0010\u0005\u0003\u0002\u0010\t%\u0018\u0002\u0002Bv\u0003#\u00111\u0002V1tWN{'\u000f^5oO\"9\u0011q\u000b\u0017A\u0002\t\u0005B\u0003\u0005Bc\u0005c\u0014\u0019P!>\u0003x\ne(Q`B\u0001\u0011\u001d\u0011)&\fa\u0001\u0003gBqA!\u001f.\u0001\u0004\t\u0019\bC\u0004\u0003^6\u0002\r!a\u001d\t\u000f\t\u0005X\u00061\u0001\u0002t!9!Q]\u0017A\u0002\tm\b\u0003B,l\u00037DqAa@.\u0001\u0004\ti*A\u0005bg\u000e,g\u000eZ5oO\"I\u0011qK\u0017\u0011\u0002\u0003\u0007!\u0011E\u0001\u0013i\u0006\u001c8\u000eT5ti\u0012\"WMZ1vYR$s\u0007\u0006\u0004\u0004\b\r=1\u0011\u0003\t\t\u0003;\u0014I*a7\u0004\nA!\u0011qBB\u0006\u0013\u0011\u0019i!!\u0005\u0003)\u0015CXmY;u_J\u001cF/Y4f'VlW.\u0019:z\u0011\u001d\u0011)f\fa\u0001\u0003gBqaa\u00050\u0001\u0004\t\u0019(A\u0005biR,W\u000e\u001d;JI\u0006\u00112\u000f]3dk2\fG/[8o'VlW.\u0019:z)\u0019\u0019Ib!\t\u0004$A!qk[B\u000e!\u0011\tya!\b\n\t\r}\u0011\u0011\u0003\u0002\u0018'B,7-\u001e7bi&|gn\u0015;bO\u0016\u001cV/\\7befDqA!\u00161\u0001\u0004\t\u0019\bC\u0004\u0004\u0014A\u0002\r!a\u001d\u0002\u000fI$G\rT5tiR!1\u0011FB\u0019!\u0019\ti#!\u0010\u0004,A!\u0011qBB\u0017\u0013\u0011\u0019y#!\u0005\u0003\u001dI#Ei\u0015;pe\u0006<W-\u00138g_\"I11G\u0019\u0011\u0002\u0003\u0007\u0011QT\u0001\u000bG\u0006\u001c\u0007.\u001a3P]2L\u0018!\u0005:eI2K7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%c\u0005A\u0011m](qi&|g.\u0006\u0003\u0004<\r\rC\u0003BB\u001f\u0007+\u0002BaV6\u0004@A!1\u0011IB\"\u0019\u0001!qa!\u00124\u0005\u0004\u00199EA\u0001U#\u0011\u0019Iea\u0014\u0011\u0007]\u001bY%C\u0002\u0004Na\u0013qAT8uQ&tw\rE\u0002X\u0007#J1aa\u0015Y\u0005\r\te.\u001f\u0005\t\u0007/\u001aD\u00111\u0001\u0004Z\u0005\u0011aM\u001c\t\u0006/\u000em3qH\u0005\u0004\u0007;B&\u0001\u0003\u001fcs:\fW.\u001a \u0002\u00199,wo\u0015;bO\u0016$\u0015\r^1\u0015\u0019\u0005E81MB4\u0007W\u001aiga\u001c\t\u000f\r\u0015D\u00071\u0001\u0002r\u0006)1\u000f^1hK\"I1\u0011\u000e\u001b\u0011\u0002\u0003\u0007\u0011QT\u0001\u000bo&$\b\u000eR3uC&d\u0007\"\u0003B\u0010iA\u0005\t\u0019\u0001B\u0011\u0011%\u0011Y\u0001\u000eI\u0001\u0002\u0004\ti\nC\u0005\u0003\u0010Q\u0002\n\u00111\u0001\u0003\u0012\u00051b.Z<Ti\u0006<W\rR1uC\u0012\"WMZ1vYR$#'\u0001\foK^\u001cF/Y4f\t\u0006$\u0018\r\n3fM\u0006,H\u000e\u001e\u00134\u0003YqWm^*uC\u001e,G)\u0019;bI\u0011,g-Y;mi\u0012\"\u0014A\u00068foN#\u0018mZ3ECR\fG\u0005Z3gCVdG\u000fJ\u001b\u0002)M$\u0018mZ3Fq\u0016\u001cW\u000f^8s'VlW.\u0019:z)!\u0019ih!\"\u0004\b\u000e%\u0005\u0003B,l\u0007\u007f\u0002B!a\u0004\u0004\u0002&!11QA\t\u0005q)\u00050Z2vi>\u0014X*\u001a;sS\u000e\u001cH)[:ue&\u0014W\u000f^5p]NDqA!\u0016:\u0001\u0004\t\u0019\bC\u0004\u0003ze\u0002\r!a\u001d\t\u000f\t=\u0011\b1\u0001\u0003\u0012\u0005\u0019!\u000f\u001a3\u0015\t\r-2q\u0012\u0005\b\u0007#S\u0004\u0019AA:\u0003\u0015\u0011H\rZ%e\u0003A\u0019HO]3b[\ncwnY6t\u0019&\u001cH\u000f\u0006\u0002\u0004\u0018B1\u0011QFA\u001f\u00073\u00032A\\BN\u0013\r\u0019i*\u0014\u0002\u0010'R\u0014X-Y7CY>\u001c7\u000eR1uC\u00061r\u000e]3sCRLwN\\$sCBDgi\u001c:Ti\u0006<W\r\u0006\u0003\u0004$\u000eM\u0006\u0003BBS\u0007_k!aa*\u000b\t\r%61V\u0001\u0006g\u000e|\u0007/\u001a\u0006\u0004\u0007[{\u0015AA;j\u0013\u0011\u0019\tla*\u0003#I#Ei\u00149fe\u0006$\u0018n\u001c8He\u0006\u0004\b\u000eC\u0004\u0003Vq\u0002\r!a\u001d\u0002)=\u0004XM]1uS>twI]1qQ\u001a{'OS8c)\u0011\u0019Ila1\u0011\r\rm6\u0011YBR\u001b\t\u0019iLC\u0002\u0004@b\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\tyd!0\t\u000f\u0005ET\b1\u0001\u0002t\u0005!\u0001o\\8m)\u0011\u0019Ima4\u0011\u00079\u001cY-C\u0002\u0004N6\u0013\u0001\u0002U8pY\u0012\u000bG/\u0019\u0005\b\u0007#t\u0004\u0019AAn\u0003\u0011q\u0017-\\3\u0002\u0015\u0005\u0004\boU;n[\u0006\u0014\u0018\u0010\u0006\u0002\u0004XB\u0019an!7\n\u0007\rmWJ\u0001\u0006BaB\u001cV/\\7bef\fQa\u00197pg\u0016$\"a!9\u0011\u0007]\u001b\u0019/C\u0002\u0004fb\u0013A!\u00168ji\u0006\u00012\r\\3b]V\u00038\u000b^8sKB\u000bG\u000f[\u0001\u0016G>t7\u000f\u001e:vGR$\u0016m]6ECR\fG*[:u)\u0011\u0011)m!<\t\u000f\r=(\t1\u0001\u0004r\u0006\u0019B/Y:l\t\u0006$\u0018m\u0016:baB,'/\u0013;feB1\u0011QFBz\u0007oLAa!>\u0002B\tA\u0011\n^3sC\ndW\rE\u0002o\u0007sL1aa?N\u0005=!\u0016m]6ECR\fwK]1qa\u0016\u0014\u0018AD!qaN#\u0018\r^;t'R|'/\u001a\t\u0003]\u0012\u001bB\u0001\u0012,\u0005\u0004A!AQ\u0001C\u0006\u001b\t!9AC\u0002\u0005\n=\u000b\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0005\t\u001b!9AA\u0004M_\u001e<\u0017N\\4\u0015\u0005\r}\u0018aD\"V%J+e\nV0W\u000bJ\u001b\u0016j\u0014(\u0016\u0005\u0005\u0015\u0015\u0001E\"V%J+e\nV0W\u000bJ\u001b\u0016j\u0014(!\u0003=\u0019'/Z1uK2Kg/Z*u_J,GCBA\u0001\t7!)\u0003C\u0004\u0005\u001e!\u0003\r\u0001b\b\u0002\t\r|gN\u001a\t\u0005\u0003K\"\t#C\u0002\u0005$=\u0013\u0011b\u00159be.\u001cuN\u001c4\t\u0013\u0011\u001d\u0002\n%AA\u0002\u0011%\u0012aD1qaN#\u0018\r^;t'>,(oY3\u0011\t][G1\u0006\t\u0004]\u00125\u0012b\u0001C\u0018\u001b\ny\u0011\t\u001d9Ti\u0006$Xo]*pkJ\u001cW-A\rde\u0016\fG/\u001a'jm\u0016\u001cFo\u001c:fI\u0011,g-Y;mi\u0012\u0012TC\u0001C\u001bU\u0011!ICa\f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t!YDK\u0002k\u0005_\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001C!U\r!(q\u0006")
public class AppStatusStore {
    private final KVStore store;
    private final Option<AppStatusListener> listener;
    private final Option<File> storePath;

    public static Option<File> $lessinit$greater$default$3() {
        return AppStatusStore$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<AppStatusListener> $lessinit$greater$default$2() {
        return AppStatusStore$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<AppStatusSource> createLiveStore$default$2() {
        return AppStatusStore$.MODULE$.createLiveStore$default$2();
    }

    public static AppStatusStore createLiveStore(SparkConf sparkConf, Option<AppStatusSource> option) {
        return AppStatusStore$.MODULE$.createLiveStore(sparkConf, option);
    }

    public static long CURRENT_VERSION() {
        return AppStatusStore$.MODULE$.CURRENT_VERSION();
    }

    public KVStore store() {
        return this.store;
    }

    public Option<AppStatusListener> listener() {
        return this.listener;
    }

    public Option<File> storePath() {
        return this.storePath;
    }

    public ApplicationInfo applicationInfo() {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = (ApplicationInfo)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(ApplicationInfoWrapper.class).max(1L).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> ((ApplicationInfoWrapper)it.next()).info());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application information. If you are starting up Spark, please wait a while until it's ready.");
        }
        return applicationInfo;
    }

    public ApplicationEnvironmentInfo environmentInfo() {
        Class<ApplicationEnvironmentInfoWrapper> klass = ApplicationEnvironmentInfoWrapper.class;
        return ((ApplicationEnvironmentInfoWrapper)this.store().read(klass, (Object)klass.getName())).info();
    }

    public Seq<ResourceProfileInfo> resourceProfileInfo() {
        return KVUtils$.MODULE$.mapToSeq(this.store().view(ResourceProfileWrapper.class), (Function1 & Serializable & scala.Serializable)x$1 -> x$1.rpInfo());
    }

    public Seq<JobData> jobsList(List<JobExecutionStatus> statuses) {
        Seq it = KVUtils$.MODULE$.mapToSeq(this.store().view(JobDataWrapper.class).reverse(), (Function1 & Serializable & scala.Serializable)x$2 -> x$2.info());
        if (statuses != null && !statuses.isEmpty()) {
            return (Seq)it.filter((Function1 & Serializable & scala.Serializable)job -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)job.status())));
        }
        return it;
    }

    public JobData job(int jobId) {
        return ((JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId))).info();
    }

    public Tuple2<JobData, Option<Object>> jobWithAssociatedSql(int jobId) {
        JobDataWrapper data = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        return new Tuple2((Object)data.info(), data.sqlExecutionId());
    }

    public Seq<ExecutorSummary> executorList(boolean activeOnly) {
        KVStoreView base = this.store().view(ExecutorSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return (Seq)((TraversableLike)KVUtils$.MODULE$.mapToSeq(filtered, (Function1 & Serializable & scala.Serializable)x$3 -> x$3.info()).filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$executorList$2(x$4)))).map((Function1 & Serializable & scala.Serializable)origin -> this.replaceExec((ExecutorSummary)origin), Seq$.MODULE$.canBuildFrom());
    }

    private ExecutorSummary replaceExec(ExecutorSummary origin) {
        String string = origin.id();
        String string2 = SparkContext$.MODULE$.DRIVER_IDENTIFIER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.replaceDriverGcTime(origin, this.extractGcTime(origin), this.extractAppTime());
        }
        return origin;
    }

    private ExecutorSummary replaceDriverGcTime(ExecutorSummary source, Option<Object> totalGcTime, Option<Object> totalAppTime) {
        return new ExecutorSummary(source.id(), source.hostPort(), source.isActive(), source.rddBlocks(), source.memoryUsed(), source.diskUsed(), source.totalCores(), source.maxTasks(), source.activeTasks(), source.failedTasks(), source.completedTasks(), source.totalTasks(), BoxesRunTime.unboxToLong((Object)totalAppTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalDuration())), BoxesRunTime.unboxToLong((Object)totalGcTime.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> source.totalGCTime())), source.totalInputBytes(), source.totalShuffleRead(), source.totalShuffleWrite(), source.isBlacklisted(), source.maxMemory(), source.addTime(), source.removeTime(), source.removeReason(), source.executorLogs(), source.memoryMetrics(), source.blacklistedInStages(), source.peakMemoryMetrics(), source.attributes(), source.resources(), source.resourceProfileId(), source.isExcluded(), source.excludedInStages());
    }

    private Option<Object> extractGcTime(ExecutorSummary source) {
        return source.peakMemoryMetrics().map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getMetricValue("TotalGCTime")));
    }

    private Option<Object> extractAppTime() {
        long startTime = 0L;
        long endTime = 0L;
        try {
            ApplicationInfo appInfo = this.applicationInfo();
            startTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).startTime().getTime();
            endTime = ((ApplicationAttemptInfo)appInfo.attempts().head()).endTime().getTime();
        }
        catch (NoSuchElementException noSuchElementException) {}
        if (endTime == 0L) {
            return None$.MODULE$;
        }
        if (endTime < 0L) {
            return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(System.currentTimeMillis() - startTime)));
        }
        return Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(endTime - startTime)));
    }

    public Seq<ProcessSummary> miscellaneousProcessList(boolean activeOnly) {
        KVStoreView base = this.store().view(ProcessSummaryWrapper.class);
        KVStoreView filtered = activeOnly ? base.index("active").reverse().first((Object)BoxesRunTime.boxToBoolean((boolean)true)).last((Object)BoxesRunTime.boxToBoolean((boolean)true)) : base;
        return KVUtils$.MODULE$.mapToSeq(filtered, (Function1 & Serializable & scala.Serializable)x$6 -> x$6.info());
    }

    public ExecutorSummary executorSummary(String executorId) {
        return ((ExecutorSummaryWrapper)this.store().read(ExecutorSummaryWrapper.class, (Object)executorId)).info();
    }

    public Seq<StageData> activeStages() {
        return (Seq)this.listener().map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.activeStages()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
    }

    public Seq<StageData> stageList(List<StageStatus> statuses, boolean details, boolean withSummaries, double[] unsortedQuantiles, List<TaskStatus> taskStatus) {
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Seq it = KVUtils$.MODULE$.mapToSeq(this.store().view(StageDataWrapper.class).reverse(), (Function1 & Serializable & scala.Serializable)x$8 -> x$8.info());
        Seq ret = statuses != null && !statuses.isEmpty() ? (Seq)it.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statuses.contains((Object)s.status()))) : it;
        return (Seq)ret.map((Function1 & Serializable & scala.Serializable)s -> this.newStageData((StageData)s, details, taskStatus, withSummaries, quantiles), Seq$.MODULE$.canBuildFrom());
    }

    public boolean stageList$default$2() {
        return false;
    }

    public boolean stageList$default$3() {
        return false;
    }

    public double[] stageList$default$4() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public List<TaskStatus> stageList$default$5() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Seq<StageData> stageData(int stageId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        return KVUtils$.MODULE$.mapToSeq(this.store().view(StageDataWrapper.class).index("stageId").first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId)), (Function1 & Serializable & scala.Serializable)s -> this.newStageData(s.info(), details, taskStatus, withSummaries, unsortedQuantiles));
    }

    public boolean stageData$default$2() {
        return false;
    }

    public List<TaskStatus> stageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageData$default$4() {
        return false;
    }

    public double[] stageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public StageData lastStageAttempt(int stageId) {
        StageData stageData;
        block4: {
            try (KVStoreIterator it = this.store().view(StageDataWrapper.class).index("stageId").reverse().first((Object)BoxesRunTime.boxToInteger((int)stageId)).last((Object)BoxesRunTime.boxToInteger((int)stageId)).closeableIterator();){
                if (it.hasNext()) {
                    stageData = ((StageDataWrapper)it.next()).info();
                    break block4;
                }
                throw new NoSuchElementException(new StringBuilder(17).append("No stage with id ").append(stageId).toString());
            }
        }
        return stageData;
    }

    public Tuple2<StageData, Seq<Object>> stageAttempt(int stageId, int stageAttemptId, boolean details, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        StageDataWrapper stageDataWrapper = (StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)stageKey);
        StageData stage = this.newStageData(stageDataWrapper.info(), details, taskStatus, withSummaries, unsortedQuantiles);
        return new Tuple2((Object)stage, (Object)stageDataWrapper.jobIds().toSeq());
    }

    public boolean stageAttempt$default$3() {
        return false;
    }

    public List<TaskStatus> stageAttempt$default$4() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean stageAttempt$default$5() {
        return false;
    }

    public double[] stageAttempt$default$6() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public long taskCount(int stageId, int stageAttemptId) {
        return this.store().count(TaskDataWrapper.class, "stage", (Object)new int[]{stageId, stageAttemptId});
    }

    public Map<String, Object> localitySummary(int stageId, int stageAttemptId) {
        return ((StageDataWrapper)this.store().read(StageDataWrapper.class, (Object)new int[]{stageId, stageAttemptId})).locality();
    }

    public Option<TaskMetricDistributions> taskSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        long count = BoxesRunTime.unboxToLong(Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey).index("ert").first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$2(it))));
        if (count <= 0L) {
            return None$.MODULE$;
        }
        CachedQuantile[] cachedQuantiles = (CachedQuantile[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).filter((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)q -> this.shouldCacheQuantile(q)))).flatMap((Function1 & Serializable & scala.Serializable)q -> AppStatusStore.$anonfun$taskSummary$4(this, stageId, stageAttemptId, count, BoxesRunTime.unboxToDouble((Object)q)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CachedQuantile.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles)).size() == new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).size()) {
            TaskMetricDistributions distributions = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToDouble((double)x$10.duration()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToDouble((double)x$11.executorDeserializeTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.executorDeserializeCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToDouble((double)x$13.executorRunTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14.executorCpuTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToDouble((double)x$15.resultSize()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToDouble((double)x$16.jvmGcTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)x$17.resultSerializationTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToDouble((double)x$18.gettingResultTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToDouble((double)x$19.schedulerDelay()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToDouble((double)x$20.peakExecutionMemory()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToDouble((double)x$21.memoryBytesSpilled()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$22 -> BoxesRunTime.boxToDouble((double)x$22.diskBytesSpilled()), cachedQuantiles), new InputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToDouble((double)x$23.bytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$24 -> BoxesRunTime.boxToDouble((double)x$24.recordsRead()), cachedQuantiles)), new OutputMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$25 -> BoxesRunTime.boxToDouble((double)x$25.bytesWritten()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$26 -> BoxesRunTime.boxToDouble((double)x$26.recordsWritten()), cachedQuantiles)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$27 -> BoxesRunTime.boxToDouble((double)x$27.shuffleReadBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$28 -> BoxesRunTime.boxToDouble((double)x$28.shuffleRecordsRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$29 -> BoxesRunTime.boxToDouble((double)x$29.shuffleRemoteBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$30 -> BoxesRunTime.boxToDouble((double)x$30.shuffleLocalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$31 -> BoxesRunTime.boxToDouble((double)x$31.shuffleFetchWaitTime()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$32 -> BoxesRunTime.boxToDouble((double)x$32.shuffleRemoteBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$33 -> BoxesRunTime.boxToDouble((double)x$33.shuffleRemoteBytesReadToDisk()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$34 -> BoxesRunTime.boxToDouble((double)x$34.shuffleTotalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$35 -> BoxesRunTime.boxToDouble((double)x$35.shuffleRemoteReqsDuration()), cachedQuantiles), new ShufflePushReadMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$36 -> BoxesRunTime.boxToDouble((double)x$36.shuffleCorruptMergedBlockChunks()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToDouble((double)x$37.shuffleMergedFetchFallbackCount()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToDouble((double)x$38.shuffleMergedRemoteBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$39 -> BoxesRunTime.boxToDouble((double)x$39.shuffleMergedLocalBlocksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$40 -> BoxesRunTime.boxToDouble((double)x$40.shuffleMergedRemoteChunksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$41 -> BoxesRunTime.boxToDouble((double)x$41.shuffleMergedLocalChunksFetched()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToDouble((double)x$42.shuffleMergedRemoteBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$43 -> BoxesRunTime.boxToDouble((double)x$43.shuffleMergedLocalBytesRead()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$44 -> BoxesRunTime.boxToDouble((double)x$44.shuffleMergedRemoteReqsDuration()), cachedQuantiles))), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$45 -> BoxesRunTime.boxToDouble((double)x$45.shuffleWriteBytes()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$46 -> BoxesRunTime.boxToDouble((double)x$46.shuffleWriteRecords()), cachedQuantiles), (IndexedSeq<Object>)AppStatusStore.toValues$1((Function1 & Serializable & scala.Serializable)x$47 -> BoxesRunTime.boxToDouble((double)x$47.shuffleWriteTime()), cachedQuantiles)));
            return new Some((Object)distributions);
        }
        long[] indices = (long[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles)).map((Function1)(JFunction1.mcJD.sp & Serializable & scala.Serializable)q -> package$.MODULE$.min((long)(q * (double)count), count - 1L), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        TaskMetricDistributions computedQuantiles = new TaskMetricDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<Object>)this.scanTasks$1("dur", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.duration()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("des", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dct", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorDeserializeCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ert", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorRunTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ect", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.executorCpuTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSize()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("gc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.jvmGcTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("rst", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.resultSerializationTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("grt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.gettingResultTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dly", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.schedulerDelay()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("pem", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.peakExecutionMemory()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("mbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.memoryBytesSpilled()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("dbs", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.diskBytesSpilled()), stageKey, indices), new InputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("is", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("ir", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.inputRecordsRead()), stageKey, indices)), new OutputMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("os", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("or", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.outputRecordsWritten()), stageKey, indices)), new ShuffleReadMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("stby", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$66(m)), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("slbl", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleLocalBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleFetchWaitTime()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srby", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srbd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteBytesReadToDisk()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("stbl", (Function1 & Serializable & scala.Serializable)m -> BoxesRunTime.boxToLong((long)AppStatusStore.$anonfun$taskSummary$73(m)), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("srrd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRemoteReqsDuration()), stageKey, indices), new ShufflePushReadMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("spcmbc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleCorruptMergedBlockChunks()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmffc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedFetchFallbackCount()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrb", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlb", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalBlocksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteChunksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlc", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalChunksFetched()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmlr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedLocalBytesRead()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("spmrrd", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleMergedRemoteReqDuration()), stageKey, indices))), new ShuffleWriteMetricDistributions((IndexedSeq<Object>)this.scanTasks$1("sws", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleBytesWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swr", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleRecordsWritten()), stageKey, indices), (IndexedSeq<Object>)this.scanTasks$1("swt", (Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToLong((long)t.shuffleWriteTime()), stageKey, indices)));
        ((IterableLike)((TraversableLike)computedQuantiles.quantiles().zipWithIndex(IndexedSeq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$87(this, quantiles, x0$1)))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            AppStatusStore.$anonfun$taskSummary$88(this, stageId, stageAttemptId, count, computedQuantiles, x0$2);
            return BoxedUnit.UNIT;
        });
        return new Some((Object)computedQuantiles);
    }

    private boolean shouldCacheQuantile(double q) {
        return package$.MODULE$.round(q * (double)100) % 5L == 0L;
    }

    private String quantileToString(double q) {
        return Long.toString(package$.MODULE$.round(q * (double)100));
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int maxTasks) {
        int[] stageKey = new int[]{stageId, stageAttemptId};
        Seq taskDataWrapperSeq = KVUtils$.MODULE$.viewToSeq(this.store().view(TaskDataWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey).reverse().max((long)maxTasks));
        return (Seq)this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperSeq).reverse();
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, TaskSorting sortBy, List<TaskStatus> statuses) {
        Tuple2 tuple2;
        TaskSorting taskSorting = sortBy;
        if (((Object)((Object)TaskSorting.ID)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)None$.MODULE$, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.INCREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)true));
        } else if (((Object)((Object)TaskSorting.DECREASING_RUNTIME)).equals((Object)taskSorting)) {
            tuple2 = new Tuple2((Object)new Some((Object)"ert"), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        } else {
            throw new MatchError((Object)taskSorting);
        }
        Tuple2 tuple22 = tuple2;
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Option indexName = (Option)tuple22._1();
        boolean ascending = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)indexName, (Object)BoxesRunTime.boxToBoolean((boolean)ascending));
        Option indexName2 = (Option)tuple23._1();
        boolean ascending2 = tuple23._2$mcZ$sp();
        return this.taskList(stageId, stageAttemptId, offset, length, (Option<String>)indexName2, ascending2, statuses);
    }

    public Seq<TaskData> taskList(int stageId, int stageAttemptId, int offset, int length, Option<String> sortBy, boolean ascending, List<TaskStatus> statuses) {
        Seq seq;
        KVStoreView ordered;
        KVStoreView kVStoreView;
        int[] stageKey = new int[]{stageId, stageAttemptId};
        KVStoreView base = this.store().view(TaskDataWrapper.class);
        Option<String> option = sortBy;
        if (option instanceof Some) {
            Some some = (Some)option;
            String index = (String)some.value();
            kVStoreView = base.index(index).parent((Object)stageKey);
        } else {
            kVStoreView = base.index("stage").first((Object)stageKey).last((Object)stageKey);
        }
        KVStoreView indexed = kVStoreView;
        KVStoreView kVStoreView2 = ordered = ascending ? indexed : indexed.reverse();
        if (statuses != null && !statuses.isEmpty()) {
            Set statusesStr = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(statuses).asScala()).map((Function1 & Serializable & scala.Serializable)x$49 -> x$49.toString(), Buffer$.MODULE$.canBuildFrom())).toSet();
            seq = KVUtils$.MODULE$.viewToSeq(ordered, offset, offset + length, (Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)statusesStr.contains((Object)s.status())));
        } else {
            seq = KVUtils$.MODULE$.viewToSeq(ordered.skip((long)offset).max((long)length));
        }
        Seq taskDataWrapperSeq = seq;
        return this.constructTaskDataList((Iterable<TaskDataWrapper>)taskDataWrapperSeq);
    }

    public List<TaskStatus> taskList$default$7() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public Map<String, ExecutorStageSummary> executorSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return KVUtils$.MODULE$.mapToSeq(this.store().view(ExecutorStageSummaryWrapper.class).index("stage").first((Object)stageKey).last((Object)stageKey), (Function1 & Serializable & scala.Serializable)exec -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)exec.executorId()), (Object)exec.info())).toMap(Predef$.MODULE$.$conforms());
    }

    public Option<SpeculationStageSummary> speculationSummary(int stageId, int attemptId) {
        int[] stageKey = new int[]{stageId, attemptId};
        return this.asOption((Function0 & Serializable & scala.Serializable)() -> ((SpeculationStageSummaryWrapper)this.store().read(SpeculationStageSummaryWrapper.class, (Object)stageKey)).info());
    }

    public Seq<RDDStorageInfo> rddList(boolean cachedOnly) {
        return (Seq)KVUtils$.MODULE$.mapToSeq(this.store().view(RDDStorageInfoWrapper.class), (Function1 & Serializable & scala.Serializable)x$50 -> x$50.info()).filter((Function1 & Serializable & scala.Serializable)rdd -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$rddList$2(cachedOnly, rdd)));
    }

    public <T> Option<T> asOption(Function0<T> fn) {
        Some some;
        try {
            some = new Some(fn.apply());
        }
        catch (NoSuchElementException noSuchElementException) {
            some = None$.MODULE$;
        }
        return some;
    }

    public StageData newStageData(StageData stage, boolean withDetail, List<TaskStatus> taskStatus, boolean withSummaries, double[] unsortedQuantiles) {
        None$ none$;
        if (!withDetail && !withSummaries) {
            return stage;
        }
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        if (withDetail) {
            Map tasks = ((TraversableOnce)this.taskList(stage.stageId(), stage.attemptId(), 0, Integer.MAX_VALUE, (Option<String>)None$.MODULE$, false, taskStatus).map((Function1 & Serializable & scala.Serializable)t -> new Tuple2((Object)BoxesRunTime.boxToLong((long)t.taskId()), t), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            none$ = new Some((Object)tasks);
        } else {
            none$ = None$.MODULE$;
        }
        None$ tasks = none$;
        None$ executorSummaries = withDetail ? new Some(this.executorSummary(stage.stageId(), stage.attemptId())) : None$.MODULE$;
        Option<TaskMetricDistributions> taskMetricsDistribution = withSummaries ? this.taskSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
        Option<ExecutorMetricsDistributions> executorMetricsDistributions = withSummaries ? this.stageExecutorSummary(stage.stageId(), stage.attemptId(), quantiles) : None$.MODULE$;
        Option<SpeculationStageSummary> speculationStageSummary = withDetail ? this.speculationSummary(stage.stageId(), stage.attemptId()) : None$.MODULE$;
        return new StageData(stage.status(), stage.stageId(), stage.attemptId(), stage.numTasks(), stage.numActiveTasks(), stage.numCompleteTasks(), stage.numFailedTasks(), stage.numKilledTasks(), stage.numCompletedIndices(), stage.submissionTime(), stage.firstTaskLaunchedTime(), stage.completionTime(), stage.failureReason(), stage.executorDeserializeTime(), stage.executorDeserializeCpuTime(), stage.executorRunTime(), stage.executorCpuTime(), stage.resultSize(), stage.jvmGcTime(), stage.resultSerializationTime(), stage.memoryBytesSpilled(), stage.diskBytesSpilled(), stage.peakExecutionMemory(), stage.inputBytes(), stage.inputRecords(), stage.outputBytes(), stage.outputRecords(), stage.shuffleRemoteBlocksFetched(), stage.shuffleLocalBlocksFetched(), stage.shuffleFetchWaitTime(), stage.shuffleRemoteBytesRead(), stage.shuffleRemoteBytesReadToDisk(), stage.shuffleLocalBytesRead(), stage.shuffleReadBytes(), stage.shuffleReadRecords(), stage.shuffleCorruptMergedBlockChunks(), stage.shuffleMergedFetchFallbackCount(), stage.shuffleMergedRemoteBlocksFetched(), stage.shuffleMergedLocalBlocksFetched(), stage.shuffleMergedRemoteChunksFetched(), stage.shuffleMergedLocalChunksFetched(), stage.shuffleMergedRemoteBytesRead(), stage.shuffleMergedLocalBytesRead(), stage.shuffleRemoteReqsDuration(), stage.shuffleMergedRemoteReqsDuration(), stage.shuffleWriteBytes(), stage.shuffleWriteTime(), stage.shuffleWriteRecords(), stage.name(), stage.description(), stage.details(), stage.schedulingPool(), stage.rddIds(), stage.accumulatorUpdates(), (Option<Map<Object, TaskData>>)tasks, (Option<Map<String, ExecutorStageSummary>>)executorSummaries, speculationStageSummary, stage.killedTasksSummary(), stage.resourceProfileId(), stage.peakExecutorMetrics(), taskMetricsDistribution, executorMetricsDistributions, stage.isShufflePushEnabled(), stage.shuffleMergersCount());
    }

    public boolean newStageData$default$2() {
        return false;
    }

    public List<TaskStatus> newStageData$default$3() {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava();
    }

    public boolean newStageData$default$4() {
        return false;
    }

    public double[] newStageData$default$5() {
        return (double[])Array$.MODULE$.empty(ClassTag$.MODULE$.Double());
    }

    public Option<ExecutorMetricsDistributions> stageExecutorSummary(int stageId, int stageAttemptId, double[] unsortedQuantiles) {
        double[] quantiles = (double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(unsortedQuantiles)).sorted((Ordering)Ordering.Double$.MODULE$);
        Map<String, ExecutorStageSummary> summary = this.executorSummary(stageId, stageAttemptId);
        if (summary.isEmpty()) {
            return None$.MODULE$;
        }
        scala.collection.immutable.IndexedSeq values = summary.values().toIndexedSeq();
        return new Some((Object)new ExecutorMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$51 -> BoxesRunTime.boxToDouble((double)x$51.taskTime()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$52 -> BoxesRunTime.boxToDouble((double)x$52.failedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$53 -> BoxesRunTime.boxToDouble((double)x$53.succeededTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$54 -> BoxesRunTime.boxToDouble((double)x$54.killedTasks()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$55 -> BoxesRunTime.boxToDouble((double)x$55.inputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$56 -> BoxesRunTime.boxToDouble((double)x$56.inputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$57 -> BoxesRunTime.boxToDouble((double)x$57.outputBytes()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$58 -> BoxesRunTime.boxToDouble((double)x$58.outputRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$59 -> BoxesRunTime.boxToDouble((double)x$59.shuffleRead()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$60 -> BoxesRunTime.boxToDouble((double)x$60.shuffleReadRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$61 -> BoxesRunTime.boxToDouble((double)x$61.shuffleWrite()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$62 -> BoxesRunTime.boxToDouble((double)x$62.shuffleWriteRecords()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$63 -> BoxesRunTime.boxToDouble((double)x$63.memoryBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), AppStatusUtils$.MODULE$.getQuantilesValue((IndexedSeq<Object>)((IndexedSeq)((SeqLike)values.map((Function1 & Serializable & scala.Serializable)x$64 -> BoxesRunTime.boxToDouble((double)x$64.diskBytesSpilled()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.Double$.MODULE$)), quantiles), new ExecutorPeakMetricsDistributions((IndexedSeq<Object>)Predef$.MODULE$.wrapDoubleArray(quantiles), (IndexedSeq<ExecutorMetrics>)((IndexedSeq)values.flatMap((Function1 & Serializable & scala.Serializable)x$65 -> Option$.MODULE$.option2Iterable(x$65.peakMemoryMetrics()), scala.collection.immutable.IndexedSeq$.MODULE$.canBuildFrom())))));
    }

    public RDDStorageInfo rdd(int rddId) {
        return ((RDDStorageInfoWrapper)this.store().read(RDDStorageInfoWrapper.class, (Object)BoxesRunTime.boxToInteger((int)rddId))).info();
    }

    public boolean rddList$default$1() {
        return true;
    }

    public Seq<StreamBlockData> streamBlocksList() {
        return KVUtils$.MODULE$.viewToSeq(this.store().view(StreamBlockData.class));
    }

    public RDDOperationGraph operationGraphForStage(int stageId) {
        return ((RDDOperationGraphWrapper)this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)stageId))).toRDDOperationGraph();
    }

    public Seq<RDDOperationGraph> operationGraphForJob(int jobId) {
        JobDataWrapper job = (JobDataWrapper)this.store().read(JobDataWrapper.class, (Object)BoxesRunTime.boxToInteger((int)jobId));
        Seq stages = (Seq)job.info().stageIds().sorted((Ordering)Ordering.Int$.MODULE$);
        return (Seq)stages.map((Function1 & Serializable & scala.Serializable)id -> AppStatusStore.$anonfun$operationGraphForJob$1(this, job, BoxesRunTime.unboxToInt((Object)id)), Seq$.MODULE$.canBuildFrom());
    }

    public PoolData pool(String name) {
        return (PoolData)this.store().read(PoolData.class, (Object)name);
    }

    public AppSummary appSummary() {
        AppSummary appSummary;
        try {
            appSummary = (AppSummary)this.store().read(AppSummary.class, (Object)AppSummary.class.getName());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NoSuchElementException("Failed to get the application summary. If you are starting up Spark, please wait a while until it's ready.");
        }
        return appSummary;
    }

    public void close() {
        this.store().close();
        this.cleanUpStorePath();
    }

    private void cleanUpStorePath() {
        this.storePath().foreach((Function1 & Serializable & scala.Serializable)file -> {
            Utils$.MODULE$.deleteRecursively(file);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<TaskData> constructTaskDataList(Iterable<TaskDataWrapper> taskDataWrapperIter) {
        HashMap executorIdToLogs = new HashMap();
        return ((TraversableOnce)taskDataWrapperIter.map((Function1 & Serializable & scala.Serializable)taskDataWrapper -> {
            TaskData taskDataOld = taskDataWrapper.toApi();
            Map executorLogs = (Map)executorIdToLogs.getOrElseUpdate((Object)taskDataOld.executorId(), (Function0 & Serializable & scala.Serializable)() -> {
                Map map;
                try {
                    map = this.executorSummary(taskDataOld.executorId()).executorLogs();
                }
                catch (NoSuchElementException e) {
                    map = Predef$.MODULE$.Map().empty();
                }
                return map;
            });
            return new TaskData(taskDataOld.taskId(), taskDataOld.index(), taskDataOld.attempt(), taskDataOld.partitionId(), taskDataOld.launchTime(), taskDataOld.resultFetchStart(), taskDataOld.duration(), taskDataOld.executorId(), taskDataOld.host(), taskDataOld.status(), taskDataOld.taskLocality(), taskDataOld.speculative(), taskDataOld.accumulatorUpdates(), taskDataOld.errorMessage(), taskDataOld.taskMetrics(), (Map<String, String>)executorLogs, AppStatusUtils$.MODULE$.schedulerDelay(taskDataOld), AppStatusUtils$.MODULE$.gettingResultTime(taskDataOld));
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    public static final /* synthetic */ boolean $anonfun$executorList$2(ExecutorSummary x$4) {
        String string = x$4.id();
        String string2 = FallbackStorage$.MODULE$.FALLBACK_BLOCK_MANAGER_ID().executorId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public static final /* synthetic */ long $anonfun$taskSummary$2(KVStoreIterator it) {
        long _count = 0L;
        while (it.hasNext()) {
            ++_count;
            it.skip(1L);
        }
        return _count;
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$6(long count$1, CachedQuantile x$9) {
        return x$9.taskCount() == count$1;
    }

    public static final /* synthetic */ Iterable $anonfun$taskSummary$4(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, double q) {
        Object[] qkey = new Object[]{BoxesRunTime.boxToInteger((int)stageId$1), BoxesRunTime.boxToInteger((int)stageAttemptId$1), $this.quantileToString(q)};
        return Option$.MODULE$.option2Iterable($this.asOption((Function0 & Serializable & scala.Serializable)() -> (CachedQuantile)$this.store().read(CachedQuantile.class, (Object)qkey)).filter((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)AppStatusStore.$anonfun$taskSummary$6(count$1, x$9))));
    }

    private static final IndexedSeq toValues$1(Function1 fn, CachedQuantile[] cachedQuantiles$1) {
        return (IndexedSeq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cachedQuantiles$1)).map(fn, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    private final IndexedSeq scanTasks$1(String index, Function1 fn, int[] stageKey$1, long[] indices$1) {
        return (IndexedSeq)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> this.store().view(TaskDataWrapper.class).parent((Object)stageKey$1).index(index).first((Object)BoxesRunTime.boxToLong((long)0L)).closeableIterator(), (Function1 & Serializable & scala.Serializable)it -> {
            DoubleRef last = DoubleRef.create((double)Double.NaN);
            LongRef currentIdx = LongRef.create((long)-1L);
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(indices$1)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)idx -> {
                if (idx == currentIdx$1.elem) {
                    return last$1.elem;
                }
                long diff = idx - currentIdx$1.elem;
                currentIdx$1.elem = idx;
                if (it.skip(diff - 1L)) {
                    last$1.elem = BoxesRunTime.unboxToLong((Object)fn.apply(it.next()));
                    return last$1.elem;
                }
                return Double.NaN;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).toIndexedSeq();
        });
    }

    public static final /* synthetic */ long $anonfun$taskSummary$66(TaskDataWrapper m) {
        return m.shuffleLocalBytesRead() + m.shuffleRemoteBytesRead();
    }

    public static final /* synthetic */ long $anonfun$taskSummary$73(TaskDataWrapper m) {
        return m.shuffleLocalBlocksFetched() + m.shuffleRemoteBlocksFetched();
    }

    public static final /* synthetic */ boolean $anonfun$taskSummary$87(AppStatusStore $this, double[] quantiles$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            double q = tuple2._1$mcD$sp();
            return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(quantiles$2)).contains((Object)BoxesRunTime.boxToDouble((double)q)) && $this.shouldCacheQuantile(q);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$taskSummary$88(AppStatusStore $this, int stageId$1, int stageAttemptId$1, long count$1, TaskMetricDistributions computedQuantiles$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            double q = tuple2._1$mcD$sp();
            int idx = tuple2._2$mcI$sp();
            CachedQuantile cached = new CachedQuantile(stageId$1, stageAttemptId$1, $this.quantileToString(q), count$1, BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.duration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorDeserializeCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorRunTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.executorCpuTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSize().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.jvmGcTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.resultSerializationTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.gettingResultTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.schedulerDelay().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.peakExecutionMemory().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.memoryBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.diskBytesSpilled().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().bytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.inputMetrics().recordsRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().bytesWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.outputMetrics().recordsWritten().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().readRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().localBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().fetchWaitTime().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteBytesReadToDisk().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().totalBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().corruptMergedBlockChunks().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().mergedFetchFallbackCount().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedBlocksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedChunksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedChunksFetched().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().localMergedBytesRead().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().remoteReqsDuration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleReadMetrics().shufflePushReadMetricsDist().remoteMergedReqsDuration().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeBytes().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeRecords().apply(idx)), BoxesRunTime.unboxToDouble((Object)computedQuantiles$1.shuffleWriteMetrics().writeTime().apply(idx)));
            $this.store().write((Object)cached);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$rddList$2(boolean cachedOnly$1, RDDStorageInfo rdd) {
        return !cachedOnly$1 || rdd.numCachedPartitions() > 0;
    }

    public static final /* synthetic */ RDDOperationGraph $anonfun$operationGraphForJob$1(AppStatusStore $this, JobDataWrapper job$1, int id) {
        RDDOperationGraph g;
        block0: {
            g = ((RDDOperationGraphWrapper)$this.store().read(RDDOperationGraphWrapper.class, (Object)BoxesRunTime.boxToInteger((int)id))).toRDDOperationGraph();
            if (!job$1.skippedStages().contains((Object)BoxesRunTime.boxToInteger((int)id)) || g.rootCluster().name().contains("skipped")) break block0;
            g.rootCluster().setName(new StringBuilder(10).append(g.rootCluster().name()).append(" (skipped)").toString());
        }
        return g;
    }

    public AppStatusStore(KVStore store, Option<AppStatusListener> listener, Option<File> storePath) {
        this.store = store;
        this.listener = listener;
        this.storePath = storePath;
    }
}

