/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.cost;

import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.cost.ACostEstimate;
import org.apache.sysds.runtime.compress.cost.CostEstimatorBuilder;
import org.apache.sysds.runtime.compress.cost.DistinctCostEstimator;
import org.apache.sysds.runtime.compress.cost.MemoryCostEstimator;

public interface CostEstimatorFactory {
    public static ACostEstimate create(CompressionSettings cs, CostEstimatorBuilder costBuilder, int nRows, int nCols, double sparsity) {
        switch (cs.costComputationType) {
            case DISTINCT: {
                return new DistinctCostEstimator(nRows, cs, sparsity);
            }
            case HYBRID_W_TREE: {
                if (costBuilder != null) {
                    return costBuilder.createHybrid();
                }
            }
            case W_TREE: 
            case AUTO: {
                if (costBuilder == null) break;
                return costBuilder.create(cs.isInSparkInstruction);
            }
        }
        return new MemoryCostEstimator();
    }

    public static enum CostType {
        MEMORY,
        W_TREE,
        HYBRID_W_TREE,
        DISTINCT,
        AUTO;

    }
}

