/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.hops;

import org.apache.sysds.common.Types;
import org.apache.sysds.hops.Hop;
import org.apache.sysds.hops.HopsException;
import org.apache.sysds.hops.MemoTable;
import org.apache.sysds.hops.OptimizerUtils;
import org.apache.sysds.hops.rewrite.HopRewriteUtils;
import org.apache.sysds.lops.Lop;
import org.apache.sysds.lops.Nary;
import org.apache.sysds.runtime.meta.DataCharacteristics;
import org.apache.sysds.runtime.meta.MatrixCharacteristics;

public class NaryOp
extends Hop {
    protected Types.OpOpN _op = null;

    protected NaryOp() {
    }

    public NaryOp(String name, Types.DataType dataType, Types.ValueType valueType, Types.OpOpN op, Hop ... inputs) {
        super(name, dataType, valueType);
        this._op = op;
        for (int i = 0; i < inputs.length; ++i) {
            this.getInput().add(i, inputs[i]);
            inputs[i].getParent().add(this);
        }
        this.refreshSizeInformation();
    }

    @Override
    public void checkArity() {
    }

    public Types.OpOpN getOp() {
        return this._op;
    }

    @Override
    public String getOpString() {
        return "m(" + this._op.name().toLowerCase() + ")";
    }

    @Override
    public boolean isGPUEnabled() {
        return false;
    }

    @Override
    public Lop constructLops() {
        if (this.getLops() != null) {
            return this.getLops();
        }
        try {
            Lop[] inLops = new Lop[this.getInput().size()];
            for (int i = 0; i < this.getInput().size(); ++i) {
                inLops[i] = this.getInput().get(i).constructLops();
            }
            Types.ExecType et = this.optFindExecType();
            Nary multipleCPLop = new Nary(this._op, this.getDataType(), this.getValueType(), inLops, et);
            this.setOutputDimensions(multipleCPLop);
            this.setLineNumbers(multipleCPLop);
            this.setLops(multipleCPLop);
        }
        catch (Exception e) {
            throw new HopsException(this.printErrorLocation() + "error constructing Lops for NaryOp -- \n ", e);
        }
        this.constructAndSetLopsDataFlowProperties();
        return this.getLops();
    }

    @Override
    public boolean allowsAllExecTypes() {
        return false;
    }

    @Override
    public void computeMemEstimate(MemoTable memo) {
        super.computeMemEstimate(memo);
        if (this._op == Types.OpOpN.EVAL || this._op == Types.OpOpN.LIST) {
            this._memEstimate = 4.0;
            this._outputMemEstimate = 4.0;
            this._processingMemEstimate = 0.0;
        }
    }

    @Override
    protected double computeOutputMemEstimate(long dim1, long dim2, long nnz) {
        double sparsity = OptimizerUtils.getSparsity(dim1, dim2, nnz);
        return OptimizerUtils.estimateSizeExactSparsity(dim1, dim2, sparsity);
    }

    @Override
    protected Types.ExecType optFindExecType(boolean transitive) {
        this.checkAndSetForcedPlatform();
        Types.ExecType REMOTE = Types.ExecType.SPARK;
        if (this._etypeForced != null) {
            this._etype = this._etypeForced;
        } else {
            this._etype = OptimizerUtils.isMemoryBasedOptLevel() ? this.findExecTypeByMemEstimate() : (this.areDimsBelowThreshold() ? Types.ExecType.CP : REMOTE);
            this.checkAndSetInvalidCPDimsAndSize();
        }
        this.setRequiresRecompileIfNecessary();
        if (this._op == Types.OpOpN.PRINTF || this._op == Types.OpOpN.EVAL || this._op == Types.OpOpN.LIST || this._op == Types.OpOpN.CBIND && this.getInput().get(0).getDataType().isList() || this._op == Types.OpOpN.RBIND && this.getInput().get(0).getDataType().isList() || this._op.isCellOp() && this.getInput().stream().allMatch(h -> h.getDataType().isScalar())) {
            this._etype = Types.ExecType.CP;
        }
        return this._etype;
    }

    @Override
    protected double computeIntermediateMemEstimate(long dim1, long dim2, long nnz) {
        return 0.0;
    }

    @Override
    protected DataCharacteristics inferOutputCharacteristics(MemoTable memo) {
        if (!this.getDataType().isScalar() && !this.getDataType().isFrame()) {
            DataCharacteristics[] dc = memo.getAllInputStats(this.getInput());
            switch (this._op) {
                case CBIND: {
                    return new MatrixCharacteristics(HopRewriteUtils.getMaxInputDim(dc, true), HopRewriteUtils.getSumValidInputDims(dc, false), -1, HopRewriteUtils.getSumValidInputNnz(dc, true));
                }
                case RBIND: {
                    return new MatrixCharacteristics(HopRewriteUtils.getSumValidInputDims(dc, true), HopRewriteUtils.getMaxInputDim(dc, false), -1, HopRewriteUtils.getSumValidInputNnz(dc, true));
                }
                case MIN: 
                case MAX: 
                case PLUS: {
                    return new MatrixCharacteristics(HopRewriteUtils.getMaxInputDim(this, true), HopRewriteUtils.getMaxInputDim(this, false), -1, -1L);
                }
                case LIST: {
                    return new MatrixCharacteristics(this.getInput().size(), 1L, -1, -1L);
                }
            }
        }
        return null;
    }

    @Override
    public void refreshSizeInformation() {
        switch (this._op) {
            case CBIND: {
                if (this.getInput().get(0).getDataType().isList()) break;
                this.setDim1(HopRewriteUtils.getMaxInputDim(this, true));
                this.setDim2(HopRewriteUtils.getSumValidInputDims(this, false));
                this.setNnz(HopRewriteUtils.getSumValidInputNnz(this));
                break;
            }
            case RBIND: {
                if (this.getInput().get(0).getDataType().isList()) break;
                this.setDim1(HopRewriteUtils.getSumValidInputDims(this, true));
                this.setDim2(HopRewriteUtils.getMaxInputDim(this, false));
                this.setNnz(HopRewriteUtils.getSumValidInputNnz(this));
                break;
            }
            case MIN: 
            case MAX: 
            case PLUS: {
                this.setDim1(this.getDataType().isScalar() ? 0L : HopRewriteUtils.getMaxInputDim(this, true));
                this.setDim2(this.getDataType().isScalar() ? 0L : HopRewriteUtils.getMaxInputDim(this, false));
                break;
            }
            case LIST: {
                this.setDim1(this.getInput().size());
                this.setDim2(1L);
                break;
            }
        }
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NaryOp multipleOp = new NaryOp();
        multipleOp.clone(this, false);
        multipleOp._op = this._op;
        return multipleOp;
    }

    @Override
    public boolean compare(Hop that) {
        if (!(that instanceof NaryOp) || this._op == Types.OpOpN.PRINTF) {
            return false;
        }
        NaryOp that2 = (NaryOp)that;
        boolean ret = this._op == that2._op && this.getInput().size() == that2.getInput().size();
        for (int i = 0; i < this.getInput().size() && ret; ret &= this.getInput().get(i) == that2.getInput().get(i), ++i) {
        }
        return ret;
    }
}

