/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.frame.data.lib;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.stream.IntStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.frame.data.FrameBlock;
import org.apache.sysds.runtime.frame.data.columns.Array;
import org.apache.sysds.runtime.frame.data.columns.ColumnMetadata;
import org.apache.sysds.runtime.util.CommonThreadPool;

public class FrameLibApplySchema {
    protected static final Log LOG = LogFactory.getLog((String)FrameLibApplySchema.class.getName());
    private final FrameBlock fb;
    private final Types.ValueType[] schema;
    private final boolean[] nulls;
    private final int nCol;
    private final Array<?>[] columnsIn;
    private final Array<?>[] columnsOut;
    private final int k;

    public static FrameBlock applySchema(FrameBlock fb, FrameBlock schema, int k) {
        Types.ValueType[] sv = new Types.ValueType[schema.getNumColumns()];
        boolean[] nulls = new boolean[schema.getNumColumns()];
        for (int i = 0; i < schema.getNumColumns(); ++i) {
            String[] v = schema.get(0, i).toString().split("\u00b7");
            nulls[i] = v.length == 2 && v[1].equals("n");
            sv[i] = Types.ValueType.fromExternalString(v[0]);
        }
        return new FrameLibApplySchema(fb, sv, nulls, k).apply();
    }

    public static FrameBlock applySchema(FrameBlock fb, Types.ValueType[] schema) {
        return new FrameLibApplySchema(fb, schema, null, 1).apply();
    }

    public static FrameBlock applySchema(FrameBlock fb, Types.ValueType[] schema, int k) {
        return new FrameLibApplySchema(fb, schema, null, k).apply();
    }

    private FrameLibApplySchema(FrameBlock fb, Types.ValueType[] schema, boolean[] nulls, int k) {
        this.fb = fb;
        this.schema = schema;
        this.nulls = nulls;
        this.k = k;
        this.verifySize();
        this.nCol = fb.getNumColumns();
        this.columnsIn = fb.getColumns();
        this.columnsOut = new Array[this.nCol];
    }

    private FrameBlock apply() {
        if (this.k <= 1 || this.nCol == 1) {
            this.applySingleThread();
        } else {
            this.applyMultiThread();
        }
        boolean same = true;
        for (int i = 0; i < this.columnsIn.length && same; ++i) {
            same = this.columnsIn[i] == this.columnsOut[i];
        }
        if (same) {
            return this.fb;
        }
        String[] colNames = this.fb.getColumnNames(false);
        ColumnMetadata[] meta = this.fb.getColumnMetadata();
        return new FrameBlock(this.schema, colNames, meta, this.columnsOut);
    }

    private void applySingleThread() {
        for (int i = 0; i < this.nCol; ++i) {
            this.apply(i);
        }
    }

    private void apply(int i) {
        this.columnsOut[i] = this.nulls != null ? (this.nulls[i] ? this.columnsIn[i].changeTypeWithNulls(this.schema[i]) : this.columnsIn[i].changeType(this.schema[i])) : this.columnsIn[i].changeType(this.schema[i]);
    }

    private void applyMultiThread() {
        ExecutorService pool = CommonThreadPool.get(this.k);
        try {
            pool.submit(() -> IntStream.rangeClosed(0, this.nCol - 1).parallel().forEach(x -> this.apply(x))).get();
            pool.shutdown();
        }
        catch (InterruptedException | ExecutionException e) {
            pool.shutdown();
            throw new DMLRuntimeException("Failed to combine column groups", e);
        }
    }

    private void verifySize() {
        if (this.schema.length != this.fb.getSchema().length) {
            throw new DMLRuntimeException("Invalid apply schema with different number of columns expected: " + this.fb.getSchema().length + " got: " + this.schema.length);
        }
    }
}

