/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.controlprogram.parfor;

import java.util.List;
import org.apache.sysds.runtime.controlprogram.caching.CacheableData;
import org.apache.sysds.runtime.controlprogram.caching.MatrixObject;
import org.apache.sysds.runtime.controlprogram.parfor.ResultMerge;
import org.apache.sysds.runtime.data.DenseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class ResultMergeMatrix
extends ResultMerge<MatrixObject> {
    private static final long serialVersionUID = 5319002218804570071L;

    public ResultMergeMatrix() {
    }

    public ResultMergeMatrix(MatrixObject out, MatrixObject[] in, String outputFilename, boolean accum) {
        super((CacheableData)out, (CacheableData[])in, outputFilename, accum);
    }

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly) {
        this.mergeWithoutComp(out, in, appendOnly, false);
    }

    protected void mergeWithoutComp(MatrixBlock out, MatrixBlock in, boolean appendOnly, boolean par) {
        if (this._isAccum) {
            out.binaryOperationsInPlace(PLUS, in);
        } else {
            out.merge(in, appendOnly, par);
        }
    }

    protected void mergeWithComp(MatrixBlock out, MatrixBlock in, DenseBlock compare) {
        if (in.isEmptyBlock(false)) {
            if (this._isAccum) {
                return;
            }
            for (int i = 0; i < in.getNumRows(); ++i) {
                for (int j = 0; j < in.getNumColumns(); ++j) {
                    if (compare.get(i, j) == 0.0) continue;
                    out.quickSetValue(i, j, 0.0);
                }
            }
        } else {
            int rows = in.getNumRows();
            int cols = in.getNumColumns();
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    double valOld = compare.get(i, j);
                    double valNew = in.quickGetValue(i, j);
                    if ((valNew == valOld || Double.isNaN(valNew)) && Double.isNaN(valNew) == Double.isNaN(valOld)) continue;
                    double value = !this._isAccum ? valNew : out.quickGetValue(i, j) + (valNew - valOld);
                    out.quickSetValue(i, j, value);
                }
            }
        }
    }

    protected long computeNonZeros(MatrixObject out, List<MatrixObject> in) {
        long outNNZ = out.getDataCharacteristics().getNonZeros();
        return outNNZ - (long)in.size() * outNNZ + in.stream().mapToLong(m -> m.getDataCharacteristics().getNonZeros()).sum();
    }
}

