/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.estim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.CompressionSettings;
import org.apache.sysds.runtime.compress.DMLCompressionException;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfo;
import org.apache.sysds.runtime.compress.estim.CompressedSizeInfoColGroup;
import org.apache.sysds.runtime.compress.utils.Util;
import org.apache.sysds.runtime.controlprogram.parfor.stat.Timing;
import org.apache.sysds.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;
import org.apache.sysds.runtime.util.CommonThreadPool;

public abstract class CompressedSizeEstimator {
    protected static final Log LOG = LogFactory.getLog((String)CompressedSizeEstimator.class.getName());
    protected final MatrixBlock _data;
    protected final CompressionSettings _cs;
    protected int[] nnzCols;

    protected CompressedSizeEstimator(MatrixBlock data, CompressionSettings cs) {
        this._data = data;
        this._cs = cs;
    }

    protected int getNumRows() {
        return this._cs.transposed ? this._data.getNumColumns() : this._data.getNumRows();
    }

    protected int getNumColumns() {
        return this._cs.transposed ? this._data.getNumRows() : this._data.getNumColumns();
    }

    public final CompressedSizeInfo computeCompressedSizeInfos(int k) {
        int _numCols = this.getNumColumns();
        if (LOG.isDebugEnabled()) {
            Timing time = new Timing(true);
            CompressedSizeInfo ret = new CompressedSizeInfo(this.CompressedSizeInfoColGroup(_numCols, k));
            LOG.debug((Object)("CompressedSizeInfo for each column [ms]:" + time.stop()));
            return ret;
        }
        return new CompressedSizeInfo(this.CompressedSizeInfoColGroup(_numCols, k));
    }

    public final CompressedSizeInfoColGroup getColGroupInfo(int[] colIndexes) {
        return this.getColGroupInfo(colIndexes, 8, this.worstCaseUpperBound(colIndexes));
    }

    public abstract CompressedSizeInfoColGroup getColGroupInfo(int[] var1, int var2, int var3);

    public final CompressedSizeInfoColGroup getDeltaColGroupInfo(int[] colIndexes) {
        return this.getDeltaColGroupInfo(colIndexes, 8, this.worstCaseUpperBound(colIndexes));
    }

    public abstract CompressedSizeInfoColGroup getDeltaColGroupInfo(int[] var1, int var2, int var3);

    public final CompressedSizeInfoColGroup combine(CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        int[] combinedColIndexes = Util.combine(g1.getColumns(), g2.getColumns());
        return this.combine(combinedColIndexes, g1, g2);
    }

    public final CompressedSizeInfoColGroup combine(int[] combinedColumns, CompressedSizeInfoColGroup g1, CompressedSizeInfoColGroup g2) {
        int worstCase;
        int g2V;
        int nRows = g1.getNumRows();
        int g1V = g1.getNumVals() + (g1.getNumOffs() < nRows ? 1 : 0);
        long max = Math.min((long)g1V * (long)(g2V = g2.getNumVals() + (g2.getNumOffs() < nRows ? 1 : 0)), (long)(worstCase = this.worstCaseUpperBound(combinedColumns)));
        if (max > 1000000L) {
            return null;
        }
        if (g1.getMap() == null || g2.getMap() == null) {
            return this.getColGroupInfo(combinedColumns, Math.max(g1V, g2V), (int)max);
        }
        return this.combine(combinedColumns, g1, g2, (int)max);
    }

    public void clearNNZ() {
        this.nnzCols = null;
    }

    protected abstract int worstCaseUpperBound(int[] var1);

    protected abstract CompressedSizeInfoColGroup combine(int[] var1, CompressedSizeInfoColGroup var2, CompressedSizeInfoColGroup var3, int var4);

    private List<CompressedSizeInfoColGroup> CompressedSizeInfoColGroup(int clen, int k) {
        if (k <= 1) {
            return this.CompressedSizeInfoColGroupSingleThread(clen);
        }
        return this.CompressedSizeInfoColGroupParallel(clen, k);
    }

    private List<CompressedSizeInfoColGroup> CompressedSizeInfoColGroupSingleThread(int clen) {
        ArrayList<CompressedSizeInfoColGroup> ret = new ArrayList<CompressedSizeInfoColGroup>(clen);
        if (!this._cs.transposed && !this._data.isEmpty() && this._data.isInSparseFormat()) {
            this.nnzCols = LibMatrixReorg.countNnzPerColumn(this._data);
        }
        int col = 0;
        while (col < clen) {
            ret.add(this.getColGroupInfo(new int[]{col++}));
        }
        return ret;
    }

    private List<CompressedSizeInfoColGroup> CompressedSizeInfoColGroupParallel(int clen, int k) {
        try {
            ExecutorService pool = CommonThreadPool.get(k);
            if (!this._cs.transposed && !this._data.isEmpty() && this._data.isInSparseFormat()) {
                LOG.debug((Object)"Extracting number of nonzeros in each column");
                List<Future<int[]>> nnzFutures = LibMatrixReorg.countNNZColumnsFuture(this._data, k, pool);
                for (Future<int[]> t : nnzFutures) {
                    this.nnzCols = LibMatrixReorg.mergeNnzCounts(this.nnzCols, t.get());
                }
            }
            CompressedSizeInfoColGroup[] res = new CompressedSizeInfoColGroup[clen];
            int blkz = Math.max(1, clen / (k * 10));
            ArrayList<SizeEstimationTask> tasks = new ArrayList<SizeEstimationTask>(clen / blkz + 1);
            if (blkz != 1) {
                LOG.debug((Object)("Extracting column samples in blocks of " + blkz));
            }
            for (int col = 0; col < clen; col += blkz) {
                tasks.add(new SizeEstimationTask(res, col, Math.min(clen, col + blkz)));
            }
            for (Future f : pool.invokeAll(tasks)) {
                f.get();
            }
            pool.shutdown();
            return Arrays.asList(res);
        }
        catch (Exception e) {
            throw new DMLCompressionException("Multithreaded first extraction failed", e);
        }
    }

    private class SizeEstimationTask
    implements Callable<Object> {
        final CompressedSizeInfoColGroup[] _res;
        final int _cs;
        final int _ce;

        private SizeEstimationTask(CompressedSizeInfoColGroup[] res, int cs, int ce) {
            this._res = res;
            this._cs = cs;
            this._ce = ce;
        }

        @Override
        public Object call() {
            try {
                for (int c = this._cs; c < this._ce; ++c) {
                    this._res[c] = CompressedSizeEstimator.this.getColGroupInfo(new int[]{c});
                }
                return null;
            }
            catch (Exception e) {
                throw new DMLCompressionException("ColGroup extraction failed", e);
            }
        }
    }
}

