/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.compress.colgroup.dictionary;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sysds.runtime.compress.colgroup.dictionary.ADictionary;
import org.apache.sysds.runtime.data.SparseBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public class DictLibMatrixMult {
    static final Log LOG = LogFactory.getLog((String)DictLibMatrixMult.class.getName());

    private DictLibMatrixMult() {
    }

    public static void addToUpperTriangle(int nCols, int row, int col, double[] res, double val) {
        if (row == col) {
            int n = row * nCols + col;
            res[n] = res[n] + (val + val);
        } else if (row > col) {
            int n = col * nCols + row;
            res[n] = res[n] + val;
        } else {
            int n = row * nCols + col;
            res[n] = res[n] + val;
        }
    }

    public static void MMDictsWithScaling(ADictionary left, ADictionary right, int[] leftRows, int[] rightColumns, MatrixBlock result, int[] counts) {
        LOG.warn((Object)"Inefficient double allocation of dictionary");
        boolean modifyRight = right.getInMemorySize() > left.getInMemorySize();
        ADictionary rightM = modifyRight ? right.scaleTuples(counts, rightColumns.length) : right;
        ADictionary leftM = modifyRight ? left : left.scaleTuples(counts, leftRows.length);
        DictLibMatrixMult.MMDicts(leftM, rightM, leftRows, rightColumns, result);
    }

    public static void TSMMDictionaryWithScaling(ADictionary dict, int[] counts, int[] rows, int[] cols, MatrixBlock ret) {
        dict.TSMMWithScaling(counts, rows, cols, ret);
    }

    public static void MMDicts(ADictionary left, ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        left.MMDict(right, rowsLeft, colsRight, result);
    }

    public static void TSMMToUpperTriangle(ADictionary left, ADictionary right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        left.TSMMToUpperTriangle(right, rowsLeft, colsRight, result);
    }

    public static void TSMMToUpperTriangleScaling(ADictionary left, ADictionary right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        left.TSMMToUpperTriangleScaling(left, rowsLeft, colsRight, scale, result);
    }

    protected static void TSMMDictsDenseWithScaling(double[] dv, int[] rowsLeft, int[] colsRight, int[] scaling, MatrixBlock result) {
        int commonDim = Math.min(dv.length / rowsLeft.length, dv.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            int scale = scaling[k];
            for (int i = 0; i < rowsLeft.length; ++i) {
                int offOut = rowsLeft[i] * resCols;
                double vl = dv[offL + i] * (double)scale;
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + vl * dv[offR + j];
                }
            }
        }
    }

    protected static void TSMMDictsSparseWithScaling(SparseBlock sb, int[] rowsLeft, int[] colsRight, int[] scaling, MatrixBlock result) {
        int commonDim = sb.numRows();
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (sb.isEmpty(i)) continue;
            int apos = sb.pos(i);
            int alen = sb.size(i) + apos;
            int[] aix = sb.indexes(i);
            double[] avals = sb.values(i);
            int scale = scaling[i];
            for (int k = apos; k < alen; ++k) {
                double v = avals[k] * (double)scale;
                int offOut = rowsLeft[aix[k]] * resCols;
                for (int j = apos; j < alen; ++j) {
                    int n = offOut + colsRight[aix[j]];
                    resV[n] = resV[n] + v * avals[j];
                }
            }
        }
    }

    protected static void MMDictsDenseDense(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int offOut = rowsLeft[i] * resCols;
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMDictsSparseDense(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int offOut = rowsLeft[aix[k]] * result.getNumColumns();
                double v = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = offOut + colsRight[j];
                    resV[n] = resV[n] + v * right[offRight + j];
                }
            }
        }
    }

    protected static void MMDictsDenseSparse(double[] left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.length, right.numRows());
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.length;
            for (int j = 0; j < rowsLeft.length; ++j) {
                int offOut = rowsLeft[j] * result.getNumColumns();
                double v = left[offLeft + j];
                if (v == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    int n = offOut + colsRight[aix[k]];
                    resV[n] = resV[n] + v * rightVals[k];
                }
            }
        }
    }

    protected static void MMDictsSparseSparse(SparseBlock left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        double[] resV = result.getDenseBlockValues();
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            for (int k = leftAPos; k < leftAlen; ++k) {
                int offOut = rowsLeft[leftAix[k]] * resCols;
                double v = leftVals[k];
                for (int j = rightAPos; j < rightAlen; ++j) {
                    int n = offOut + colsRight[rightAix[j]];
                    resV[n] = resV[n] + v * rightVals[j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseSparse(SparseBlock left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            for (int k = leftAPos; k < leftAlen; ++k) {
                int rowOut = rowsLeft[leftAix[k]];
                double vl = leftVals[k];
                for (int j = rightAPos; j < rightAlen; ++j) {
                    double vr = rightVals[j];
                    int colOut = colsRight[rightAix[j]];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseSparse(double[] left, SparseBlock right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.length, right.numRows());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.length;
            for (int j = 0; j < rowsLeft.length; ++j) {
                int rowOut = rowsLeft[j];
                double vl = left[offLeft + j];
                if (vl == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    double vr = rightVals[k];
                    int colOut = colsRight[aix[k]];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDense(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int loc = DictLibMatrixMult.location(rowsLeft, colsRight);
        if (loc < 0) {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseAllUpperTriangle(left, right, rowsLeft, colsRight, result);
        } else if (loc > 0) {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseAllLowerTriangle(left, right, rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleSparseDenseDiagonal(left, right, rowsLeft, colsRight, result);
        }
    }

    protected static void MMToUpperTriangleSparseDenseAllUpperTriangle(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft[aix[k]];
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = colsRight[j] * resCols + rowOut;
                    resV[n] = resV[n] + vl * right[offRight + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDenseAllLowerTriangle(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft[aix[k]] * resCols;
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = colsRight[j] + rowOut;
                    resV[n] = resV[n] + vl * right[offRight + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleSparseDenseDiagonal(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft[aix[k]];
                double vl = leftVals[k];
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offRight + j];
                    int colOut = colsRight[j];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseDense(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int loc = DictLibMatrixMult.location(rowsLeft, colsRight);
        if (loc < 0) {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseAllUpperTriangle(left, right, rowsLeft, colsRight, result);
        } else if (loc > 0) {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseAllLowerTriangle(left, right, rowsLeft, colsRight, result);
        } else {
            DictLibMatrixMult.MMToUpperTriangleDenseDenseDiagonal(left, right, rowsLeft, colsRight, result);
        }
    }

    protected static void MMToUpperTriangleDenseDenseAllUpperTriangle(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int rowOut = rowsLeft[i];
                double vl = left[offL + i];
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = colsRight[j] * resCols + rowOut;
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseDenseAllLowerTriangle(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int rowOut = rowsLeft[i] * resCols;
                double vl = left[offL + i];
                for (int j = 0; j < colsRight.length; ++j) {
                    int n = colsRight[j] + rowOut;
                    resV[n] = resV[n] + vl * right[offR + j];
                }
            }
        }
    }

    protected static void MMToUpperTriangleDenseDenseDiagonal(double[] left, double[] right, int[] rowsLeft, int[] colsRight, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            for (int i = 0; i < rowsLeft.length; ++i) {
                int rowOut = rowsLeft[i];
                double vl = left[offL + i];
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offR + j];
                    int colOut = colsRight[j];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleSparseSparseScaling(SparseBlock left, SparseBlock right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        int commonDim = Math.min(left.numRows(), right.numRows());
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i) || right.isEmpty(i)) continue;
            int leftAPos = left.pos(i);
            int leftAlen = left.size(i) + leftAPos;
            int[] leftAix = left.indexes(i);
            double[] leftVals = left.values(i);
            int rightAPos = right.pos(i);
            int rightAlen = right.size(i) + rightAPos;
            int[] rightAix = right.indexes(i);
            double[] rightVals = right.values(i);
            double sv = scale[i];
            for (int k = leftAPos; k < leftAlen; ++k) {
                int rowOut = rowsLeft[leftAix[k]];
                double vl = leftVals[k] * sv;
                for (int j = rightAPos; j < rightAlen; ++j) {
                    double vr = rightVals[j];
                    int colOut = colsRight[rightAix[j]];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleDenseSparseScaling(double[] left, SparseBlock right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.length / rowsLeft.length, right.numRows());
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (right.isEmpty(i)) continue;
            int apos = right.pos(i);
            int alen = right.size(i) + apos;
            int[] aix = right.indexes(i);
            double[] rightVals = right.values(i);
            int offLeft = i * rowsLeft.length;
            double sv = scale[i];
            for (int j = 0; j < rowsLeft.length; ++j) {
                int rowOut = rowsLeft[j];
                double vl = left[offLeft + j] * sv;
                if (vl == 0.0) continue;
                for (int k = apos; k < alen; ++k) {
                    double vr = rightVals[k];
                    int colOut = colsRight[aix[k]];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleSparseDenseScaling(SparseBlock left, double[] right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        double[] resV = result.getDenseBlockValues();
        int commonDim = Math.min(left.numRows(), right.length / colsRight.length);
        int resCols = result.getNumColumns();
        for (int i = 0; i < commonDim; ++i) {
            if (left.isEmpty(i)) continue;
            int apos = left.pos(i);
            int alen = left.size(i) + apos;
            int[] aix = left.indexes(i);
            double[] leftVals = left.values(i);
            int offRight = i * colsRight.length;
            double sv = scale[i];
            for (int k = apos; k < alen; ++k) {
                int rowOut = rowsLeft[aix[k]];
                double vl = leftVals[k] * sv;
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offRight + j];
                    int colOut = colsRight[j];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    protected static void TSMMToUpperTriangleDenseDenseScaling(double[] left, double[] right, int[] rowsLeft, int[] colsRight, int[] scale, MatrixBlock result) {
        int commonDim = Math.min(left.length / rowsLeft.length, right.length / colsRight.length);
        int resCols = result.getNumColumns();
        double[] resV = result.getDenseBlockValues();
        for (int k = 0; k < commonDim; ++k) {
            int offL = k * rowsLeft.length;
            int offR = k * colsRight.length;
            int sv = scale[k];
            for (int i = 0; i < rowsLeft.length; ++i) {
                int rowOut = rowsLeft[i];
                double vl = left[offL + i] * (double)sv;
                if (vl == 0.0) continue;
                for (int j = 0; j < colsRight.length; ++j) {
                    double vr = right[offR + j];
                    int colOut = colsRight[j];
                    DictLibMatrixMult.addToUpperTriangle(resCols, rowOut, colOut, resV, vl * vr);
                }
            }
        }
    }

    private static int location(int[] leftRows, int[] rightColumns) {
        int firstRow = leftRows[0];
        int firstCol = rightColumns[0];
        int lastRow = leftRows[leftRows.length - 1];
        int lastCol = rightColumns[rightColumns.length - 1];
        int locationLower = DictLibMatrixMult.location(lastRow, firstCol);
        int locationHigher = DictLibMatrixMult.location(firstRow, lastCol);
        if (locationLower > 0) {
            return 1;
        }
        if (locationHigher < 0) {
            return -1;
        }
        return 0;
    }

    private static int location(int row, int col) {
        if (row == col) {
            return 0;
        }
        if (row < col) {
            return 1;
        }
        return -1;
    }
}

