/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.transform.decode;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.sysds.common.Types;
import org.apache.sysds.runtime.DMLRuntimeException;
import org.apache.sysds.runtime.matrix.data.FrameBlock;
import org.apache.sysds.runtime.matrix.data.MatrixBlock;

public abstract class Decoder
implements Externalizable {
    private static final long serialVersionUID = -1732411001366177787L;
    protected Types.ValueType[] _schema;
    protected int[] _colList;
    protected String[] _colnames = null;

    protected Decoder(Types.ValueType[] schema, int[] colList) {
        this._schema = schema;
        this._colList = colList;
    }

    public Types.ValueType[] getSchema() {
        return this._schema;
    }

    public void setColnames(String[] colnames) {
        this._colnames = colnames;
    }

    public String[] getColnames() {
        return this._colnames;
    }

    public abstract FrameBlock decode(MatrixBlock var1, FrameBlock var2);

    public Decoder subRangeDecoder(int colStart, int colEnd, int dummycodedOffset) {
        throw new DMLRuntimeException(this.getClass().getSimpleName() + " does not support the creation of a sub-range decoder");
    }

    public void updateIndexRanges(long[] beginDims, long[] endDims) {
    }

    public abstract void initMetaData(FrameBlock var1);

    @Override
    public void writeExternal(ObjectOutput os) throws IOException {
        int size1 = this._colList == null ? 0 : this._colList.length;
        os.writeInt(size1);
        for (int i = 0; i < size1; ++i) {
            os.writeInt(this._colList[i]);
        }
        int size2 = this._colnames == null ? 0 : this._colnames.length;
        os.writeInt(size2);
        for (int j = 0; j < size2; ++j) {
            os.writeUTF(this._colnames[j]);
        }
        int size3 = this._schema == null ? 0 : this._schema.length;
        os.writeInt(size3);
        for (int j = 0; j < size3; ++j) {
            os.writeByte(this._schema[j].ordinal());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size1 = in.readInt();
        this._colList = size1 == 0 ? null : new int[size1];
        for (int i = 0; i < size1; ++i) {
            this._colList[i] = in.readInt();
        }
        int size2 = in.readInt();
        this._colnames = size2 == 0 ? null : new String[size2];
        for (int j = 0; j < size2; ++j) {
            this._colnames[j] = in.readUTF();
        }
        int size3 = in.readInt();
        this._schema = size3 == 0 ? null : new Types.ValueType[size3];
        for (int j = 0; j < size3; ++j) {
            this._schema[j] = Types.ValueType.values()[in.readByte()];
        }
    }
}

