/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysds.runtime.lineage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.sysds.parser.ParseException;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysds.runtime.controlprogram.context.ExecutionContextFactory;
import org.apache.sysds.runtime.instructions.Instruction;
import org.apache.sysds.runtime.instructions.InstructionParser;
import org.apache.sysds.runtime.lineage.LineageItem;
import org.apache.sysds.runtime.lineage.LineageItemUtils;
import org.apache.sysds.runtime.lineage.LineageRecomputeUtils;
import org.apache.sysds.runtime.lineage.LineageTokenizer;
import org.apache.sysds.runtime.lineage.LineageTraceable;

public class LineageParser {
    public static final LineageTokenizer lineageTraceTokenizer = new LineageTokenizer();

    public static LineageItem parseLineageTrace(String str) {
        return LineageParser.parseLineageTrace(str, null);
    }

    public static LineageItem parseLineageTrace(String str, String name) {
        ExecutionContext ec = ExecutionContextFactory.createContext();
        LineageItem li = null;
        HashMap<Long, LineageItem> map = new HashMap<Long, LineageItem>();
        for (String line : str.split("\\r?\\n")) {
            li = null;
            Map<String, String> tokens = lineageTraceTokenizer.tokenize(line);
            Long id = Long.valueOf(tokens.get("id"));
            LineageItem.LineageItemType type = LineageItemUtils.getType(tokens.get("type"));
            String representation = tokens.get("representation");
            switch (type) {
                case Creation: {
                    if (representation.startsWith("IN#")) {
                        li = new LineageItem(id, representation, "Create" + representation);
                        break;
                    }
                    Instruction inst = InstructionParser.parseSingleInstruction(representation);
                    if (!(inst instanceof LineageTraceable)) {
                        throw new ParseException("Invalid Instruction (" + inst.getOpcode() + ") traced");
                    }
                    Pair<String, LineageItem> item = ((LineageTraceable)((Object)inst)).getLineageItem(ec);
                    if (item == null) {
                        throw new ParseException("Instruction without output (" + inst.getOpcode() + ") not supported");
                    }
                    li = new LineageItem((long)id, (LineageItem)item.getValue());
                    break;
                }
                case Literal: {
                    li = new LineageItem((long)id, representation);
                    break;
                }
                case Instruction: 
                case Dedup: {
                    li = LineageParser.parseLineageInstruction(id, representation, map, name);
                    break;
                }
                default: {
                    throw new ParseException("Invalid LineageItemType given");
                }
            }
            map.put(id, li);
        }
        return li;
    }

    private static LineageItem parseLineageInstruction(Long id, String str, Map<Long, LineageItem> map, String name) {
        String[] tokens = str.split(" ");
        if (tokens.length < 2) {
            throw new ParseException("Invalid length ot lineage item " + tokens.length + ".");
        }
        String opcode = tokens[0];
        ArrayList<LineageItem> inputs = new ArrayList<LineageItem>();
        int specialValueBits = 0;
        for (int i = 1; i < tokens.length; ++i) {
            String token = tokens[i];
            if (token.startsWith("(") && token.endsWith(")")) {
                token = token.substring(1, token.length() - 1);
                inputs.add(map.get(Long.valueOf(token)));
                continue;
            }
            if (token.startsWith("[") && token.endsWith("]")) {
                token = token.substring(1, token.length() - 1);
                specialValueBits = Integer.parseInt(token);
                continue;
            }
            throw new ParseException("Invalid format for LineageItem reference");
        }
        return new LineageItem(id, "", opcode, inputs.toArray(new LineageItem[0]), specialValueBits);
    }

    protected static void parseLineageTraceDedup(String str) {
        String[] allPatches;
        str.replaceAll("\r\n", "\n");
        for (String patch : allPatches = str.split("\n\n")) {
            String[] headBody = patch.split("\r\n|\r|\n", 2);
            String[] parts = headBody[0].split("_");
            LineageItem patchLi = LineageParser.parseLineageTrace(headBody[1]);
            Long pathId = Long.parseLong(parts[3]);
            String loopName = parts[2];
            if (!LineageRecomputeUtils.loopPatchMap.containsKey(loopName)) {
                LineageRecomputeUtils.loopPatchMap.put(loopName, new LineageRecomputeUtils.DedupLoopItem(loopName));
            }
            LineageRecomputeUtils.DedupLoopItem loopItem = LineageRecomputeUtils.loopPatchMap.get(loopName);
            if (!loopItem.patchLiMap.containsKey(pathId)) {
                loopItem.patchLiMap.put(pathId, new HashMap());
            }
            loopItem.patchLiMap.get(pathId).put(parts[1], patchLi);
        }
    }

    static {
        lineageTraceTokenizer.add("\\(");
        lineageTraceTokenizer.add("[0-9]+", "id");
        lineageTraceTokenizer.add("\\) \\(");
        lineageTraceTokenizer.add("L|C|I|D", "type");
        lineageTraceTokenizer.add("\\) ");
        lineageTraceTokenizer.add(".+", "representation");
    }
}

